/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplaceRouteRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ReplaceRouteRequest> {
    private static final SdkField<String> DESTINATION_PREFIX_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationPrefixListId").getter(ReplaceRouteRequest.getter(ReplaceRouteRequest::destinationPrefixListId)).setter(ReplaceRouteRequest.setter(Builder::destinationPrefixListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPrefixListId").unmarshallLocationName("DestinationPrefixListId").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEndpointId").getter(ReplaceRouteRequest.getter(ReplaceRouteRequest::vpcEndpointId)).setter(ReplaceRouteRequest.setter(Builder::vpcEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").unmarshallLocationName("VpcEndpointId").build()}).build();
    private static final SdkField<Boolean> LOCAL_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("LocalTarget").getter(ReplaceRouteRequest.getter(ReplaceRouteRequest::localTarget)).setter(ReplaceRouteRequest.setter(Builder::localTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalTarget").unmarshallLocationName("LocalTarget").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayId").getter(ReplaceRouteRequest.getter(ReplaceRouteRequest::transitGatewayId)).setter(ReplaceRouteRequest.setter(Builder::transitGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId").unmarshallLocationName("TransitGatewayId").build()}).build();
    private static final SdkField<String> LOCAL_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalGatewayId").getter(ReplaceRouteRequest.getter(ReplaceRouteRequest::localGatewayId)).setter(ReplaceRouteRequest.setter(Builder::localGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayId").unmarshallLocationName("LocalGatewayId").build()}).build();
    private static final SdkField<String> CARRIER_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CarrierGatewayId").getter(ReplaceRouteRequest.getter(ReplaceRouteRequest::carrierGatewayId)).setter(ReplaceRouteRequest.setter(Builder::carrierGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CarrierGatewayId").unmarshallLocationName("CarrierGatewayId").build()}).build();
    private static final SdkField<String> CORE_NETWORK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CoreNetworkArn").getter(ReplaceRouteRequest.getter(ReplaceRouteRequest::coreNetworkArn)).setter(ReplaceRouteRequest.setter(Builder::coreNetworkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkArn").unmarshallLocationName("CoreNetworkArn").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ReplaceRouteRequest.getter(ReplaceRouteRequest::dryRun)).setter(ReplaceRouteRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("dryRun").build()}).build();
    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteTableId").getter(ReplaceRouteRequest.getter(ReplaceRouteRequest::routeTableId)).setter(ReplaceRouteRequest.setter(Builder::routeTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").unmarshallLocationName("routeTableId").build()}).build();
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationCidrBlock").getter(ReplaceRouteRequest.getter(ReplaceRouteRequest::destinationCidrBlock)).setter(ReplaceRouteRequest.setter(Builder::destinationCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock").unmarshallLocationName("destinationCidrBlock").build()}).build();
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayId").getter(ReplaceRouteRequest.getter(ReplaceRouteRequest::gatewayId)).setter(ReplaceRouteRequest.setter(Builder::gatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId").unmarshallLocationName("gatewayId").build()}).build();
    private static final SdkField<String> DESTINATION_IPV6_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationIpv6CidrBlock").getter(ReplaceRouteRequest.getter(ReplaceRouteRequest::destinationIpv6CidrBlock)).setter(ReplaceRouteRequest.setter(Builder::destinationIpv6CidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationIpv6CidrBlock").unmarshallLocationName("destinationIpv6CidrBlock").build()}).build();
    private static final SdkField<String> EGRESS_ONLY_INTERNET_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EgressOnlyInternetGatewayId").getter(ReplaceRouteRequest.getter(ReplaceRouteRequest::egressOnlyInternetGatewayId)).setter(ReplaceRouteRequest.setter(Builder::egressOnlyInternetGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EgressOnlyInternetGatewayId").unmarshallLocationName("egressOnlyInternetGatewayId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(ReplaceRouteRequest.getter(ReplaceRouteRequest::instanceId)).setter(ReplaceRouteRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(ReplaceRouteRequest.getter(ReplaceRouteRequest::networkInterfaceId)).setter(ReplaceRouteRequest.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<String> VPC_PEERING_CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcPeeringConnectionId").getter(ReplaceRouteRequest.getter(ReplaceRouteRequest::vpcPeeringConnectionId)).setter(ReplaceRouteRequest.setter(Builder::vpcPeeringConnectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringConnectionId").unmarshallLocationName("vpcPeeringConnectionId").build()}).build();
    private static final SdkField<String> NAT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NatGatewayId").getter(ReplaceRouteRequest.getter(ReplaceRouteRequest::natGatewayId)).setter(ReplaceRouteRequest.setter(Builder::natGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayId").unmarshallLocationName("natGatewayId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_PREFIX_LIST_ID_FIELD, VPC_ENDPOINT_ID_FIELD, LOCAL_TARGET_FIELD, TRANSIT_GATEWAY_ID_FIELD, LOCAL_GATEWAY_ID_FIELD, CARRIER_GATEWAY_ID_FIELD, CORE_NETWORK_ARN_FIELD, DRY_RUN_FIELD, ROUTE_TABLE_ID_FIELD, DESTINATION_CIDR_BLOCK_FIELD, GATEWAY_ID_FIELD, DESTINATION_IPV6_CIDR_BLOCK_FIELD, EGRESS_ONLY_INTERNET_GATEWAY_ID_FIELD, INSTANCE_ID_FIELD, NETWORK_INTERFACE_ID_FIELD, VPC_PEERING_CONNECTION_ID_FIELD, NAT_GATEWAY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReplaceRouteRequest.memberNameToFieldInitializer();
    private final String destinationPrefixListId;
    private final String vpcEndpointId;
    private final Boolean localTarget;
    private final String transitGatewayId;
    private final String localGatewayId;
    private final String carrierGatewayId;
    private final String coreNetworkArn;
    private final Boolean dryRun;
    private final String routeTableId;
    private final String destinationCidrBlock;
    private final String gatewayId;
    private final String destinationIpv6CidrBlock;
    private final String egressOnlyInternetGatewayId;
    private final String instanceId;
    private final String networkInterfaceId;
    private final String vpcPeeringConnectionId;
    private final String natGatewayId;

    private ReplaceRouteRequest(BuilderImpl builder) {
        super(builder);
        this.destinationPrefixListId = builder.destinationPrefixListId;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.localTarget = builder.localTarget;
        this.transitGatewayId = builder.transitGatewayId;
        this.localGatewayId = builder.localGatewayId;
        this.carrierGatewayId = builder.carrierGatewayId;
        this.coreNetworkArn = builder.coreNetworkArn;
        this.dryRun = builder.dryRun;
        this.routeTableId = builder.routeTableId;
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.gatewayId = builder.gatewayId;
        this.destinationIpv6CidrBlock = builder.destinationIpv6CidrBlock;
        this.egressOnlyInternetGatewayId = builder.egressOnlyInternetGatewayId;
        this.instanceId = builder.instanceId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
        this.natGatewayId = builder.natGatewayId;
    }

    public final String destinationPrefixListId() {
        return this.destinationPrefixListId;
    }

    public final String vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public final Boolean localTarget() {
        return this.localTarget;
    }

    public final String transitGatewayId() {
        return this.transitGatewayId;
    }

    public final String localGatewayId() {
        return this.localGatewayId;
    }

    public final String carrierGatewayId() {
        return this.carrierGatewayId;
    }

    public final String coreNetworkArn() {
        return this.coreNetworkArn;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String routeTableId() {
        return this.routeTableId;
    }

    public final String destinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    public final String gatewayId() {
        return this.gatewayId;
    }

    public final String destinationIpv6CidrBlock() {
        return this.destinationIpv6CidrBlock;
    }

    public final String egressOnlyInternetGatewayId() {
        return this.egressOnlyInternetGatewayId;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final String vpcPeeringConnectionId() {
        return this.vpcPeeringConnectionId;
    }

    public final String natGatewayId() {
        return this.natGatewayId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPrefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.carrierGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.coreNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationIpv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.egressOnlyInternetGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcPeeringConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.natGatewayId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplaceRouteRequest)) {
            return false;
        }
        ReplaceRouteRequest other = (ReplaceRouteRequest)((Object)obj);
        return Objects.equals(this.destinationPrefixListId(), other.destinationPrefixListId()) && Objects.equals(this.vpcEndpointId(), other.vpcEndpointId()) && Objects.equals(this.localTarget(), other.localTarget()) && Objects.equals(this.transitGatewayId(), other.transitGatewayId()) && Objects.equals(this.localGatewayId(), other.localGatewayId()) && Objects.equals(this.carrierGatewayId(), other.carrierGatewayId()) && Objects.equals(this.coreNetworkArn(), other.coreNetworkArn()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.routeTableId(), other.routeTableId()) && Objects.equals(this.destinationCidrBlock(), other.destinationCidrBlock()) && Objects.equals(this.gatewayId(), other.gatewayId()) && Objects.equals(this.destinationIpv6CidrBlock(), other.destinationIpv6CidrBlock()) && Objects.equals(this.egressOnlyInternetGatewayId(), other.egressOnlyInternetGatewayId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.vpcPeeringConnectionId(), other.vpcPeeringConnectionId()) && Objects.equals(this.natGatewayId(), other.natGatewayId());
    }

    public final String toString() {
        return ToString.builder((String)"ReplaceRouteRequest").add("DestinationPrefixListId", (Object)this.destinationPrefixListId()).add("VpcEndpointId", (Object)this.vpcEndpointId()).add("LocalTarget", (Object)this.localTarget()).add("TransitGatewayId", (Object)this.transitGatewayId()).add("LocalGatewayId", (Object)this.localGatewayId()).add("CarrierGatewayId", (Object)this.carrierGatewayId()).add("CoreNetworkArn", (Object)this.coreNetworkArn()).add("DryRun", (Object)this.dryRun()).add("RouteTableId", (Object)this.routeTableId()).add("DestinationCidrBlock", (Object)this.destinationCidrBlock()).add("GatewayId", (Object)this.gatewayId()).add("DestinationIpv6CidrBlock", (Object)this.destinationIpv6CidrBlock()).add("EgressOnlyInternetGatewayId", (Object)this.egressOnlyInternetGatewayId()).add("InstanceId", (Object)this.instanceId()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("VpcPeeringConnectionId", (Object)this.vpcPeeringConnectionId()).add("NatGatewayId", (Object)this.natGatewayId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationPrefixListId": {
                return Optional.ofNullable(clazz.cast(this.destinationPrefixListId()));
            }
            case "VpcEndpointId": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointId()));
            }
            case "LocalTarget": {
                return Optional.ofNullable(clazz.cast(this.localTarget()));
            }
            case "TransitGatewayId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayId()));
            }
            case "LocalGatewayId": {
                return Optional.ofNullable(clazz.cast(this.localGatewayId()));
            }
            case "CarrierGatewayId": {
                return Optional.ofNullable(clazz.cast(this.carrierGatewayId()));
            }
            case "CoreNetworkArn": {
                return Optional.ofNullable(clazz.cast(this.coreNetworkArn()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "RouteTableId": {
                return Optional.ofNullable(clazz.cast(this.routeTableId()));
            }
            case "DestinationCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationCidrBlock()));
            }
            case "GatewayId": {
                return Optional.ofNullable(clazz.cast(this.gatewayId()));
            }
            case "DestinationIpv6CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationIpv6CidrBlock()));
            }
            case "EgressOnlyInternetGatewayId": {
                return Optional.ofNullable(clazz.cast(this.egressOnlyInternetGatewayId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "VpcPeeringConnectionId": {
                return Optional.ofNullable(clazz.cast(this.vpcPeeringConnectionId()));
            }
            case "NatGatewayId": {
                return Optional.ofNullable(clazz.cast(this.natGatewayId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DestinationPrefixListId", DESTINATION_PREFIX_LIST_ID_FIELD);
        map.put("VpcEndpointId", VPC_ENDPOINT_ID_FIELD);
        map.put("LocalTarget", LOCAL_TARGET_FIELD);
        map.put("TransitGatewayId", TRANSIT_GATEWAY_ID_FIELD);
        map.put("LocalGatewayId", LOCAL_GATEWAY_ID_FIELD);
        map.put("CarrierGatewayId", CARRIER_GATEWAY_ID_FIELD);
        map.put("CoreNetworkArn", CORE_NETWORK_ARN_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("RouteTableId", ROUTE_TABLE_ID_FIELD);
        map.put("DestinationCidrBlock", DESTINATION_CIDR_BLOCK_FIELD);
        map.put("GatewayId", GATEWAY_ID_FIELD);
        map.put("DestinationIpv6CidrBlock", DESTINATION_IPV6_CIDR_BLOCK_FIELD);
        map.put("EgressOnlyInternetGatewayId", EGRESS_ONLY_INTERNET_GATEWAY_ID_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
        map.put("VpcPeeringConnectionId", VPC_PEERING_CONNECTION_ID_FIELD);
        map.put("NatGatewayId", NAT_GATEWAY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplaceRouteRequest, T> g) {
        return obj -> g.apply((ReplaceRouteRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String destinationPrefixListId;
        private String vpcEndpointId;
        private Boolean localTarget;
        private String transitGatewayId;
        private String localGatewayId;
        private String carrierGatewayId;
        private String coreNetworkArn;
        private Boolean dryRun;
        private String routeTableId;
        private String destinationCidrBlock;
        private String gatewayId;
        private String destinationIpv6CidrBlock;
        private String egressOnlyInternetGatewayId;
        private String instanceId;
        private String networkInterfaceId;
        private String vpcPeeringConnectionId;
        private String natGatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplaceRouteRequest model) {
            super(model);
            this.destinationPrefixListId(model.destinationPrefixListId);
            this.vpcEndpointId(model.vpcEndpointId);
            this.localTarget(model.localTarget);
            this.transitGatewayId(model.transitGatewayId);
            this.localGatewayId(model.localGatewayId);
            this.carrierGatewayId(model.carrierGatewayId);
            this.coreNetworkArn(model.coreNetworkArn);
            this.dryRun(model.dryRun);
            this.routeTableId(model.routeTableId);
            this.destinationCidrBlock(model.destinationCidrBlock);
            this.gatewayId(model.gatewayId);
            this.destinationIpv6CidrBlock(model.destinationIpv6CidrBlock);
            this.egressOnlyInternetGatewayId(model.egressOnlyInternetGatewayId);
            this.instanceId(model.instanceId);
            this.networkInterfaceId(model.networkInterfaceId);
            this.vpcPeeringConnectionId(model.vpcPeeringConnectionId);
            this.natGatewayId(model.natGatewayId);
        }

        public final String getDestinationPrefixListId() {
            return this.destinationPrefixListId;
        }

        public final void setDestinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
        }

        @Override
        public final Builder destinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
            return this;
        }

        public final String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final Boolean getLocalTarget() {
            return this.localTarget;
        }

        public final void setLocalTarget(Boolean localTarget) {
            this.localTarget = localTarget;
        }

        @Override
        public final Builder localTarget(Boolean localTarget) {
            this.localTarget = localTarget;
            return this;
        }

        public final String getTransitGatewayId() {
            return this.transitGatewayId;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final String getLocalGatewayId() {
            return this.localGatewayId;
        }

        public final void setLocalGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
        }

        @Override
        public final Builder localGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
            return this;
        }

        public final String getCarrierGatewayId() {
            return this.carrierGatewayId;
        }

        public final void setCarrierGatewayId(String carrierGatewayId) {
            this.carrierGatewayId = carrierGatewayId;
        }

        @Override
        public final Builder carrierGatewayId(String carrierGatewayId) {
            this.carrierGatewayId = carrierGatewayId;
            return this;
        }

        public final String getCoreNetworkArn() {
            return this.coreNetworkArn;
        }

        public final void setCoreNetworkArn(String coreNetworkArn) {
            this.coreNetworkArn = coreNetworkArn;
        }

        @Override
        public final Builder coreNetworkArn(String coreNetworkArn) {
            this.coreNetworkArn = coreNetworkArn;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getRouteTableId() {
            return this.routeTableId;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final String getGatewayId() {
            return this.gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getDestinationIpv6CidrBlock() {
            return this.destinationIpv6CidrBlock;
        }

        public final void setDestinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
        }

        @Override
        public final Builder destinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
            return this;
        }

        public final String getEgressOnlyInternetGatewayId() {
            return this.egressOnlyInternetGatewayId;
        }

        public final void setEgressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
        }

        @Override
        public final Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getVpcPeeringConnectionId() {
            return this.vpcPeeringConnectionId;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final String getNatGatewayId() {
            return this.natGatewayId;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReplaceRouteRequest build() {
            return new ReplaceRouteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ReplaceRouteRequest> {
        public Builder destinationPrefixListId(String var1);

        public Builder vpcEndpointId(String var1);

        public Builder localTarget(Boolean var1);

        public Builder transitGatewayId(String var1);

        public Builder localGatewayId(String var1);

        public Builder carrierGatewayId(String var1);

        public Builder coreNetworkArn(String var1);

        public Builder dryRun(Boolean var1);

        public Builder routeTableId(String var1);

        public Builder destinationCidrBlock(String var1);

        public Builder gatewayId(String var1);

        public Builder destinationIpv6CidrBlock(String var1);

        public Builder egressOnlyInternetGatewayId(String var1);

        public Builder instanceId(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder vpcPeeringConnectionId(String var1);

        public Builder natGatewayId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

