/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.StoreImageTaskResult;
import software.amazon.awssdk.services.ec2.model.StoreImageTaskResultSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStoreImageTasksResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeStoreImageTasksResponse> {
    private static final SdkField<List<StoreImageTaskResult>> STORE_IMAGE_TASK_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StoreImageTaskResults").getter(DescribeStoreImageTasksResponse.getter(DescribeStoreImageTasksResponse::storeImageTaskResults)).setter(DescribeStoreImageTasksResponse.setter(Builder::storeImageTaskResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoreImageTaskResultSet").unmarshallLocationName("storeImageTaskResultSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StoreImageTaskResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeStoreImageTasksResponse.getter(DescribeStoreImageTasksResponse::nextToken)).setter(DescribeStoreImageTasksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORE_IMAGE_TASK_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeStoreImageTasksResponse.memberNameToFieldInitializer();
    private final List<StoreImageTaskResult> storeImageTaskResults;
    private final String nextToken;

    private DescribeStoreImageTasksResponse(BuilderImpl builder) {
        super(builder);
        this.storeImageTaskResults = builder.storeImageTaskResults;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasStoreImageTaskResults() {
        return this.storeImageTaskResults != null && !(this.storeImageTaskResults instanceof SdkAutoConstructList);
    }

    public final List<StoreImageTaskResult> storeImageTaskResults() {
        return this.storeImageTaskResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStoreImageTaskResults() ? this.storeImageTaskResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStoreImageTasksResponse)) {
            return false;
        }
        DescribeStoreImageTasksResponse other = (DescribeStoreImageTasksResponse)((Object)obj);
        return this.hasStoreImageTaskResults() == other.hasStoreImageTaskResults() && Objects.equals(this.storeImageTaskResults(), other.storeImageTaskResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeStoreImageTasksResponse").add("StoreImageTaskResults", this.hasStoreImageTaskResults() ? this.storeImageTaskResults() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StoreImageTaskResults": {
                return Optional.ofNullable(clazz.cast(this.storeImageTaskResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StoreImageTaskResultSet", STORE_IMAGE_TASK_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeStoreImageTasksResponse, T> g) {
        return obj -> g.apply((DescribeStoreImageTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<StoreImageTaskResult> storeImageTaskResults = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStoreImageTasksResponse model) {
            super(model);
            this.storeImageTaskResults(model.storeImageTaskResults);
            this.nextToken(model.nextToken);
        }

        public final List<StoreImageTaskResult.Builder> getStoreImageTaskResults() {
            List<StoreImageTaskResult.Builder> result = StoreImageTaskResultSetCopier.copyToBuilder(this.storeImageTaskResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStoreImageTaskResults(Collection<StoreImageTaskResult.BuilderImpl> storeImageTaskResults) {
            this.storeImageTaskResults = StoreImageTaskResultSetCopier.copyFromBuilder(storeImageTaskResults);
        }

        @Override
        public final Builder storeImageTaskResults(Collection<StoreImageTaskResult> storeImageTaskResults) {
            this.storeImageTaskResults = StoreImageTaskResultSetCopier.copy(storeImageTaskResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storeImageTaskResults(StoreImageTaskResult ... storeImageTaskResults) {
            this.storeImageTaskResults(Arrays.asList(storeImageTaskResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storeImageTaskResults(Consumer<StoreImageTaskResult.Builder> ... storeImageTaskResults) {
            this.storeImageTaskResults(Stream.of(storeImageTaskResults).map(c -> (StoreImageTaskResult)((StoreImageTaskResult.Builder)StoreImageTaskResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeStoreImageTasksResponse build() {
            return new DescribeStoreImageTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStoreImageTasksResponse> {
        public Builder storeImageTaskResults(Collection<StoreImageTaskResult> var1);

        public Builder storeImageTaskResults(StoreImageTaskResult ... var1);

        public Builder storeImageTaskResults(Consumer<StoreImageTaskResult.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

