/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.InstanceRequirements;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.PlacementResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FleetLaunchTemplateOverrides
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FleetLaunchTemplateOverrides> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(FleetLaunchTemplateOverrides.getter(FleetLaunchTemplateOverrides::instanceTypeAsString)).setter(FleetLaunchTemplateOverrides.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<String> MAX_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxPrice").getter(FleetLaunchTemplateOverrides.getter(FleetLaunchTemplateOverrides::maxPrice)).setter(FleetLaunchTemplateOverrides.setter(Builder::maxPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPrice").unmarshallLocationName("maxPrice").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(FleetLaunchTemplateOverrides.getter(FleetLaunchTemplateOverrides::subnetId)).setter(FleetLaunchTemplateOverrides.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("subnetId").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(FleetLaunchTemplateOverrides.getter(FleetLaunchTemplateOverrides::availabilityZone)).setter(FleetLaunchTemplateOverrides.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<Double> WEIGHTED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("WeightedCapacity").getter(FleetLaunchTemplateOverrides.getter(FleetLaunchTemplateOverrides::weightedCapacity)).setter(FleetLaunchTemplateOverrides.setter(Builder::weightedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeightedCapacity").unmarshallLocationName("weightedCapacity").build()}).build();
    private static final SdkField<Double> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Priority").getter(FleetLaunchTemplateOverrides.getter(FleetLaunchTemplateOverrides::priority)).setter(FleetLaunchTemplateOverrides.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").unmarshallLocationName("priority").build()}).build();
    private static final SdkField<PlacementResponse> PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Placement").getter(FleetLaunchTemplateOverrides.getter(FleetLaunchTemplateOverrides::placement)).setter(FleetLaunchTemplateOverrides.setter(Builder::placement)).constructor(PlacementResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement").unmarshallLocationName("placement").build()}).build();
    private static final SdkField<InstanceRequirements> INSTANCE_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceRequirements").getter(FleetLaunchTemplateOverrides.getter(FleetLaunchTemplateOverrides::instanceRequirements)).setter(FleetLaunchTemplateOverrides.setter(Builder::instanceRequirements)).constructor(InstanceRequirements::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRequirements").unmarshallLocationName("instanceRequirements").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(FleetLaunchTemplateOverrides.getter(FleetLaunchTemplateOverrides::imageId)).setter(FleetLaunchTemplateOverrides.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("imageId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD, MAX_PRICE_FIELD, SUBNET_ID_FIELD, AVAILABILITY_ZONE_FIELD, WEIGHTED_CAPACITY_FIELD, PRIORITY_FIELD, PLACEMENT_FIELD, INSTANCE_REQUIREMENTS_FIELD, IMAGE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FleetLaunchTemplateOverrides.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instanceType;
    private final String maxPrice;
    private final String subnetId;
    private final String availabilityZone;
    private final Double weightedCapacity;
    private final Double priority;
    private final PlacementResponse placement;
    private final InstanceRequirements instanceRequirements;
    private final String imageId;

    private FleetLaunchTemplateOverrides(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.maxPrice = builder.maxPrice;
        this.subnetId = builder.subnetId;
        this.availabilityZone = builder.availabilityZone;
        this.weightedCapacity = builder.weightedCapacity;
        this.priority = builder.priority;
        this.placement = builder.placement;
        this.instanceRequirements = builder.instanceRequirements;
        this.imageId = builder.imageId;
    }

    public final InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final String maxPrice() {
        return this.maxPrice;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final Double weightedCapacity() {
        return this.weightedCapacity;
    }

    public final Double priority() {
        return this.priority;
    }

    public final PlacementResponse placement() {
        return this.placement;
    }

    public final InstanceRequirements instanceRequirements() {
        return this.instanceRequirements;
    }

    public final String imageId() {
        return this.imageId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.weightedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.placement());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRequirements());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetLaunchTemplateOverrides)) {
            return false;
        }
        FleetLaunchTemplateOverrides other = (FleetLaunchTemplateOverrides)obj;
        return Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.maxPrice(), other.maxPrice()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.weightedCapacity(), other.weightedCapacity()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.placement(), other.placement()) && Objects.equals(this.instanceRequirements(), other.instanceRequirements()) && Objects.equals(this.imageId(), other.imageId());
    }

    public final String toString() {
        return ToString.builder((String)"FleetLaunchTemplateOverrides").add("InstanceType", (Object)this.instanceTypeAsString()).add("MaxPrice", (Object)this.maxPrice()).add("SubnetId", (Object)this.subnetId()).add("AvailabilityZone", (Object)this.availabilityZone()).add("WeightedCapacity", (Object)this.weightedCapacity()).add("Priority", (Object)this.priority()).add("Placement", (Object)this.placement()).add("InstanceRequirements", (Object)this.instanceRequirements()).add("ImageId", (Object)this.imageId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "MaxPrice": {
                return Optional.ofNullable(clazz.cast(this.maxPrice()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "WeightedCapacity": {
                return Optional.ofNullable(clazz.cast(this.weightedCapacity()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "Placement": {
                return Optional.ofNullable(clazz.cast(this.placement()));
            }
            case "InstanceRequirements": {
                return Optional.ofNullable(clazz.cast(this.instanceRequirements()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("MaxPrice", MAX_PRICE_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("WeightedCapacity", WEIGHTED_CAPACITY_FIELD);
        map.put("Priority", PRIORITY_FIELD);
        map.put("Placement", PLACEMENT_FIELD);
        map.put("InstanceRequirements", INSTANCE_REQUIREMENTS_FIELD);
        map.put("ImageId", IMAGE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FleetLaunchTemplateOverrides, T> g) {
        return obj -> g.apply((FleetLaunchTemplateOverrides)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceType;
        private String maxPrice;
        private String subnetId;
        private String availabilityZone;
        private Double weightedCapacity;
        private Double priority;
        private PlacementResponse placement;
        private InstanceRequirements instanceRequirements;
        private String imageId;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetLaunchTemplateOverrides model) {
            this.instanceType(model.instanceType);
            this.maxPrice(model.maxPrice);
            this.subnetId(model.subnetId);
            this.availabilityZone(model.availabilityZone);
            this.weightedCapacity(model.weightedCapacity);
            this.priority(model.priority);
            this.placement(model.placement);
            this.instanceRequirements(model.instanceRequirements);
            this.imageId(model.imageId);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getMaxPrice() {
            return this.maxPrice;
        }

        public final void setMaxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
        }

        @Override
        public final Builder maxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Double getWeightedCapacity() {
            return this.weightedCapacity;
        }

        public final void setWeightedCapacity(Double weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
        }

        @Override
        public final Builder weightedCapacity(Double weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
            return this;
        }

        public final Double getPriority() {
            return this.priority;
        }

        public final void setPriority(Double priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Double priority) {
            this.priority = priority;
            return this;
        }

        public final PlacementResponse.Builder getPlacement() {
            return this.placement != null ? this.placement.toBuilder() : null;
        }

        public final void setPlacement(PlacementResponse.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        @Override
        public final Builder placement(PlacementResponse placement) {
            this.placement = placement;
            return this;
        }

        public final InstanceRequirements.Builder getInstanceRequirements() {
            return this.instanceRequirements != null ? this.instanceRequirements.toBuilder() : null;
        }

        public final void setInstanceRequirements(InstanceRequirements.BuilderImpl instanceRequirements) {
            this.instanceRequirements = instanceRequirements != null ? instanceRequirements.build() : null;
        }

        @Override
        public final Builder instanceRequirements(InstanceRequirements instanceRequirements) {
            this.instanceRequirements = instanceRequirements;
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public FleetLaunchTemplateOverrides build() {
            return new FleetLaunchTemplateOverrides(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FleetLaunchTemplateOverrides> {
        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder maxPrice(String var1);

        public Builder subnetId(String var1);

        public Builder availabilityZone(String var1);

        public Builder weightedCapacity(Double var1);

        public Builder priority(Double var1);

        public Builder placement(PlacementResponse var1);

        default public Builder placement(Consumer<PlacementResponse.Builder> placement) {
            return this.placement((PlacementResponse)((PlacementResponse.Builder)PlacementResponse.builder().applyMutation(placement)).build());
        }

        public Builder instanceRequirements(InstanceRequirements var1);

        default public Builder instanceRequirements(Consumer<InstanceRequirements.Builder> instanceRequirements) {
            return this.instanceRequirements((InstanceRequirements)((InstanceRequirements.Builder)InstanceRequirements.builder().applyMutation(instanceRequirements)).build());
        }

        public Builder imageId(String var1);
    }
}

