/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.SpotInstanceRequestIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelSpotInstanceRequestsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CancelSpotInstanceRequestsRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CancelSpotInstanceRequestsRequest.getter(CancelSpotInstanceRequestsRequest::dryRun)).setter(CancelSpotInstanceRequestsRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("dryRun").build()}).build();
    private static final SdkField<List<String>> SPOT_INSTANCE_REQUEST_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SpotInstanceRequestIds").getter(CancelSpotInstanceRequestsRequest.getter(CancelSpotInstanceRequestsRequest::spotInstanceRequestIds)).setter(CancelSpotInstanceRequestsRequest.setter(Builder::spotInstanceRequestIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstanceRequestId").unmarshallLocationName("SpotInstanceRequestId").build(), ListTrait.builder().memberLocationName("SpotInstanceRequestId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstanceRequestId").unmarshallLocationName("SpotInstanceRequestId").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, SPOT_INSTANCE_REQUEST_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CancelSpotInstanceRequestsRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final List<String> spotInstanceRequestIds;

    private CancelSpotInstanceRequestsRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.spotInstanceRequestIds = builder.spotInstanceRequestIds;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final boolean hasSpotInstanceRequestIds() {
        return this.spotInstanceRequestIds != null && !(this.spotInstanceRequestIds instanceof SdkAutoConstructList);
    }

    public final List<String> spotInstanceRequestIds() {
        return this.spotInstanceRequestIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpotInstanceRequestIds() ? this.spotInstanceRequestIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotInstanceRequestsRequest)) {
            return false;
        }
        CancelSpotInstanceRequestsRequest other = (CancelSpotInstanceRequestsRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && this.hasSpotInstanceRequestIds() == other.hasSpotInstanceRequestIds() && Objects.equals(this.spotInstanceRequestIds(), other.spotInstanceRequestIds());
    }

    public final String toString() {
        return ToString.builder((String)"CancelSpotInstanceRequestsRequest").add("DryRun", (Object)this.dryRun()).add("SpotInstanceRequestIds", this.hasSpotInstanceRequestIds() ? this.spotInstanceRequestIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "SpotInstanceRequestIds": {
                return Optional.ofNullable(clazz.cast(this.spotInstanceRequestIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("SpotInstanceRequestId", SPOT_INSTANCE_REQUEST_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CancelSpotInstanceRequestsRequest, T> g) {
        return obj -> g.apply((CancelSpotInstanceRequestsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private List<String> spotInstanceRequestIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSpotInstanceRequestsRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.spotInstanceRequestIds(model.spotInstanceRequestIds);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Collection<String> getSpotInstanceRequestIds() {
            if (this.spotInstanceRequestIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.spotInstanceRequestIds;
        }

        public final void setSpotInstanceRequestIds(Collection<String> spotInstanceRequestIds) {
            this.spotInstanceRequestIds = SpotInstanceRequestIdListCopier.copy(spotInstanceRequestIds);
        }

        @Override
        public final Builder spotInstanceRequestIds(Collection<String> spotInstanceRequestIds) {
            this.spotInstanceRequestIds = SpotInstanceRequestIdListCopier.copy(spotInstanceRequestIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotInstanceRequestIds(String ... spotInstanceRequestIds) {
            this.spotInstanceRequestIds(Arrays.asList(spotInstanceRequestIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelSpotInstanceRequestsRequest build() {
            return new CancelSpotInstanceRequestsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CancelSpotInstanceRequestsRequest> {
        public Builder dryRun(Boolean var1);

        public Builder spotInstanceRequestIds(Collection<String> var1);

        public Builder spotInstanceRequestIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

