/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.IpamDiscoveredAccount;
import software.amazon.awssdk.services.ec2.model.IpamDiscoveredAccountSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIpamDiscoveredAccountsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetIpamDiscoveredAccountsResponse> {
    private static final SdkField<List<IpamDiscoveredAccount>> IPAM_DISCOVERED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpamDiscoveredAccounts").getter(GetIpamDiscoveredAccountsResponse.getter(GetIpamDiscoveredAccountsResponse::ipamDiscoveredAccounts)).setter(GetIpamDiscoveredAccountsResponse.setter(Builder::ipamDiscoveredAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamDiscoveredAccountSet").unmarshallLocationName("ipamDiscoveredAccountSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamDiscoveredAccount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetIpamDiscoveredAccountsResponse.getter(GetIpamDiscoveredAccountsResponse::nextToken)).setter(GetIpamDiscoveredAccountsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_DISCOVERED_ACCOUNTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetIpamDiscoveredAccountsResponse.memberNameToFieldInitializer();
    private final List<IpamDiscoveredAccount> ipamDiscoveredAccounts;
    private final String nextToken;

    private GetIpamDiscoveredAccountsResponse(BuilderImpl builder) {
        super(builder);
        this.ipamDiscoveredAccounts = builder.ipamDiscoveredAccounts;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIpamDiscoveredAccounts() {
        return this.ipamDiscoveredAccounts != null && !(this.ipamDiscoveredAccounts instanceof SdkAutoConstructList);
    }

    public final List<IpamDiscoveredAccount> ipamDiscoveredAccounts() {
        return this.ipamDiscoveredAccounts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpamDiscoveredAccounts() ? this.ipamDiscoveredAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIpamDiscoveredAccountsResponse)) {
            return false;
        }
        GetIpamDiscoveredAccountsResponse other = (GetIpamDiscoveredAccountsResponse)((Object)obj);
        return this.hasIpamDiscoveredAccounts() == other.hasIpamDiscoveredAccounts() && Objects.equals(this.ipamDiscoveredAccounts(), other.ipamDiscoveredAccounts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetIpamDiscoveredAccountsResponse").add("IpamDiscoveredAccounts", this.hasIpamDiscoveredAccounts() ? this.ipamDiscoveredAccounts() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpamDiscoveredAccounts": {
                return Optional.ofNullable(clazz.cast(this.ipamDiscoveredAccounts()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IpamDiscoveredAccountSet", IPAM_DISCOVERED_ACCOUNTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIpamDiscoveredAccountsResponse, T> g) {
        return obj -> g.apply((GetIpamDiscoveredAccountsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<IpamDiscoveredAccount> ipamDiscoveredAccounts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIpamDiscoveredAccountsResponse model) {
            super(model);
            this.ipamDiscoveredAccounts(model.ipamDiscoveredAccounts);
            this.nextToken(model.nextToken);
        }

        public final List<IpamDiscoveredAccount.Builder> getIpamDiscoveredAccounts() {
            List<IpamDiscoveredAccount.Builder> result = IpamDiscoveredAccountSetCopier.copyToBuilder(this.ipamDiscoveredAccounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpamDiscoveredAccounts(Collection<IpamDiscoveredAccount.BuilderImpl> ipamDiscoveredAccounts) {
            this.ipamDiscoveredAccounts = IpamDiscoveredAccountSetCopier.copyFromBuilder(ipamDiscoveredAccounts);
        }

        @Override
        public final Builder ipamDiscoveredAccounts(Collection<IpamDiscoveredAccount> ipamDiscoveredAccounts) {
            this.ipamDiscoveredAccounts = IpamDiscoveredAccountSetCopier.copy(ipamDiscoveredAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamDiscoveredAccounts(IpamDiscoveredAccount ... ipamDiscoveredAccounts) {
            this.ipamDiscoveredAccounts(Arrays.asList(ipamDiscoveredAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamDiscoveredAccounts(Consumer<IpamDiscoveredAccount.Builder> ... ipamDiscoveredAccounts) {
            this.ipamDiscoveredAccounts(Stream.of(ipamDiscoveredAccounts).map(c -> (IpamDiscoveredAccount)((IpamDiscoveredAccount.Builder)IpamDiscoveredAccount.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetIpamDiscoveredAccountsResponse build() {
            return new GetIpamDiscoveredAccountsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIpamDiscoveredAccountsResponse> {
        public Builder ipamDiscoveredAccounts(Collection<IpamDiscoveredAccount> var1);

        public Builder ipamDiscoveredAccounts(IpamDiscoveredAccount ... var1);

        public Builder ipamDiscoveredAccounts(Consumer<IpamDiscoveredAccount.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

