/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnapshotRecycleBinInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnapshotRecycleBinInfo> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(SnapshotRecycleBinInfo.getter(SnapshotRecycleBinInfo::snapshotId)).setter(SnapshotRecycleBinInfo.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("snapshotId").build()}).build();
    private static final SdkField<Instant> RECYCLE_BIN_ENTER_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RecycleBinEnterTime").getter(SnapshotRecycleBinInfo.getter(SnapshotRecycleBinInfo::recycleBinEnterTime)).setter(SnapshotRecycleBinInfo.setter(Builder::recycleBinEnterTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecycleBinEnterTime").unmarshallLocationName("recycleBinEnterTime").build()}).build();
    private static final SdkField<Instant> RECYCLE_BIN_EXIT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RecycleBinExitTime").getter(SnapshotRecycleBinInfo.getter(SnapshotRecycleBinInfo::recycleBinExitTime)).setter(SnapshotRecycleBinInfo.setter(Builder::recycleBinExitTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecycleBinExitTime").unmarshallLocationName("recycleBinExitTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(SnapshotRecycleBinInfo.getter(SnapshotRecycleBinInfo::description)).setter(SnapshotRecycleBinInfo.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeId").getter(SnapshotRecycleBinInfo.getter(SnapshotRecycleBinInfo::volumeId)).setter(SnapshotRecycleBinInfo.setter(Builder::volumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").unmarshallLocationName("volumeId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD, RECYCLE_BIN_ENTER_TIME_FIELD, RECYCLE_BIN_EXIT_TIME_FIELD, DESCRIPTION_FIELD, VOLUME_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SnapshotId", SNAPSHOT_ID_FIELD);
            this.put("RecycleBinEnterTime", RECYCLE_BIN_ENTER_TIME_FIELD);
            this.put("RecycleBinExitTime", RECYCLE_BIN_EXIT_TIME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("VolumeId", VOLUME_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String snapshotId;
    private final Instant recycleBinEnterTime;
    private final Instant recycleBinExitTime;
    private final String description;
    private final String volumeId;

    private SnapshotRecycleBinInfo(BuilderImpl builder) {
        this.snapshotId = builder.snapshotId;
        this.recycleBinEnterTime = builder.recycleBinEnterTime;
        this.recycleBinExitTime = builder.recycleBinExitTime;
        this.description = builder.description;
        this.volumeId = builder.volumeId;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final Instant recycleBinEnterTime() {
        return this.recycleBinEnterTime;
    }

    public final Instant recycleBinExitTime() {
        return this.recycleBinExitTime;
    }

    public final String description() {
        return this.description;
    }

    public final String volumeId() {
        return this.volumeId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.recycleBinEnterTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.recycleBinExitTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotRecycleBinInfo)) {
            return false;
        }
        SnapshotRecycleBinInfo other = (SnapshotRecycleBinInfo)obj;
        return Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.recycleBinEnterTime(), other.recycleBinEnterTime()) && Objects.equals(this.recycleBinExitTime(), other.recycleBinExitTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.volumeId(), other.volumeId());
    }

    public final String toString() {
        return ToString.builder((String)"SnapshotRecycleBinInfo").add("SnapshotId", (Object)this.snapshotId()).add("RecycleBinEnterTime", (Object)this.recycleBinEnterTime()).add("RecycleBinExitTime", (Object)this.recycleBinExitTime()).add("Description", (Object)this.description()).add("VolumeId", (Object)this.volumeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "RecycleBinEnterTime": {
                return Optional.ofNullable(clazz.cast(this.recycleBinEnterTime()));
            }
            case "RecycleBinExitTime": {
                return Optional.ofNullable(clazz.cast(this.recycleBinExitTime()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "VolumeId": {
                return Optional.ofNullable(clazz.cast(this.volumeId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SnapshotRecycleBinInfo, T> g) {
        return obj -> g.apply((SnapshotRecycleBinInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String snapshotId;
        private Instant recycleBinEnterTime;
        private Instant recycleBinExitTime;
        private String description;
        private String volumeId;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotRecycleBinInfo model) {
            this.snapshotId(model.snapshotId);
            this.recycleBinEnterTime(model.recycleBinEnterTime);
            this.recycleBinExitTime(model.recycleBinExitTime);
            this.description(model.description);
            this.volumeId(model.volumeId);
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final Instant getRecycleBinEnterTime() {
            return this.recycleBinEnterTime;
        }

        public final void setRecycleBinEnterTime(Instant recycleBinEnterTime) {
            this.recycleBinEnterTime = recycleBinEnterTime;
        }

        @Override
        public final Builder recycleBinEnterTime(Instant recycleBinEnterTime) {
            this.recycleBinEnterTime = recycleBinEnterTime;
            return this;
        }

        public final Instant getRecycleBinExitTime() {
            return this.recycleBinExitTime;
        }

        public final void setRecycleBinExitTime(Instant recycleBinExitTime) {
            this.recycleBinExitTime = recycleBinExitTime;
        }

        @Override
        public final Builder recycleBinExitTime(Instant recycleBinExitTime) {
            this.recycleBinExitTime = recycleBinExitTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public SnapshotRecycleBinInfo build() {
            return new SnapshotRecycleBinInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnapshotRecycleBinInfo> {
        public Builder snapshotId(String var1);

        public Builder recycleBinEnterTime(Instant var1);

        public Builder recycleBinExitTime(Instant var1);

        public Builder description(String var1);

        public Builder volumeId(String var1);
    }
}

