/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointEniOptions;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointLoadBalancerOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyVerifiedAccessEndpointRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyVerifiedAccessEndpointRequest> {
    private static final SdkField<String> VERIFIED_ACCESS_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifiedAccessEndpointId").getter(ModifyVerifiedAccessEndpointRequest.getter(ModifyVerifiedAccessEndpointRequest::verifiedAccessEndpointId)).setter(ModifyVerifiedAccessEndpointRequest.setter(Builder::verifiedAccessEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessEndpointId").unmarshallLocationName("VerifiedAccessEndpointId").build()}).build();
    private static final SdkField<String> VERIFIED_ACCESS_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifiedAccessGroupId").getter(ModifyVerifiedAccessEndpointRequest.getter(ModifyVerifiedAccessEndpointRequest::verifiedAccessGroupId)).setter(ModifyVerifiedAccessEndpointRequest.setter(Builder::verifiedAccessGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessGroupId").unmarshallLocationName("VerifiedAccessGroupId").build()}).build();
    private static final SdkField<ModifyVerifiedAccessEndpointLoadBalancerOptions> LOAD_BALANCER_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoadBalancerOptions").getter(ModifyVerifiedAccessEndpointRequest.getter(ModifyVerifiedAccessEndpointRequest::loadBalancerOptions)).setter(ModifyVerifiedAccessEndpointRequest.setter(Builder::loadBalancerOptions)).constructor(ModifyVerifiedAccessEndpointLoadBalancerOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerOptions").unmarshallLocationName("LoadBalancerOptions").build()}).build();
    private static final SdkField<ModifyVerifiedAccessEndpointEniOptions> NETWORK_INTERFACE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkInterfaceOptions").getter(ModifyVerifiedAccessEndpointRequest.getter(ModifyVerifiedAccessEndpointRequest::networkInterfaceOptions)).setter(ModifyVerifiedAccessEndpointRequest.setter(Builder::networkInterfaceOptions)).constructor(ModifyVerifiedAccessEndpointEniOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceOptions").unmarshallLocationName("NetworkInterfaceOptions").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ModifyVerifiedAccessEndpointRequest.getter(ModifyVerifiedAccessEndpointRequest::description)).setter(ModifyVerifiedAccessEndpointRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(ModifyVerifiedAccessEndpointRequest.getter(ModifyVerifiedAccessEndpointRequest::clientToken)).setter(ModifyVerifiedAccessEndpointRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyVerifiedAccessEndpointRequest.getter(ModifyVerifiedAccessEndpointRequest::dryRun)).setter(ModifyVerifiedAccessEndpointRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFIED_ACCESS_ENDPOINT_ID_FIELD, VERIFIED_ACCESS_GROUP_ID_FIELD, LOAD_BALANCER_OPTIONS_FIELD, NETWORK_INTERFACE_OPTIONS_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("VerifiedAccessEndpointId", VERIFIED_ACCESS_ENDPOINT_ID_FIELD);
            this.put("VerifiedAccessGroupId", VERIFIED_ACCESS_GROUP_ID_FIELD);
            this.put("LoadBalancerOptions", LOAD_BALANCER_OPTIONS_FIELD);
            this.put("NetworkInterfaceOptions", NETWORK_INTERFACE_OPTIONS_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
            this.put("DryRun", DRY_RUN_FIELD);
        }
    });
    private final String verifiedAccessEndpointId;
    private final String verifiedAccessGroupId;
    private final ModifyVerifiedAccessEndpointLoadBalancerOptions loadBalancerOptions;
    private final ModifyVerifiedAccessEndpointEniOptions networkInterfaceOptions;
    private final String description;
    private final String clientToken;
    private final Boolean dryRun;

    private ModifyVerifiedAccessEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.verifiedAccessEndpointId = builder.verifiedAccessEndpointId;
        this.verifiedAccessGroupId = builder.verifiedAccessGroupId;
        this.loadBalancerOptions = builder.loadBalancerOptions;
        this.networkInterfaceOptions = builder.networkInterfaceOptions;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
        this.dryRun = builder.dryRun;
    }

    public final String verifiedAccessEndpointId() {
        return this.verifiedAccessEndpointId;
    }

    public final String verifiedAccessGroupId() {
        return this.verifiedAccessGroupId;
    }

    public final ModifyVerifiedAccessEndpointLoadBalancerOptions loadBalancerOptions() {
        return this.loadBalancerOptions;
    }

    public final ModifyVerifiedAccessEndpointEniOptions networkInterfaceOptions() {
        return this.networkInterfaceOptions;
    }

    public final String description() {
        return this.description;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedAccessEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedAccessGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVerifiedAccessEndpointRequest)) {
            return false;
        }
        ModifyVerifiedAccessEndpointRequest other = (ModifyVerifiedAccessEndpointRequest)((Object)obj);
        return Objects.equals(this.verifiedAccessEndpointId(), other.verifiedAccessEndpointId()) && Objects.equals(this.verifiedAccessGroupId(), other.verifiedAccessGroupId()) && Objects.equals(this.loadBalancerOptions(), other.loadBalancerOptions()) && Objects.equals(this.networkInterfaceOptions(), other.networkInterfaceOptions()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyVerifiedAccessEndpointRequest").add("VerifiedAccessEndpointId", (Object)this.verifiedAccessEndpointId()).add("VerifiedAccessGroupId", (Object)this.verifiedAccessGroupId()).add("LoadBalancerOptions", (Object)this.loadBalancerOptions()).add("NetworkInterfaceOptions", (Object)this.networkInterfaceOptions()).add("Description", (Object)this.description()).add("ClientToken", (Object)this.clientToken()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VerifiedAccessEndpointId": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessEndpointId()));
            }
            case "VerifiedAccessGroupId": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessGroupId()));
            }
            case "LoadBalancerOptions": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerOptions()));
            }
            case "NetworkInterfaceOptions": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceOptions()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVerifiedAccessEndpointRequest, T> g) {
        return obj -> g.apply((ModifyVerifiedAccessEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String verifiedAccessEndpointId;
        private String verifiedAccessGroupId;
        private ModifyVerifiedAccessEndpointLoadBalancerOptions loadBalancerOptions;
        private ModifyVerifiedAccessEndpointEniOptions networkInterfaceOptions;
        private String description;
        private String clientToken;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVerifiedAccessEndpointRequest model) {
            super(model);
            this.verifiedAccessEndpointId(model.verifiedAccessEndpointId);
            this.verifiedAccessGroupId(model.verifiedAccessGroupId);
            this.loadBalancerOptions(model.loadBalancerOptions);
            this.networkInterfaceOptions(model.networkInterfaceOptions);
            this.description(model.description);
            this.clientToken(model.clientToken);
            this.dryRun(model.dryRun);
        }

        public final String getVerifiedAccessEndpointId() {
            return this.verifiedAccessEndpointId;
        }

        public final void setVerifiedAccessEndpointId(String verifiedAccessEndpointId) {
            this.verifiedAccessEndpointId = verifiedAccessEndpointId;
        }

        @Override
        public final Builder verifiedAccessEndpointId(String verifiedAccessEndpointId) {
            this.verifiedAccessEndpointId = verifiedAccessEndpointId;
            return this;
        }

        public final String getVerifiedAccessGroupId() {
            return this.verifiedAccessGroupId;
        }

        public final void setVerifiedAccessGroupId(String verifiedAccessGroupId) {
            this.verifiedAccessGroupId = verifiedAccessGroupId;
        }

        @Override
        public final Builder verifiedAccessGroupId(String verifiedAccessGroupId) {
            this.verifiedAccessGroupId = verifiedAccessGroupId;
            return this;
        }

        public final ModifyVerifiedAccessEndpointLoadBalancerOptions.Builder getLoadBalancerOptions() {
            return this.loadBalancerOptions != null ? this.loadBalancerOptions.toBuilder() : null;
        }

        public final void setLoadBalancerOptions(ModifyVerifiedAccessEndpointLoadBalancerOptions.BuilderImpl loadBalancerOptions) {
            this.loadBalancerOptions = loadBalancerOptions != null ? loadBalancerOptions.build() : null;
        }

        @Override
        public final Builder loadBalancerOptions(ModifyVerifiedAccessEndpointLoadBalancerOptions loadBalancerOptions) {
            this.loadBalancerOptions = loadBalancerOptions;
            return this;
        }

        public final ModifyVerifiedAccessEndpointEniOptions.Builder getNetworkInterfaceOptions() {
            return this.networkInterfaceOptions != null ? this.networkInterfaceOptions.toBuilder() : null;
        }

        public final void setNetworkInterfaceOptions(ModifyVerifiedAccessEndpointEniOptions.BuilderImpl networkInterfaceOptions) {
            this.networkInterfaceOptions = networkInterfaceOptions != null ? networkInterfaceOptions.build() : null;
        }

        @Override
        public final Builder networkInterfaceOptions(ModifyVerifiedAccessEndpointEniOptions networkInterfaceOptions) {
            this.networkInterfaceOptions = networkInterfaceOptions;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVerifiedAccessEndpointRequest build() {
            return new ModifyVerifiedAccessEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyVerifiedAccessEndpointRequest> {
        public Builder verifiedAccessEndpointId(String var1);

        public Builder verifiedAccessGroupId(String var1);

        public Builder loadBalancerOptions(ModifyVerifiedAccessEndpointLoadBalancerOptions var1);

        default public Builder loadBalancerOptions(Consumer<ModifyVerifiedAccessEndpointLoadBalancerOptions.Builder> loadBalancerOptions) {
            return this.loadBalancerOptions((ModifyVerifiedAccessEndpointLoadBalancerOptions)((ModifyVerifiedAccessEndpointLoadBalancerOptions.Builder)ModifyVerifiedAccessEndpointLoadBalancerOptions.builder().applyMutation(loadBalancerOptions)).build());
        }

        public Builder networkInterfaceOptions(ModifyVerifiedAccessEndpointEniOptions var1);

        default public Builder networkInterfaceOptions(Consumer<ModifyVerifiedAccessEndpointEniOptions.Builder> networkInterfaceOptions) {
            return this.networkInterfaceOptions((ModifyVerifiedAccessEndpointEniOptions)((ModifyVerifiedAccessEndpointEniOptions.Builder)ModifyVerifiedAccessEndpointEniOptions.builder().applyMutation(networkInterfaceOptions)).build());
        }

        public Builder description(String var1);

        public Builder clientToken(String var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

