/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceConnectEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceConnectEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpoint;

public class DescribeInstanceConnectEndpointsPublisher
implements SdkPublisher<DescribeInstanceConnectEndpointsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeInstanceConnectEndpointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeInstanceConnectEndpointsPublisher(Ec2AsyncClient client, DescribeInstanceConnectEndpointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeInstanceConnectEndpointsPublisher(Ec2AsyncClient client, DescribeInstanceConnectEndpointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeInstanceConnectEndpointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeInstanceConnectEndpointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Ec2InstanceConnectEndpoint> instanceConnectEndpoints() {
        Function<DescribeInstanceConnectEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceConnectEndpoints() != null) {
                return response.instanceConnectEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeInstanceConnectEndpointsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeInstanceConnectEndpointsResponseFetcher
    implements AsyncPageFetcher<DescribeInstanceConnectEndpointsResponse> {
        private DescribeInstanceConnectEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceConnectEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeInstanceConnectEndpointsResponse> nextPage(DescribeInstanceConnectEndpointsResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceConnectEndpointsPublisher.this.client.describeInstanceConnectEndpoints(DescribeInstanceConnectEndpointsPublisher.this.firstRequest);
            }
            return DescribeInstanceConnectEndpointsPublisher.this.client.describeInstanceConnectEndpoints((DescribeInstanceConnectEndpointsRequest)((Object)DescribeInstanceConnectEndpointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

