/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.IpPrefixListCopier;
import software.amazon.awssdk.services.ec2.model.Ipv6AddressListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UnassignIpv6AddressesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, UnassignIpv6AddressesResponse> {
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(UnassignIpv6AddressesResponse.getter(UnassignIpv6AddressesResponse::networkInterfaceId)).setter(UnassignIpv6AddressesResponse.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<List<String>> UNASSIGNED_IPV6_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnassignedIpv6Addresses").getter(UnassignIpv6AddressesResponse.getter(UnassignIpv6AddressesResponse::unassignedIpv6Addresses)).setter(UnassignIpv6AddressesResponse.setter(Builder::unassignedIpv6Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnassignedIpv6Addresses").unmarshallLocationName("unassignedIpv6Addresses").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> UNASSIGNED_IPV6_PREFIXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnassignedIpv6Prefixes").getter(UnassignIpv6AddressesResponse.getter(UnassignIpv6AddressesResponse::unassignedIpv6Prefixes)).setter(UnassignIpv6AddressesResponse.setter(Builder::unassignedIpv6Prefixes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnassignedIpv6PrefixSet").unmarshallLocationName("unassignedIpv6PrefixSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_ID_FIELD, UNASSIGNED_IPV6_ADDRESSES_FIELD, UNASSIGNED_IPV6_PREFIXES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
            this.put("UnassignedIpv6Addresses", UNASSIGNED_IPV6_ADDRESSES_FIELD);
            this.put("UnassignedIpv6PrefixSet", UNASSIGNED_IPV6_PREFIXES_FIELD);
        }
    });
    private final String networkInterfaceId;
    private final List<String> unassignedIpv6Addresses;
    private final List<String> unassignedIpv6Prefixes;

    private UnassignIpv6AddressesResponse(BuilderImpl builder) {
        super(builder);
        this.networkInterfaceId = builder.networkInterfaceId;
        this.unassignedIpv6Addresses = builder.unassignedIpv6Addresses;
        this.unassignedIpv6Prefixes = builder.unassignedIpv6Prefixes;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final boolean hasUnassignedIpv6Addresses() {
        return this.unassignedIpv6Addresses != null && !(this.unassignedIpv6Addresses instanceof SdkAutoConstructList);
    }

    public final List<String> unassignedIpv6Addresses() {
        return this.unassignedIpv6Addresses;
    }

    public final boolean hasUnassignedIpv6Prefixes() {
        return this.unassignedIpv6Prefixes != null && !(this.unassignedIpv6Prefixes instanceof SdkAutoConstructList);
    }

    public final List<String> unassignedIpv6Prefixes() {
        return this.unassignedIpv6Prefixes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnassignedIpv6Addresses() ? this.unassignedIpv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnassignedIpv6Prefixes() ? this.unassignedIpv6Prefixes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnassignIpv6AddressesResponse)) {
            return false;
        }
        UnassignIpv6AddressesResponse other = (UnassignIpv6AddressesResponse)((Object)obj);
        return Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && this.hasUnassignedIpv6Addresses() == other.hasUnassignedIpv6Addresses() && Objects.equals(this.unassignedIpv6Addresses(), other.unassignedIpv6Addresses()) && this.hasUnassignedIpv6Prefixes() == other.hasUnassignedIpv6Prefixes() && Objects.equals(this.unassignedIpv6Prefixes(), other.unassignedIpv6Prefixes());
    }

    public final String toString() {
        return ToString.builder((String)"UnassignIpv6AddressesResponse").add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("UnassignedIpv6Addresses", this.hasUnassignedIpv6Addresses() ? this.unassignedIpv6Addresses() : null).add("UnassignedIpv6Prefixes", this.hasUnassignedIpv6Prefixes() ? this.unassignedIpv6Prefixes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "UnassignedIpv6Addresses": {
                return Optional.ofNullable(clazz.cast(this.unassignedIpv6Addresses()));
            }
            case "UnassignedIpv6Prefixes": {
                return Optional.ofNullable(clazz.cast(this.unassignedIpv6Prefixes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UnassignIpv6AddressesResponse, T> g) {
        return obj -> g.apply((UnassignIpv6AddressesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String networkInterfaceId;
        private List<String> unassignedIpv6Addresses = DefaultSdkAutoConstructList.getInstance();
        private List<String> unassignedIpv6Prefixes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UnassignIpv6AddressesResponse model) {
            super(model);
            this.networkInterfaceId(model.networkInterfaceId);
            this.unassignedIpv6Addresses(model.unassignedIpv6Addresses);
            this.unassignedIpv6Prefixes(model.unassignedIpv6Prefixes);
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final Collection<String> getUnassignedIpv6Addresses() {
            if (this.unassignedIpv6Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.unassignedIpv6Addresses;
        }

        public final void setUnassignedIpv6Addresses(Collection<String> unassignedIpv6Addresses) {
            this.unassignedIpv6Addresses = Ipv6AddressListCopier.copy(unassignedIpv6Addresses);
        }

        @Override
        public final Builder unassignedIpv6Addresses(Collection<String> unassignedIpv6Addresses) {
            this.unassignedIpv6Addresses = Ipv6AddressListCopier.copy(unassignedIpv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unassignedIpv6Addresses(String ... unassignedIpv6Addresses) {
            this.unassignedIpv6Addresses(Arrays.asList(unassignedIpv6Addresses));
            return this;
        }

        public final Collection<String> getUnassignedIpv6Prefixes() {
            if (this.unassignedIpv6Prefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.unassignedIpv6Prefixes;
        }

        public final void setUnassignedIpv6Prefixes(Collection<String> unassignedIpv6Prefixes) {
            this.unassignedIpv6Prefixes = IpPrefixListCopier.copy(unassignedIpv6Prefixes);
        }

        @Override
        public final Builder unassignedIpv6Prefixes(Collection<String> unassignedIpv6Prefixes) {
            this.unassignedIpv6Prefixes = IpPrefixListCopier.copy(unassignedIpv6Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unassignedIpv6Prefixes(String ... unassignedIpv6Prefixes) {
            this.unassignedIpv6Prefixes(Arrays.asList(unassignedIpv6Prefixes));
            return this;
        }

        @Override
        public UnassignIpv6AddressesResponse build() {
            return new UnassignIpv6AddressesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UnassignIpv6AddressesResponse> {
        public Builder networkInterfaceId(String var1);

        public Builder unassignedIpv6Addresses(Collection<String> var1);

        public Builder unassignedIpv6Addresses(String ... var1);

        public Builder unassignedIpv6Prefixes(Collection<String> var1);

        public Builder unassignedIpv6Prefixes(String ... var1);
    }
}

