/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DeviceOptions;
import software.amazon.awssdk.services.ec2.model.DeviceTrustProviderType;
import software.amazon.awssdk.services.ec2.model.NativeApplicationOidcOptions;
import software.amazon.awssdk.services.ec2.model.OidcOptions;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.TrustProviderType;
import software.amazon.awssdk.services.ec2.model.UserTrustProviderType;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessSseSpecificationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifiedAccessTrustProvider
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VerifiedAccessTrustProvider> {
    private static final SdkField<String> VERIFIED_ACCESS_TRUST_PROVIDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifiedAccessTrustProviderId").getter(VerifiedAccessTrustProvider.getter(VerifiedAccessTrustProvider::verifiedAccessTrustProviderId)).setter(VerifiedAccessTrustProvider.setter(Builder::verifiedAccessTrustProviderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessTrustProviderId").unmarshallLocationName("verifiedAccessTrustProviderId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(VerifiedAccessTrustProvider.getter(VerifiedAccessTrustProvider::description)).setter(VerifiedAccessTrustProvider.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<String> TRUST_PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrustProviderType").getter(VerifiedAccessTrustProvider.getter(VerifiedAccessTrustProvider::trustProviderTypeAsString)).setter(VerifiedAccessTrustProvider.setter(Builder::trustProviderType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustProviderType").unmarshallLocationName("trustProviderType").build()}).build();
    private static final SdkField<String> USER_TRUST_PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserTrustProviderType").getter(VerifiedAccessTrustProvider.getter(VerifiedAccessTrustProvider::userTrustProviderTypeAsString)).setter(VerifiedAccessTrustProvider.setter(Builder::userTrustProviderType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserTrustProviderType").unmarshallLocationName("userTrustProviderType").build()}).build();
    private static final SdkField<String> DEVICE_TRUST_PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceTrustProviderType").getter(VerifiedAccessTrustProvider.getter(VerifiedAccessTrustProvider::deviceTrustProviderTypeAsString)).setter(VerifiedAccessTrustProvider.setter(Builder::deviceTrustProviderType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTrustProviderType").unmarshallLocationName("deviceTrustProviderType").build()}).build();
    private static final SdkField<OidcOptions> OIDC_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OidcOptions").getter(VerifiedAccessTrustProvider.getter(VerifiedAccessTrustProvider::oidcOptions)).setter(VerifiedAccessTrustProvider.setter(Builder::oidcOptions)).constructor(OidcOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OidcOptions").unmarshallLocationName("oidcOptions").build()}).build();
    private static final SdkField<DeviceOptions> DEVICE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeviceOptions").getter(VerifiedAccessTrustProvider.getter(VerifiedAccessTrustProvider::deviceOptions)).setter(VerifiedAccessTrustProvider.setter(Builder::deviceOptions)).constructor(DeviceOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceOptions").unmarshallLocationName("deviceOptions").build()}).build();
    private static final SdkField<String> POLICY_REFERENCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyReferenceName").getter(VerifiedAccessTrustProvider.getter(VerifiedAccessTrustProvider::policyReferenceName)).setter(VerifiedAccessTrustProvider.setter(Builder::policyReferenceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyReferenceName").unmarshallLocationName("policyReferenceName").build()}).build();
    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationTime").getter(VerifiedAccessTrustProvider.getter(VerifiedAccessTrustProvider::creationTime)).setter(VerifiedAccessTrustProvider.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").unmarshallLocationName("creationTime").build()}).build();
    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastUpdatedTime").getter(VerifiedAccessTrustProvider.getter(VerifiedAccessTrustProvider::lastUpdatedTime)).setter(VerifiedAccessTrustProvider.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").unmarshallLocationName("lastUpdatedTime").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(VerifiedAccessTrustProvider.getter(VerifiedAccessTrustProvider::tags)).setter(VerifiedAccessTrustProvider.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<VerifiedAccessSseSpecificationResponse> SSE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SseSpecification").getter(VerifiedAccessTrustProvider.getter(VerifiedAccessTrustProvider::sseSpecification)).setter(VerifiedAccessTrustProvider.setter(Builder::sseSpecification)).constructor(VerifiedAccessSseSpecificationResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseSpecification").unmarshallLocationName("sseSpecification").build()}).build();
    private static final SdkField<NativeApplicationOidcOptions> NATIVE_APPLICATION_OIDC_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NativeApplicationOidcOptions").getter(VerifiedAccessTrustProvider.getter(VerifiedAccessTrustProvider::nativeApplicationOidcOptions)).setter(VerifiedAccessTrustProvider.setter(Builder::nativeApplicationOidcOptions)).constructor(NativeApplicationOidcOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NativeApplicationOidcOptions").unmarshallLocationName("nativeApplicationOidcOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFIED_ACCESS_TRUST_PROVIDER_ID_FIELD, DESCRIPTION_FIELD, TRUST_PROVIDER_TYPE_FIELD, USER_TRUST_PROVIDER_TYPE_FIELD, DEVICE_TRUST_PROVIDER_TYPE_FIELD, OIDC_OPTIONS_FIELD, DEVICE_OPTIONS_FIELD, POLICY_REFERENCE_NAME_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD, TAGS_FIELD, SSE_SPECIFICATION_FIELD, NATIVE_APPLICATION_OIDC_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("VerifiedAccessTrustProviderId", VERIFIED_ACCESS_TRUST_PROVIDER_ID_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("TrustProviderType", TRUST_PROVIDER_TYPE_FIELD);
            this.put("UserTrustProviderType", USER_TRUST_PROVIDER_TYPE_FIELD);
            this.put("DeviceTrustProviderType", DEVICE_TRUST_PROVIDER_TYPE_FIELD);
            this.put("OidcOptions", OIDC_OPTIONS_FIELD);
            this.put("DeviceOptions", DEVICE_OPTIONS_FIELD);
            this.put("PolicyReferenceName", POLICY_REFERENCE_NAME_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
            this.put("TagSet", TAGS_FIELD);
            this.put("SseSpecification", SSE_SPECIFICATION_FIELD);
            this.put("NativeApplicationOidcOptions", NATIVE_APPLICATION_OIDC_OPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String verifiedAccessTrustProviderId;
    private final String description;
    private final String trustProviderType;
    private final String userTrustProviderType;
    private final String deviceTrustProviderType;
    private final OidcOptions oidcOptions;
    private final DeviceOptions deviceOptions;
    private final String policyReferenceName;
    private final String creationTime;
    private final String lastUpdatedTime;
    private final List<Tag> tags;
    private final VerifiedAccessSseSpecificationResponse sseSpecification;
    private final NativeApplicationOidcOptions nativeApplicationOidcOptions;

    private VerifiedAccessTrustProvider(BuilderImpl builder) {
        this.verifiedAccessTrustProviderId = builder.verifiedAccessTrustProviderId;
        this.description = builder.description;
        this.trustProviderType = builder.trustProviderType;
        this.userTrustProviderType = builder.userTrustProviderType;
        this.deviceTrustProviderType = builder.deviceTrustProviderType;
        this.oidcOptions = builder.oidcOptions;
        this.deviceOptions = builder.deviceOptions;
        this.policyReferenceName = builder.policyReferenceName;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.tags = builder.tags;
        this.sseSpecification = builder.sseSpecification;
        this.nativeApplicationOidcOptions = builder.nativeApplicationOidcOptions;
    }

    public final String verifiedAccessTrustProviderId() {
        return this.verifiedAccessTrustProviderId;
    }

    public final String description() {
        return this.description;
    }

    public final TrustProviderType trustProviderType() {
        return TrustProviderType.fromValue(this.trustProviderType);
    }

    public final String trustProviderTypeAsString() {
        return this.trustProviderType;
    }

    public final UserTrustProviderType userTrustProviderType() {
        return UserTrustProviderType.fromValue(this.userTrustProviderType);
    }

    public final String userTrustProviderTypeAsString() {
        return this.userTrustProviderType;
    }

    public final DeviceTrustProviderType deviceTrustProviderType() {
        return DeviceTrustProviderType.fromValue(this.deviceTrustProviderType);
    }

    public final String deviceTrustProviderTypeAsString() {
        return this.deviceTrustProviderType;
    }

    public final OidcOptions oidcOptions() {
        return this.oidcOptions;
    }

    public final DeviceOptions deviceOptions() {
        return this.deviceOptions;
    }

    public final String policyReferenceName() {
        return this.policyReferenceName;
    }

    public final String creationTime() {
        return this.creationTime;
    }

    public final String lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final VerifiedAccessSseSpecificationResponse sseSpecification() {
        return this.sseSpecification;
    }

    public final NativeApplicationOidcOptions nativeApplicationOidcOptions() {
        return this.nativeApplicationOidcOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedAccessTrustProviderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userTrustProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceTrustProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.oidcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyReferenceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sseSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.nativeApplicationOidcOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedAccessTrustProvider)) {
            return false;
        }
        VerifiedAccessTrustProvider other = (VerifiedAccessTrustProvider)obj;
        return Objects.equals(this.verifiedAccessTrustProviderId(), other.verifiedAccessTrustProviderId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.trustProviderTypeAsString(), other.trustProviderTypeAsString()) && Objects.equals(this.userTrustProviderTypeAsString(), other.userTrustProviderTypeAsString()) && Objects.equals(this.deviceTrustProviderTypeAsString(), other.deviceTrustProviderTypeAsString()) && Objects.equals(this.oidcOptions(), other.oidcOptions()) && Objects.equals(this.deviceOptions(), other.deviceOptions()) && Objects.equals(this.policyReferenceName(), other.policyReferenceName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.sseSpecification(), other.sseSpecification()) && Objects.equals(this.nativeApplicationOidcOptions(), other.nativeApplicationOidcOptions());
    }

    public final String toString() {
        return ToString.builder((String)"VerifiedAccessTrustProvider").add("VerifiedAccessTrustProviderId", (Object)this.verifiedAccessTrustProviderId()).add("Description", (Object)this.description()).add("TrustProviderType", (Object)this.trustProviderTypeAsString()).add("UserTrustProviderType", (Object)this.userTrustProviderTypeAsString()).add("DeviceTrustProviderType", (Object)this.deviceTrustProviderTypeAsString()).add("OidcOptions", (Object)this.oidcOptions()).add("DeviceOptions", (Object)this.deviceOptions()).add("PolicyReferenceName", (Object)this.policyReferenceName()).add("CreationTime", (Object)this.creationTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("Tags", this.hasTags() ? this.tags() : null).add("SseSpecification", (Object)this.sseSpecification()).add("NativeApplicationOidcOptions", (Object)this.nativeApplicationOidcOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VerifiedAccessTrustProviderId": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessTrustProviderId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "TrustProviderType": {
                return Optional.ofNullable(clazz.cast(this.trustProviderTypeAsString()));
            }
            case "UserTrustProviderType": {
                return Optional.ofNullable(clazz.cast(this.userTrustProviderTypeAsString()));
            }
            case "DeviceTrustProviderType": {
                return Optional.ofNullable(clazz.cast(this.deviceTrustProviderTypeAsString()));
            }
            case "OidcOptions": {
                return Optional.ofNullable(clazz.cast(this.oidcOptions()));
            }
            case "DeviceOptions": {
                return Optional.ofNullable(clazz.cast(this.deviceOptions()));
            }
            case "PolicyReferenceName": {
                return Optional.ofNullable(clazz.cast(this.policyReferenceName()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "SseSpecification": {
                return Optional.ofNullable(clazz.cast(this.sseSpecification()));
            }
            case "NativeApplicationOidcOptions": {
                return Optional.ofNullable(clazz.cast(this.nativeApplicationOidcOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VerifiedAccessTrustProvider, T> g) {
        return obj -> g.apply((VerifiedAccessTrustProvider)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String verifiedAccessTrustProviderId;
        private String description;
        private String trustProviderType;
        private String userTrustProviderType;
        private String deviceTrustProviderType;
        private OidcOptions oidcOptions;
        private DeviceOptions deviceOptions;
        private String policyReferenceName;
        private String creationTime;
        private String lastUpdatedTime;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private VerifiedAccessSseSpecificationResponse sseSpecification;
        private NativeApplicationOidcOptions nativeApplicationOidcOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedAccessTrustProvider model) {
            this.verifiedAccessTrustProviderId(model.verifiedAccessTrustProviderId);
            this.description(model.description);
            this.trustProviderType(model.trustProviderType);
            this.userTrustProviderType(model.userTrustProviderType);
            this.deviceTrustProviderType(model.deviceTrustProviderType);
            this.oidcOptions(model.oidcOptions);
            this.deviceOptions(model.deviceOptions);
            this.policyReferenceName(model.policyReferenceName);
            this.creationTime(model.creationTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.tags(model.tags);
            this.sseSpecification(model.sseSpecification);
            this.nativeApplicationOidcOptions(model.nativeApplicationOidcOptions);
        }

        public final String getVerifiedAccessTrustProviderId() {
            return this.verifiedAccessTrustProviderId;
        }

        public final void setVerifiedAccessTrustProviderId(String verifiedAccessTrustProviderId) {
            this.verifiedAccessTrustProviderId = verifiedAccessTrustProviderId;
        }

        @Override
        public final Builder verifiedAccessTrustProviderId(String verifiedAccessTrustProviderId) {
            this.verifiedAccessTrustProviderId = verifiedAccessTrustProviderId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTrustProviderType() {
            return this.trustProviderType;
        }

        public final void setTrustProviderType(String trustProviderType) {
            this.trustProviderType = trustProviderType;
        }

        @Override
        public final Builder trustProviderType(String trustProviderType) {
            this.trustProviderType = trustProviderType;
            return this;
        }

        @Override
        public final Builder trustProviderType(TrustProviderType trustProviderType) {
            this.trustProviderType(trustProviderType == null ? null : trustProviderType.toString());
            return this;
        }

        public final String getUserTrustProviderType() {
            return this.userTrustProviderType;
        }

        public final void setUserTrustProviderType(String userTrustProviderType) {
            this.userTrustProviderType = userTrustProviderType;
        }

        @Override
        public final Builder userTrustProviderType(String userTrustProviderType) {
            this.userTrustProviderType = userTrustProviderType;
            return this;
        }

        @Override
        public final Builder userTrustProviderType(UserTrustProviderType userTrustProviderType) {
            this.userTrustProviderType(userTrustProviderType == null ? null : userTrustProviderType.toString());
            return this;
        }

        public final String getDeviceTrustProviderType() {
            return this.deviceTrustProviderType;
        }

        public final void setDeviceTrustProviderType(String deviceTrustProviderType) {
            this.deviceTrustProviderType = deviceTrustProviderType;
        }

        @Override
        public final Builder deviceTrustProviderType(String deviceTrustProviderType) {
            this.deviceTrustProviderType = deviceTrustProviderType;
            return this;
        }

        @Override
        public final Builder deviceTrustProviderType(DeviceTrustProviderType deviceTrustProviderType) {
            this.deviceTrustProviderType(deviceTrustProviderType == null ? null : deviceTrustProviderType.toString());
            return this;
        }

        public final OidcOptions.Builder getOidcOptions() {
            return this.oidcOptions != null ? this.oidcOptions.toBuilder() : null;
        }

        public final void setOidcOptions(OidcOptions.BuilderImpl oidcOptions) {
            this.oidcOptions = oidcOptions != null ? oidcOptions.build() : null;
        }

        @Override
        public final Builder oidcOptions(OidcOptions oidcOptions) {
            this.oidcOptions = oidcOptions;
            return this;
        }

        public final DeviceOptions.Builder getDeviceOptions() {
            return this.deviceOptions != null ? this.deviceOptions.toBuilder() : null;
        }

        public final void setDeviceOptions(DeviceOptions.BuilderImpl deviceOptions) {
            this.deviceOptions = deviceOptions != null ? deviceOptions.build() : null;
        }

        @Override
        public final Builder deviceOptions(DeviceOptions deviceOptions) {
            this.deviceOptions = deviceOptions;
            return this;
        }

        public final String getPolicyReferenceName() {
            return this.policyReferenceName;
        }

        public final void setPolicyReferenceName(String policyReferenceName) {
            this.policyReferenceName = policyReferenceName;
        }

        @Override
        public final Builder policyReferenceName(String policyReferenceName) {
            this.policyReferenceName = policyReferenceName;
            return this;
        }

        public final String getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final VerifiedAccessSseSpecificationResponse.Builder getSseSpecification() {
            return this.sseSpecification != null ? this.sseSpecification.toBuilder() : null;
        }

        public final void setSseSpecification(VerifiedAccessSseSpecificationResponse.BuilderImpl sseSpecification) {
            this.sseSpecification = sseSpecification != null ? sseSpecification.build() : null;
        }

        @Override
        public final Builder sseSpecification(VerifiedAccessSseSpecificationResponse sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        public final NativeApplicationOidcOptions.Builder getNativeApplicationOidcOptions() {
            return this.nativeApplicationOidcOptions != null ? this.nativeApplicationOidcOptions.toBuilder() : null;
        }

        public final void setNativeApplicationOidcOptions(NativeApplicationOidcOptions.BuilderImpl nativeApplicationOidcOptions) {
            this.nativeApplicationOidcOptions = nativeApplicationOidcOptions != null ? nativeApplicationOidcOptions.build() : null;
        }

        @Override
        public final Builder nativeApplicationOidcOptions(NativeApplicationOidcOptions nativeApplicationOidcOptions) {
            this.nativeApplicationOidcOptions = nativeApplicationOidcOptions;
            return this;
        }

        public VerifiedAccessTrustProvider build() {
            return new VerifiedAccessTrustProvider(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VerifiedAccessTrustProvider> {
        public Builder verifiedAccessTrustProviderId(String var1);

        public Builder description(String var1);

        public Builder trustProviderType(String var1);

        public Builder trustProviderType(TrustProviderType var1);

        public Builder userTrustProviderType(String var1);

        public Builder userTrustProviderType(UserTrustProviderType var1);

        public Builder deviceTrustProviderType(String var1);

        public Builder deviceTrustProviderType(DeviceTrustProviderType var1);

        public Builder oidcOptions(OidcOptions var1);

        default public Builder oidcOptions(Consumer<OidcOptions.Builder> oidcOptions) {
            return this.oidcOptions((OidcOptions)((OidcOptions.Builder)OidcOptions.builder().applyMutation(oidcOptions)).build());
        }

        public Builder deviceOptions(DeviceOptions var1);

        default public Builder deviceOptions(Consumer<DeviceOptions.Builder> deviceOptions) {
            return this.deviceOptions((DeviceOptions)((DeviceOptions.Builder)DeviceOptions.builder().applyMutation(deviceOptions)).build());
        }

        public Builder policyReferenceName(String var1);

        public Builder creationTime(String var1);

        public Builder lastUpdatedTime(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder sseSpecification(VerifiedAccessSseSpecificationResponse var1);

        default public Builder sseSpecification(Consumer<VerifiedAccessSseSpecificationResponse.Builder> sseSpecification) {
            return this.sseSpecification((VerifiedAccessSseSpecificationResponse)((VerifiedAccessSseSpecificationResponse.Builder)VerifiedAccessSseSpecificationResponse.builder().applyMutation(sseSpecification)).build());
        }

        public Builder nativeApplicationOidcOptions(NativeApplicationOidcOptions var1);

        default public Builder nativeApplicationOidcOptions(Consumer<NativeApplicationOidcOptions.Builder> nativeApplicationOidcOptions) {
            return this.nativeApplicationOidcOptions((NativeApplicationOidcOptions)((NativeApplicationOidcOptions.Builder)NativeApplicationOidcOptions.builder().applyMutation(nativeApplicationOidcOptions)).build());
        }
    }
}

