/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.IpPrefixListCopier;
import software.amazon.awssdk.services.ec2.model.Ipv6AddressListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssignIpv6AddressesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, AssignIpv6AddressesResponse> {
    private static final SdkField<List<String>> ASSIGNED_IPV6_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssignedIpv6Addresses").getter(AssignIpv6AddressesResponse.getter(AssignIpv6AddressesResponse::assignedIpv6Addresses)).setter(AssignIpv6AddressesResponse.setter(Builder::assignedIpv6Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignedIpv6Addresses").unmarshallLocationName("assignedIpv6Addresses").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ASSIGNED_IPV6_PREFIXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssignedIpv6Prefixes").getter(AssignIpv6AddressesResponse.getter(AssignIpv6AddressesResponse::assignedIpv6Prefixes)).setter(AssignIpv6AddressesResponse.setter(Builder::assignedIpv6Prefixes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignedIpv6PrefixSet").unmarshallLocationName("assignedIpv6PrefixSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(AssignIpv6AddressesResponse.getter(AssignIpv6AddressesResponse::networkInterfaceId)).setter(AssignIpv6AddressesResponse.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSIGNED_IPV6_ADDRESSES_FIELD, ASSIGNED_IPV6_PREFIXES_FIELD, NETWORK_INTERFACE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AssignedIpv6Addresses", ASSIGNED_IPV6_ADDRESSES_FIELD);
            this.put("AssignedIpv6PrefixSet", ASSIGNED_IPV6_PREFIXES_FIELD);
            this.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
        }
    });
    private final List<String> assignedIpv6Addresses;
    private final List<String> assignedIpv6Prefixes;
    private final String networkInterfaceId;

    private AssignIpv6AddressesResponse(BuilderImpl builder) {
        super(builder);
        this.assignedIpv6Addresses = builder.assignedIpv6Addresses;
        this.assignedIpv6Prefixes = builder.assignedIpv6Prefixes;
        this.networkInterfaceId = builder.networkInterfaceId;
    }

    public final boolean hasAssignedIpv6Addresses() {
        return this.assignedIpv6Addresses != null && !(this.assignedIpv6Addresses instanceof SdkAutoConstructList);
    }

    public final List<String> assignedIpv6Addresses() {
        return this.assignedIpv6Addresses;
    }

    public final boolean hasAssignedIpv6Prefixes() {
        return this.assignedIpv6Prefixes != null && !(this.assignedIpv6Prefixes instanceof SdkAutoConstructList);
    }

    public final List<String> assignedIpv6Prefixes() {
        return this.assignedIpv6Prefixes;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssignedIpv6Addresses() ? this.assignedIpv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssignedIpv6Prefixes() ? this.assignedIpv6Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignIpv6AddressesResponse)) {
            return false;
        }
        AssignIpv6AddressesResponse other = (AssignIpv6AddressesResponse)((Object)obj);
        return this.hasAssignedIpv6Addresses() == other.hasAssignedIpv6Addresses() && Objects.equals(this.assignedIpv6Addresses(), other.assignedIpv6Addresses()) && this.hasAssignedIpv6Prefixes() == other.hasAssignedIpv6Prefixes() && Objects.equals(this.assignedIpv6Prefixes(), other.assignedIpv6Prefixes()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId());
    }

    public final String toString() {
        return ToString.builder((String)"AssignIpv6AddressesResponse").add("AssignedIpv6Addresses", this.hasAssignedIpv6Addresses() ? this.assignedIpv6Addresses() : null).add("AssignedIpv6Prefixes", this.hasAssignedIpv6Prefixes() ? this.assignedIpv6Prefixes() : null).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssignedIpv6Addresses": {
                return Optional.ofNullable(clazz.cast(this.assignedIpv6Addresses()));
            }
            case "AssignedIpv6Prefixes": {
                return Optional.ofNullable(clazz.cast(this.assignedIpv6Prefixes()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssignIpv6AddressesResponse, T> g) {
        return obj -> g.apply((AssignIpv6AddressesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<String> assignedIpv6Addresses = DefaultSdkAutoConstructList.getInstance();
        private List<String> assignedIpv6Prefixes = DefaultSdkAutoConstructList.getInstance();
        private String networkInterfaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssignIpv6AddressesResponse model) {
            super(model);
            this.assignedIpv6Addresses(model.assignedIpv6Addresses);
            this.assignedIpv6Prefixes(model.assignedIpv6Prefixes);
            this.networkInterfaceId(model.networkInterfaceId);
        }

        public final Collection<String> getAssignedIpv6Addresses() {
            if (this.assignedIpv6Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assignedIpv6Addresses;
        }

        public final void setAssignedIpv6Addresses(Collection<String> assignedIpv6Addresses) {
            this.assignedIpv6Addresses = Ipv6AddressListCopier.copy(assignedIpv6Addresses);
        }

        @Override
        public final Builder assignedIpv6Addresses(Collection<String> assignedIpv6Addresses) {
            this.assignedIpv6Addresses = Ipv6AddressListCopier.copy(assignedIpv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignedIpv6Addresses(String ... assignedIpv6Addresses) {
            this.assignedIpv6Addresses(Arrays.asList(assignedIpv6Addresses));
            return this;
        }

        public final Collection<String> getAssignedIpv6Prefixes() {
            if (this.assignedIpv6Prefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assignedIpv6Prefixes;
        }

        public final void setAssignedIpv6Prefixes(Collection<String> assignedIpv6Prefixes) {
            this.assignedIpv6Prefixes = IpPrefixListCopier.copy(assignedIpv6Prefixes);
        }

        @Override
        public final Builder assignedIpv6Prefixes(Collection<String> assignedIpv6Prefixes) {
            this.assignedIpv6Prefixes = IpPrefixListCopier.copy(assignedIpv6Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignedIpv6Prefixes(String ... assignedIpv6Prefixes) {
            this.assignedIpv6Prefixes(Arrays.asList(assignedIpv6Prefixes));
            return this;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        @Override
        public AssignIpv6AddressesResponse build() {
            return new AssignIpv6AddressesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssignIpv6AddressesResponse> {
        public Builder assignedIpv6Addresses(Collection<String> var1);

        public Builder assignedIpv6Addresses(String ... var1);

        public Builder assignedIpv6Prefixes(Collection<String> var1);

        public Builder assignedIpv6Prefixes(String ... var1);

        public Builder networkInterfaceId(String var1);
    }
}

