/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.PlacementStrategy;
import software.amazon.awssdk.services.ec2.model.SpreadLevel;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePlacementGroupRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreatePlacementGroupRequest> {
    private static final SdkField<Integer> PARTITION_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PartitionCount").getter(CreatePlacementGroupRequest.getter(CreatePlacementGroupRequest::partitionCount)).setter(CreatePlacementGroupRequest.setter(Builder::partitionCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionCount").unmarshallLocationName("PartitionCount").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreatePlacementGroupRequest.getter(CreatePlacementGroupRequest::tagSpecifications)).setter(CreatePlacementGroupRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> SPREAD_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpreadLevel").getter(CreatePlacementGroupRequest.getter(CreatePlacementGroupRequest::spreadLevelAsString)).setter(CreatePlacementGroupRequest.setter(Builder::spreadLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpreadLevel").unmarshallLocationName("SpreadLevel").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreatePlacementGroupRequest.getter(CreatePlacementGroupRequest::dryRun)).setter(CreatePlacementGroupRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("dryRun").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(CreatePlacementGroupRequest.getter(CreatePlacementGroupRequest::groupName)).setter(CreatePlacementGroupRequest.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").unmarshallLocationName("groupName").build()}).build();
    private static final SdkField<String> STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Strategy").getter(CreatePlacementGroupRequest.getter(CreatePlacementGroupRequest::strategyAsString)).setter(CreatePlacementGroupRequest.setter(Builder::strategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Strategy").unmarshallLocationName("strategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTITION_COUNT_FIELD, TAG_SPECIFICATIONS_FIELD, SPREAD_LEVEL_FIELD, DRY_RUN_FIELD, GROUP_NAME_FIELD, STRATEGY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PartitionCount", PARTITION_COUNT_FIELD);
            this.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
            this.put("SpreadLevel", SPREAD_LEVEL_FIELD);
            this.put("DryRun", DRY_RUN_FIELD);
            this.put("GroupName", GROUP_NAME_FIELD);
            this.put("Strategy", STRATEGY_FIELD);
        }
    });
    private final Integer partitionCount;
    private final List<TagSpecification> tagSpecifications;
    private final String spreadLevel;
    private final Boolean dryRun;
    private final String groupName;
    private final String strategy;

    private CreatePlacementGroupRequest(BuilderImpl builder) {
        super(builder);
        this.partitionCount = builder.partitionCount;
        this.tagSpecifications = builder.tagSpecifications;
        this.spreadLevel = builder.spreadLevel;
        this.dryRun = builder.dryRun;
        this.groupName = builder.groupName;
        this.strategy = builder.strategy;
    }

    public final Integer partitionCount() {
        return this.partitionCount;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final SpreadLevel spreadLevel() {
        return SpreadLevel.fromValue(this.spreadLevel);
    }

    public final String spreadLevelAsString() {
        return this.spreadLevel;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final PlacementStrategy strategy() {
        return PlacementStrategy.fromValue(this.strategy);
    }

    public final String strategyAsString() {
        return this.strategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.spreadLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.strategyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlacementGroupRequest)) {
            return false;
        }
        CreatePlacementGroupRequest other = (CreatePlacementGroupRequest)((Object)obj);
        return Objects.equals(this.partitionCount(), other.partitionCount()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.spreadLevelAsString(), other.spreadLevelAsString()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.strategyAsString(), other.strategyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePlacementGroupRequest").add("PartitionCount", (Object)this.partitionCount()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("SpreadLevel", (Object)this.spreadLevelAsString()).add("DryRun", (Object)this.dryRun()).add("GroupName", (Object)this.groupName()).add("Strategy", (Object)this.strategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PartitionCount": {
                return Optional.ofNullable(clazz.cast(this.partitionCount()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "SpreadLevel": {
                return Optional.ofNullable(clazz.cast(this.spreadLevelAsString()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "Strategy": {
                return Optional.ofNullable(clazz.cast(this.strategyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreatePlacementGroupRequest, T> g) {
        return obj -> g.apply((CreatePlacementGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Integer partitionCount;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String spreadLevel;
        private Boolean dryRun;
        private String groupName;
        private String strategy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlacementGroupRequest model) {
            super(model);
            this.partitionCount(model.partitionCount);
            this.tagSpecifications(model.tagSpecifications);
            this.spreadLevel(model.spreadLevel);
            this.dryRun(model.dryRun);
            this.groupName(model.groupName);
            this.strategy(model.strategy);
        }

        public final Integer getPartitionCount() {
            return this.partitionCount;
        }

        public final void setPartitionCount(Integer partitionCount) {
            this.partitionCount = partitionCount;
        }

        @Override
        public final Builder partitionCount(Integer partitionCount) {
            this.partitionCount = partitionCount;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSpreadLevel() {
            return this.spreadLevel;
        }

        public final void setSpreadLevel(String spreadLevel) {
            this.spreadLevel = spreadLevel;
        }

        @Override
        public final Builder spreadLevel(String spreadLevel) {
            this.spreadLevel = spreadLevel;
            return this;
        }

        @Override
        public final Builder spreadLevel(SpreadLevel spreadLevel) {
            this.spreadLevel(spreadLevel == null ? null : spreadLevel.toString());
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getStrategy() {
            return this.strategy;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(PlacementStrategy strategy) {
            this.strategy(strategy == null ? null : strategy.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePlacementGroupRequest build() {
            return new CreatePlacementGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePlacementGroupRequest> {
        public Builder partitionCount(Integer var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder spreadLevel(String var1);

        public Builder spreadLevel(SpreadLevel var1);

        public Builder dryRun(Boolean var1);

        public Builder groupName(String var1);

        public Builder strategy(String var1);

        public Builder strategy(PlacementStrategy var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

