/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.OperatorResponse;
import software.amazon.awssdk.services.ec2.model.SSEType;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.VolumeAttachment;
import software.amazon.awssdk.services.ec2.model.VolumeAttachmentListCopier;
import software.amazon.awssdk.services.ec2.model.VolumeState;
import software.amazon.awssdk.services.ec2.model.VolumeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Volume
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Volume> {
    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostArn").getter(Volume.getter(Volume::outpostArn)).setter(Volume.setter(Builder::outpostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn").unmarshallLocationName("outpostArn").build()}).build();
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Iops").getter(Volume.getter(Volume::iops)).setter(Volume.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").unmarshallLocationName("iops").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(Volume.getter(Volume::tags)).setter(Volume.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeType").getter(Volume.getter(Volume::volumeTypeAsString)).setter(Volume.setter(Builder::volumeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType").unmarshallLocationName("volumeType").build()}).build();
    private static final SdkField<Boolean> FAST_RESTORED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("FastRestored").getter(Volume.getter(Volume::fastRestored)).setter(Volume.setter(Builder::fastRestored)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FastRestored").unmarshallLocationName("fastRestored").build()}).build();
    private static final SdkField<Boolean> MULTI_ATTACH_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MultiAttachEnabled").getter(Volume.getter(Volume::multiAttachEnabled)).setter(Volume.setter(Builder::multiAttachEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAttachEnabled").unmarshallLocationName("multiAttachEnabled").build()}).build();
    private static final SdkField<Integer> THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Throughput").getter(Volume.getter(Volume::throughput)).setter(Volume.setter(Builder::throughput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Throughput").unmarshallLocationName("throughput").build()}).build();
    private static final SdkField<String> SSE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SseType").getter(Volume.getter(Volume::sseTypeAsString)).setter(Volume.setter(Builder::sseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseType").unmarshallLocationName("sseType").build()}).build();
    private static final SdkField<OperatorResponse> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Operator").getter(Volume.getter(Volume::operator)).setter(Volume.setter(Builder::operator)).constructor(OperatorResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").unmarshallLocationName("operator").build()}).build();
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeId").getter(Volume.getter(Volume::volumeId)).setter(Volume.setter(Builder::volumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").unmarshallLocationName("volumeId").build()}).build();
    private static final SdkField<Integer> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Size").getter(Volume.getter(Volume::size)).setter(Volume.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").unmarshallLocationName("size").build()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(Volume.getter(Volume::snapshotId)).setter(Volume.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("snapshotId").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(Volume.getter(Volume::availabilityZone)).setter(Volume.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Volume.getter(Volume::stateAsString)).setter(Volume.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(Volume.getter(Volume::createTime)).setter(Volume.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").unmarshallLocationName("createTime").build()}).build();
    private static final SdkField<List<VolumeAttachment>> ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attachments").getter(Volume.getter(Volume::attachments)).setter(Volume.setter(Builder::attachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentSet").unmarshallLocationName("attachmentSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VolumeAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Encrypted").getter(Volume.getter(Volume::encrypted)).setter(Volume.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").unmarshallLocationName("encrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(Volume.getter(Volume::kmsKeyId)).setter(Volume.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").unmarshallLocationName("kmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_ARN_FIELD, IOPS_FIELD, TAGS_FIELD, VOLUME_TYPE_FIELD, FAST_RESTORED_FIELD, MULTI_ATTACH_ENABLED_FIELD, THROUGHPUT_FIELD, SSE_TYPE_FIELD, OPERATOR_FIELD, VOLUME_ID_FIELD, SIZE_FIELD, SNAPSHOT_ID_FIELD, AVAILABILITY_ZONE_FIELD, STATE_FIELD, CREATE_TIME_FIELD, ATTACHMENTS_FIELD, ENCRYPTED_FIELD, KMS_KEY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OutpostArn", OUTPOST_ARN_FIELD);
            this.put("Iops", IOPS_FIELD);
            this.put("TagSet", TAGS_FIELD);
            this.put("VolumeType", VOLUME_TYPE_FIELD);
            this.put("FastRestored", FAST_RESTORED_FIELD);
            this.put("MultiAttachEnabled", MULTI_ATTACH_ENABLED_FIELD);
            this.put("Throughput", THROUGHPUT_FIELD);
            this.put("SseType", SSE_TYPE_FIELD);
            this.put("Operator", OPERATOR_FIELD);
            this.put("VolumeId", VOLUME_ID_FIELD);
            this.put("Size", SIZE_FIELD);
            this.put("SnapshotId", SNAPSHOT_ID_FIELD);
            this.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
            this.put("Status", STATE_FIELD);
            this.put("CreateTime", CREATE_TIME_FIELD);
            this.put("AttachmentSet", ATTACHMENTS_FIELD);
            this.put("Encrypted", ENCRYPTED_FIELD);
            this.put("KmsKeyId", KMS_KEY_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String outpostArn;
    private final Integer iops;
    private final List<Tag> tags;
    private final String volumeType;
    private final Boolean fastRestored;
    private final Boolean multiAttachEnabled;
    private final Integer throughput;
    private final String sseType;
    private final OperatorResponse operator;
    private final String volumeId;
    private final Integer size;
    private final String snapshotId;
    private final String availabilityZone;
    private final String state;
    private final Instant createTime;
    private final List<VolumeAttachment> attachments;
    private final Boolean encrypted;
    private final String kmsKeyId;

    private Volume(BuilderImpl builder) {
        this.outpostArn = builder.outpostArn;
        this.iops = builder.iops;
        this.tags = builder.tags;
        this.volumeType = builder.volumeType;
        this.fastRestored = builder.fastRestored;
        this.multiAttachEnabled = builder.multiAttachEnabled;
        this.throughput = builder.throughput;
        this.sseType = builder.sseType;
        this.operator = builder.operator;
        this.volumeId = builder.volumeId;
        this.size = builder.size;
        this.snapshotId = builder.snapshotId;
        this.availabilityZone = builder.availabilityZone;
        this.state = builder.state;
        this.createTime = builder.createTime;
        this.attachments = builder.attachments;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public final String outpostArn() {
        return this.outpostArn;
    }

    public final Integer iops() {
        return this.iops;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final VolumeType volumeType() {
        return VolumeType.fromValue(this.volumeType);
    }

    public final String volumeTypeAsString() {
        return this.volumeType;
    }

    public final Boolean fastRestored() {
        return this.fastRestored;
    }

    public final Boolean multiAttachEnabled() {
        return this.multiAttachEnabled;
    }

    public final Integer throughput() {
        return this.throughput;
    }

    public final SSEType sseType() {
        return SSEType.fromValue(this.sseType);
    }

    public final String sseTypeAsString() {
        return this.sseType;
    }

    public final OperatorResponse operator() {
        return this.operator;
    }

    public final String volumeId() {
        return this.volumeId;
    }

    public final Integer size() {
        return this.size;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final VolumeState state() {
        return VolumeState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final boolean hasAttachments() {
        return this.attachments != null && !(this.attachments instanceof SdkAutoConstructList);
    }

    public final List<VolumeAttachment> attachments() {
        return this.attachments;
    }

    public final Boolean encrypted() {
        return this.encrypted;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fastRestored());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAttachEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.operator());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachments() ? this.attachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Volume)) {
            return false;
        }
        Volume other = (Volume)obj;
        return Objects.equals(this.outpostArn(), other.outpostArn()) && Objects.equals(this.iops(), other.iops()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.volumeTypeAsString(), other.volumeTypeAsString()) && Objects.equals(this.fastRestored(), other.fastRestored()) && Objects.equals(this.multiAttachEnabled(), other.multiAttachEnabled()) && Objects.equals(this.throughput(), other.throughput()) && Objects.equals(this.sseTypeAsString(), other.sseTypeAsString()) && Objects.equals(this.operator(), other.operator()) && Objects.equals(this.volumeId(), other.volumeId()) && Objects.equals(this.size(), other.size()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.createTime(), other.createTime()) && this.hasAttachments() == other.hasAttachments() && Objects.equals(this.attachments(), other.attachments()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"Volume").add("OutpostArn", (Object)this.outpostArn()).add("Iops", (Object)this.iops()).add("Tags", this.hasTags() ? this.tags() : null).add("VolumeType", (Object)this.volumeTypeAsString()).add("FastRestored", (Object)this.fastRestored()).add("MultiAttachEnabled", (Object)this.multiAttachEnabled()).add("Throughput", (Object)this.throughput()).add("SseType", (Object)this.sseTypeAsString()).add("Operator", (Object)this.operator()).add("VolumeId", (Object)this.volumeId()).add("Size", (Object)this.size()).add("SnapshotId", (Object)this.snapshotId()).add("AvailabilityZone", (Object)this.availabilityZone()).add("State", (Object)this.stateAsString()).add("CreateTime", (Object)this.createTime()).add("Attachments", this.hasAttachments() ? this.attachments() : null).add("Encrypted", (Object)this.encrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutpostArn": {
                return Optional.ofNullable(clazz.cast(this.outpostArn()));
            }
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "VolumeType": {
                return Optional.ofNullable(clazz.cast(this.volumeTypeAsString()));
            }
            case "FastRestored": {
                return Optional.ofNullable(clazz.cast(this.fastRestored()));
            }
            case "MultiAttachEnabled": {
                return Optional.ofNullable(clazz.cast(this.multiAttachEnabled()));
            }
            case "Throughput": {
                return Optional.ofNullable(clazz.cast(this.throughput()));
            }
            case "SseType": {
                return Optional.ofNullable(clazz.cast(this.sseTypeAsString()));
            }
            case "Operator": {
                return Optional.ofNullable(clazz.cast(this.operator()));
            }
            case "VolumeId": {
                return Optional.ofNullable(clazz.cast(this.volumeId()));
            }
            case "Size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "Attachments": {
                return Optional.ofNullable(clazz.cast(this.attachments()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Volume, T> g) {
        return obj -> g.apply((Volume)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String outpostArn;
        private Integer iops;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String volumeType;
        private Boolean fastRestored;
        private Boolean multiAttachEnabled;
        private Integer throughput;
        private String sseType;
        private OperatorResponse operator;
        private String volumeId;
        private Integer size;
        private String snapshotId;
        private String availabilityZone;
        private String state;
        private Instant createTime;
        private List<VolumeAttachment> attachments = DefaultSdkAutoConstructList.getInstance();
        private Boolean encrypted;
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(Volume model) {
            this.outpostArn(model.outpostArn);
            this.iops(model.iops);
            this.tags(model.tags);
            this.volumeType(model.volumeType);
            this.fastRestored(model.fastRestored);
            this.multiAttachEnabled(model.multiAttachEnabled);
            this.throughput(model.throughput);
            this.sseType(model.sseType);
            this.operator(model.operator);
            this.volumeId(model.volumeId);
            this.size(model.size);
            this.snapshotId(model.snapshotId);
            this.availabilityZone(model.availabilityZone);
            this.state(model.state);
            this.createTime(model.createTime);
            this.attachments(model.attachments);
            this.encrypted(model.encrypted);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final String getOutpostArn() {
            return this.outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final Integer getIops() {
            return this.iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType == null ? null : volumeType.toString());
            return this;
        }

        public final Boolean getFastRestored() {
            return this.fastRestored;
        }

        public final void setFastRestored(Boolean fastRestored) {
            this.fastRestored = fastRestored;
        }

        @Override
        public final Builder fastRestored(Boolean fastRestored) {
            this.fastRestored = fastRestored;
            return this;
        }

        public final Boolean getMultiAttachEnabled() {
            return this.multiAttachEnabled;
        }

        public final void setMultiAttachEnabled(Boolean multiAttachEnabled) {
            this.multiAttachEnabled = multiAttachEnabled;
        }

        @Override
        public final Builder multiAttachEnabled(Boolean multiAttachEnabled) {
            this.multiAttachEnabled = multiAttachEnabled;
            return this;
        }

        public final Integer getThroughput() {
            return this.throughput;
        }

        public final void setThroughput(Integer throughput) {
            this.throughput = throughput;
        }

        @Override
        public final Builder throughput(Integer throughput) {
            this.throughput = throughput;
            return this;
        }

        public final String getSseType() {
            return this.sseType;
        }

        public final void setSseType(String sseType) {
            this.sseType = sseType;
        }

        @Override
        public final Builder sseType(String sseType) {
            this.sseType = sseType;
            return this;
        }

        @Override
        public final Builder sseType(SSEType sseType) {
            this.sseType(sseType == null ? null : sseType.toString());
            return this;
        }

        public final OperatorResponse.Builder getOperator() {
            return this.operator != null ? this.operator.toBuilder() : null;
        }

        public final void setOperator(OperatorResponse.BuilderImpl operator) {
            this.operator = operator != null ? operator.build() : null;
        }

        @Override
        public final Builder operator(OperatorResponse operator) {
            this.operator = operator;
            return this;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final Integer getSize() {
            return this.size;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VolumeState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final List<VolumeAttachment.Builder> getAttachments() {
            List<VolumeAttachment.Builder> result = VolumeAttachmentListCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<VolumeAttachment.BuilderImpl> attachments) {
            this.attachments = VolumeAttachmentListCopier.copyFromBuilder(attachments);
        }

        @Override
        public final Builder attachments(Collection<VolumeAttachment> attachments) {
            this.attachments = VolumeAttachmentListCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(VolumeAttachment ... attachments) {
            this.attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<VolumeAttachment.Builder> ... attachments) {
            this.attachments(Stream.of(attachments).map(c -> (VolumeAttachment)((VolumeAttachment.Builder)VolumeAttachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public Volume build() {
            return new Volume(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Volume> {
        public Builder outpostArn(String var1);

        public Builder iops(Integer var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder volumeType(String var1);

        public Builder volumeType(VolumeType var1);

        public Builder fastRestored(Boolean var1);

        public Builder multiAttachEnabled(Boolean var1);

        public Builder throughput(Integer var1);

        public Builder sseType(String var1);

        public Builder sseType(SSEType var1);

        public Builder operator(OperatorResponse var1);

        default public Builder operator(Consumer<OperatorResponse.Builder> operator) {
            return this.operator((OperatorResponse)((OperatorResponse.Builder)OperatorResponse.builder().applyMutation(operator)).build());
        }

        public Builder volumeId(String var1);

        public Builder size(Integer var1);

        public Builder snapshotId(String var1);

        public Builder availabilityZone(String var1);

        public Builder state(String var1);

        public Builder state(VolumeState var1);

        public Builder createTime(Instant var1);

        public Builder attachments(Collection<VolumeAttachment> var1);

        public Builder attachments(VolumeAttachment ... var1);

        public Builder attachments(Consumer<VolumeAttachment.Builder> ... var1);

        public Builder encrypted(Boolean var1);

        public Builder kmsKeyId(String var1);
    }
}

