/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Reserved Instance whose queued purchase was not deleted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailedQueuedPurchaseDeletion implements SdkPojo, Serializable,
        ToCopyableBuilder<FailedQueuedPurchaseDeletion.Builder, FailedQueuedPurchaseDeletion> {
    private static final SdkField<DeleteQueuedReservedInstancesError> ERROR_FIELD = SdkField
            .<DeleteQueuedReservedInstancesError> builder(MarshallingType.SDK_POJO)
            .memberName("Error")
            .getter(getter(FailedQueuedPurchaseDeletion::error))
            .setter(setter(Builder::error))
            .constructor(DeleteQueuedReservedInstancesError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error")
                    .unmarshallLocationName("error").build()).build();

    private static final SdkField<String> RESERVED_INSTANCES_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReservedInstancesId")
            .getter(getter(FailedQueuedPurchaseDeletion::reservedInstancesId))
            .setter(setter(Builder::reservedInstancesId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesId")
                    .unmarshallLocationName("reservedInstancesId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_FIELD,
            RESERVED_INSTANCES_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Error", ERROR_FIELD);
                    put("ReservedInstancesId", RESERVED_INSTANCES_ID_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final DeleteQueuedReservedInstancesError error;

    private final String reservedInstancesId;

    private FailedQueuedPurchaseDeletion(BuilderImpl builder) {
        this.error = builder.error;
        this.reservedInstancesId = builder.reservedInstancesId;
    }

    /**
     * <p>
     * The error.
     * </p>
     * 
     * @return The error.
     */
    public final DeleteQueuedReservedInstancesError error() {
        return error;
    }

    /**
     * <p>
     * The ID of the Reserved Instance.
     * </p>
     * 
     * @return The ID of the Reserved Instance.
     */
    public final String reservedInstancesId() {
        return reservedInstancesId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedQueuedPurchaseDeletion)) {
            return false;
        }
        FailedQueuedPurchaseDeletion other = (FailedQueuedPurchaseDeletion) obj;
        return Objects.equals(error(), other.error()) && Objects.equals(reservedInstancesId(), other.reservedInstancesId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailedQueuedPurchaseDeletion").add("Error", error())
                .add("ReservedInstancesId", reservedInstancesId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        case "ReservedInstancesId":
            return Optional.ofNullable(clazz.cast(reservedInstancesId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FailedQueuedPurchaseDeletion, T> g) {
        return obj -> g.apply((FailedQueuedPurchaseDeletion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailedQueuedPurchaseDeletion> {
        /**
         * <p>
         * The error.
         * </p>
         * 
         * @param error
         *        The error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(DeleteQueuedReservedInstancesError error);

        /**
         * <p>
         * The error.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DeleteQueuedReservedInstancesError.Builder} avoiding the need to create one manually via
         * {@link DeleteQueuedReservedInstancesError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeleteQueuedReservedInstancesError.Builder#build()} is called
         * immediately and its result is passed to {@link #error(DeleteQueuedReservedInstancesError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link DeleteQueuedReservedInstancesError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(DeleteQueuedReservedInstancesError)
         */
        default Builder error(Consumer<DeleteQueuedReservedInstancesError.Builder> error) {
            return error(DeleteQueuedReservedInstancesError.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * The ID of the Reserved Instance.
         * </p>
         * 
         * @param reservedInstancesId
         *        The ID of the Reserved Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesId(String reservedInstancesId);
    }

    static final class BuilderImpl implements Builder {
        private DeleteQueuedReservedInstancesError error;

        private String reservedInstancesId;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedQueuedPurchaseDeletion model) {
            error(model.error);
            reservedInstancesId(model.reservedInstancesId);
        }

        public final DeleteQueuedReservedInstancesError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(DeleteQueuedReservedInstancesError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(DeleteQueuedReservedInstancesError error) {
            this.error = error;
            return this;
        }

        public final String getReservedInstancesId() {
            return reservedInstancesId;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        @Override
        public FailedQueuedPurchaseDeletion build() {
            return new FailedQueuedPurchaseDeletion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
