/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFleetsRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeFleetsRequest.Builder, DescribeFleetsRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(DescribeFleetsRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(DescribeFleetsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeFleetsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<List<String>> FLEET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FleetIds")
            .getter(getter(DescribeFleetsRequest::fleetIds))
            .setter(setter(Builder::fleetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId")
                    .unmarshallLocationName("FleetId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeFleetsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, FLEET_IDS_FIELD, FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DryRun", DRY_RUN_FIELD);
                    put("MaxResults", MAX_RESULTS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                    put("FleetId", FLEET_IDS_FIELD);
                    put("Filter", FILTERS_FIELD);
                }
            });

    private final Boolean dryRun;

    private final Integer maxResults;

    private final String nextToken;

    private final List<String> fleetIds;

    private final List<Filter> filters;

    private DescribeFleetsRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.fleetIds = builder.fleetIds;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The maximum number of items to return for this request. To get the next page of items, make another request with
     * the token returned in the output. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.
     * </p>
     * 
     * @return The maximum number of items to return for this request. To get the next page of items, make another
     *         request with the token returned in the output. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
     *         >Pagination</a>.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token returned from a previous paginated request. Pagination continues from the end of the items returned by
     * the previous request.
     * </p>
     * 
     * @return The token returned from a previous paginated request. Pagination continues from the end of the items
     *         returned by the previous request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the FleetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFleetIds() {
        return fleetIds != null && !(fleetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the EC2 Fleets.
     * </p>
     * <note>
     * <p>
     * If a fleet is of type <code>instant</code>, you must specify the fleet ID, otherwise it does not appear in the
     * response.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFleetIds} method.
     * </p>
     * 
     * @return The IDs of the EC2 Fleets.</p> <note>
     *         <p>
     *         If a fleet is of type <code>instant</code>, you must specify the fleet ID, otherwise it does not appear
     *         in the response.
     *         </p>
     */
    public final List<String> fleetIds() {
        return fleetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>activity-status</code> - The progress of the EC2 Fleet ( <code>error</code> |
     * <code>pending-fulfillment</code> | <code>pending-termination</code> | <code>fulfilled</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>excess-capacity-termination-policy</code> - Indicates whether to terminate running instances if the target
     * capacity is decreased below the current EC2 Fleet size (<code>true</code> | <code>false</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fleet-state</code> - The state of the EC2 Fleet (<code>submitted</code> | <code>active</code> |
     * <code>deleted</code> | <code>failed</code> | <code>deleted-running</code> | <code>deleted-terminating</code> |
     * <code>modifying</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>replace-unhealthy-instances</code> - Indicates whether EC2 Fleet should replace unhealthy instances (
     * <code>true</code> | <code>false</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>type</code> - The type of request (<code>instant</code> | <code>request</code> | <code>maintain</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>activity-status</code> - The progress of the EC2 Fleet ( <code>error</code> |
     *         <code>pending-fulfillment</code> | <code>pending-termination</code> | <code>fulfilled</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>excess-capacity-termination-policy</code> - Indicates whether to terminate running instances if the
     *         target capacity is decreased below the current EC2 Fleet size (<code>true</code> | <code>false</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fleet-state</code> - The state of the EC2 Fleet (<code>submitted</code> | <code>active</code> |
     *         <code>deleted</code> | <code>failed</code> | <code>deleted-running</code> |
     *         <code>deleted-terminating</code> | <code>modifying</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>replace-unhealthy-instances</code> - Indicates whether EC2 Fleet should replace unhealthy instances
     *         (<code>true</code> | <code>false</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>type</code> - The type of request (<code>instant</code> | <code>request</code> |
     *         <code>maintain</code>).
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasFleetIds() ? fleetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetsRequest)) {
            return false;
        }
        DescribeFleetsRequest other = (DescribeFleetsRequest) obj;
        return Objects.equals(dryRun(), other.dryRun()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && hasFleetIds() == other.hasFleetIds()
                && Objects.equals(fleetIds(), other.fleetIds()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFleetsRequest").add("DryRun", dryRun()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("FleetIds", hasFleetIds() ? fleetIds() : null)
                .add("Filters", hasFilters() ? filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "FleetIds":
            return Optional.ofNullable(clazz.cast(fleetIds()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetsRequest, T> g) {
        return obj -> g.apply((DescribeFleetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFleetsRequest> {
        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The maximum number of items to return for this request. To get the next page of items, make another request
         * with the token returned in the output. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
         * >Pagination</a>.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this request. To get the next page of items, make another
         *        request with the token returned in the output. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
         *        >Pagination</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token returned from a previous paginated request. Pagination continues from the end of the items returned
         * by the previous request.
         * </p>
         * 
         * @param nextToken
         *        The token returned from a previous paginated request. Pagination continues from the end of the items
         *        returned by the previous request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The IDs of the EC2 Fleets.
         * </p>
         * <note>
         * <p>
         * If a fleet is of type <code>instant</code>, you must specify the fleet ID, otherwise it does not appear in
         * the response.
         * </p>
         * </note>
         * 
         * @param fleetIds
         *        The IDs of the EC2 Fleets.</p> <note>
         *        <p>
         *        If a fleet is of type <code>instant</code>, you must specify the fleet ID, otherwise it does not
         *        appear in the response.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetIds(Collection<String> fleetIds);

        /**
         * <p>
         * The IDs of the EC2 Fleets.
         * </p>
         * <note>
         * <p>
         * If a fleet is of type <code>instant</code>, you must specify the fleet ID, otherwise it does not appear in
         * the response.
         * </p>
         * </note>
         * 
         * @param fleetIds
         *        The IDs of the EC2 Fleets.</p> <note>
         *        <p>
         *        If a fleet is of type <code>instant</code>, you must specify the fleet ID, otherwise it does not
         *        appear in the response.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetIds(String... fleetIds);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>activity-status</code> - The progress of the EC2 Fleet ( <code>error</code> |
         * <code>pending-fulfillment</code> | <code>pending-termination</code> | <code>fulfilled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>excess-capacity-termination-policy</code> - Indicates whether to terminate running instances if the
         * target capacity is decreased below the current EC2 Fleet size (<code>true</code> | <code>false</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fleet-state</code> - The state of the EC2 Fleet (<code>submitted</code> | <code>active</code> |
         * <code>deleted</code> | <code>failed</code> | <code>deleted-running</code> | <code>deleted-terminating</code>
         * | <code>modifying</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>replace-unhealthy-instances</code> - Indicates whether EC2 Fleet should replace unhealthy instances (
         * <code>true</code> | <code>false</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code> - The type of request (<code>instant</code> | <code>request</code> | <code>maintain</code>
         * ).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>activity-status</code> - The progress of the EC2 Fleet ( <code>error</code> |
         *        <code>pending-fulfillment</code> | <code>pending-termination</code> | <code>fulfilled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>excess-capacity-termination-policy</code> - Indicates whether to terminate running instances if
         *        the target capacity is decreased below the current EC2 Fleet size (<code>true</code> |
         *        <code>false</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fleet-state</code> - The state of the EC2 Fleet (<code>submitted</code> | <code>active</code> |
         *        <code>deleted</code> | <code>failed</code> | <code>deleted-running</code> |
         *        <code>deleted-terminating</code> | <code>modifying</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>replace-unhealthy-instances</code> - Indicates whether EC2 Fleet should replace unhealthy
         *        instances (<code>true</code> | <code>false</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>type</code> - The type of request (<code>instant</code> | <code>request</code> |
         *        <code>maintain</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>activity-status</code> - The progress of the EC2 Fleet ( <code>error</code> |
         * <code>pending-fulfillment</code> | <code>pending-termination</code> | <code>fulfilled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>excess-capacity-termination-policy</code> - Indicates whether to terminate running instances if the
         * target capacity is decreased below the current EC2 Fleet size (<code>true</code> | <code>false</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fleet-state</code> - The state of the EC2 Fleet (<code>submitted</code> | <code>active</code> |
         * <code>deleted</code> | <code>failed</code> | <code>deleted-running</code> | <code>deleted-terminating</code>
         * | <code>modifying</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>replace-unhealthy-instances</code> - Indicates whether EC2 Fleet should replace unhealthy instances (
         * <code>true</code> | <code>false</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code> - The type of request (<code>instant</code> | <code>request</code> | <code>maintain</code>
         * ).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>activity-status</code> - The progress of the EC2 Fleet ( <code>error</code> |
         *        <code>pending-fulfillment</code> | <code>pending-termination</code> | <code>fulfilled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>excess-capacity-termination-policy</code> - Indicates whether to terminate running instances if
         *        the target capacity is decreased below the current EC2 Fleet size (<code>true</code> |
         *        <code>false</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fleet-state</code> - The state of the EC2 Fleet (<code>submitted</code> | <code>active</code> |
         *        <code>deleted</code> | <code>failed</code> | <code>deleted-running</code> |
         *        <code>deleted-terminating</code> | <code>modifying</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>replace-unhealthy-instances</code> - Indicates whether EC2 Fleet should replace unhealthy
         *        instances (<code>true</code> | <code>false</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>type</code> - The type of request (<code>instant</code> | <code>request</code> |
         *        <code>maintain</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>activity-status</code> - The progress of the EC2 Fleet ( <code>error</code> |
         * <code>pending-fulfillment</code> | <code>pending-termination</code> | <code>fulfilled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>excess-capacity-termination-policy</code> - Indicates whether to terminate running instances if the
         * target capacity is decreased below the current EC2 Fleet size (<code>true</code> | <code>false</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fleet-state</code> - The state of the EC2 Fleet (<code>submitted</code> | <code>active</code> |
         * <code>deleted</code> | <code>failed</code> | <code>deleted-running</code> | <code>deleted-terminating</code>
         * | <code>modifying</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>replace-unhealthy-instances</code> - Indicates whether EC2 Fleet should replace unhealthy instances (
         * <code>true</code> | <code>false</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code> - The type of request (<code>instant</code> | <code>request</code> | <code>maintain</code>
         * ).
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Filter.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Filter.Builder#build()}
         * is called immediately and its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private Integer maxResults;

        private String nextToken;

        private List<String> fleetIds = DefaultSdkAutoConstructList.getInstance();

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetsRequest model) {
            super(model);
            dryRun(model.dryRun);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            fleetIds(model.fleetIds);
            filters(model.filters);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getFleetIds() {
            if (fleetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return fleetIds;
        }

        public final void setFleetIds(Collection<String> fleetIds) {
            this.fleetIds = FleetIdSetCopier.copy(fleetIds);
        }

        @Override
        public final Builder fleetIds(Collection<String> fleetIds) {
            this.fleetIds = FleetIdSetCopier.copy(fleetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetIds(String... fleetIds) {
            fleetIds(Arrays.asList(fleetIds));
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeFleetsRequest build() {
            return new DescribeFleetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
