/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CancelBundleTask.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelBundleTaskResponse extends Ec2Response implements
        ToCopyableBuilder<CancelBundleTaskResponse.Builder, CancelBundleTaskResponse> {
    private static final SdkField<BundleTask> BUNDLE_TASK_FIELD = SdkField
            .<BundleTask> builder(MarshallingType.SDK_POJO)
            .memberName("BundleTask")
            .getter(getter(CancelBundleTaskResponse::bundleTask))
            .setter(setter(Builder::bundleTask))
            .constructor(BundleTask::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleInstanceTask")
                    .unmarshallLocationName("bundleInstanceTask").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLE_TASK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("BundleInstanceTask", BUNDLE_TASK_FIELD);
                }
            });

    private final BundleTask bundleTask;

    private CancelBundleTaskResponse(BuilderImpl builder) {
        super(builder);
        this.bundleTask = builder.bundleTask;
    }

    /**
     * <p>
     * Information about the bundle task.
     * </p>
     * 
     * @return Information about the bundle task.
     */
    public final BundleTask bundleTask() {
        return bundleTask;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bundleTask());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelBundleTaskResponse)) {
            return false;
        }
        CancelBundleTaskResponse other = (CancelBundleTaskResponse) obj;
        return Objects.equals(bundleTask(), other.bundleTask());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelBundleTaskResponse").add("BundleTask", bundleTask()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BundleTask":
            return Optional.ofNullable(clazz.cast(bundleTask()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CancelBundleTaskResponse, T> g) {
        return obj -> g.apply((CancelBundleTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CancelBundleTaskResponse> {
        /**
         * <p>
         * Information about the bundle task.
         * </p>
         * 
         * @param bundleTask
         *        Information about the bundle task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleTask(BundleTask bundleTask);

        /**
         * <p>
         * Information about the bundle task.
         * </p>
         * This is a convenience method that creates an instance of the {@link BundleTask.Builder} avoiding the need to
         * create one manually via {@link BundleTask#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BundleTask.Builder#build()} is called immediately and its result
         * is passed to {@link #bundleTask(BundleTask)}.
         * 
         * @param bundleTask
         *        a consumer that will call methods on {@link BundleTask.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bundleTask(BundleTask)
         */
        default Builder bundleTask(Consumer<BundleTask.Builder> bundleTask) {
            return bundleTask(BundleTask.builder().applyMutation(bundleTask).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private BundleTask bundleTask;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelBundleTaskResponse model) {
            super(model);
            bundleTask(model.bundleTask);
        }

        public final BundleTask.Builder getBundleTask() {
            return bundleTask != null ? bundleTask.toBuilder() : null;
        }

        public final void setBundleTask(BundleTask.BuilderImpl bundleTask) {
            this.bundleTask = bundleTask != null ? bundleTask.build() : null;
        }

        @Override
        public final Builder bundleTask(BundleTask bundleTask) {
            this.bundleTask = bundleTask;
            return this;
        }

        @Override
        public CancelBundleTaskResponse build() {
            return new CancelBundleTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
