/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.LocalGatewayVirtualInterfaceIdSetCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LocalGatewayVirtualInterfaceGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LocalGatewayVirtualInterfaceGroup> {
    private static final SdkField<String> LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalGatewayVirtualInterfaceGroupId").getter(LocalGatewayVirtualInterfaceGroup.getter(LocalGatewayVirtualInterfaceGroup::localGatewayVirtualInterfaceGroupId)).setter(LocalGatewayVirtualInterfaceGroup.setter(Builder::localGatewayVirtualInterfaceGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayVirtualInterfaceGroupId").unmarshallLocationName("localGatewayVirtualInterfaceGroupId").build()}).build();
    private static final SdkField<List<String>> LOCAL_GATEWAY_VIRTUAL_INTERFACE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LocalGatewayVirtualInterfaceIds").getter(LocalGatewayVirtualInterfaceGroup.getter(LocalGatewayVirtualInterfaceGroup::localGatewayVirtualInterfaceIds)).setter(LocalGatewayVirtualInterfaceGroup.setter(Builder::localGatewayVirtualInterfaceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayVirtualInterfaceIdSet").unmarshallLocationName("localGatewayVirtualInterfaceIdSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> LOCAL_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalGatewayId").getter(LocalGatewayVirtualInterfaceGroup.getter(LocalGatewayVirtualInterfaceGroup::localGatewayId)).setter(LocalGatewayVirtualInterfaceGroup.setter(Builder::localGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayId").unmarshallLocationName("localGatewayId").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(LocalGatewayVirtualInterfaceGroup.getter(LocalGatewayVirtualInterfaceGroup::ownerId)).setter(LocalGatewayVirtualInterfaceGroup.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(LocalGatewayVirtualInterfaceGroup.getter(LocalGatewayVirtualInterfaceGroup::tags)).setter(LocalGatewayVirtualInterfaceGroup.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD, LOCAL_GATEWAY_VIRTUAL_INTERFACE_IDS_FIELD, LOCAL_GATEWAY_ID_FIELD, OWNER_ID_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LocalGatewayVirtualInterfaceGroupId", LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD);
            this.put("LocalGatewayVirtualInterfaceIdSet", LOCAL_GATEWAY_VIRTUAL_INTERFACE_IDS_FIELD);
            this.put("LocalGatewayId", LOCAL_GATEWAY_ID_FIELD);
            this.put("OwnerId", OWNER_ID_FIELD);
            this.put("TagSet", TAGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String localGatewayVirtualInterfaceGroupId;
    private final List<String> localGatewayVirtualInterfaceIds;
    private final String localGatewayId;
    private final String ownerId;
    private final List<Tag> tags;

    private LocalGatewayVirtualInterfaceGroup(BuilderImpl builder) {
        this.localGatewayVirtualInterfaceGroupId = builder.localGatewayVirtualInterfaceGroupId;
        this.localGatewayVirtualInterfaceIds = builder.localGatewayVirtualInterfaceIds;
        this.localGatewayId = builder.localGatewayId;
        this.ownerId = builder.ownerId;
        this.tags = builder.tags;
    }

    public final String localGatewayVirtualInterfaceGroupId() {
        return this.localGatewayVirtualInterfaceGroupId;
    }

    public final boolean hasLocalGatewayVirtualInterfaceIds() {
        return this.localGatewayVirtualInterfaceIds != null && !(this.localGatewayVirtualInterfaceIds instanceof SdkAutoConstructList);
    }

    public final List<String> localGatewayVirtualInterfaceIds() {
        return this.localGatewayVirtualInterfaceIds;
    }

    public final String localGatewayId() {
        return this.localGatewayId;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.localGatewayVirtualInterfaceGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocalGatewayVirtualInterfaceIds() ? this.localGatewayVirtualInterfaceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.localGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalGatewayVirtualInterfaceGroup)) {
            return false;
        }
        LocalGatewayVirtualInterfaceGroup other = (LocalGatewayVirtualInterfaceGroup)obj;
        return Objects.equals(this.localGatewayVirtualInterfaceGroupId(), other.localGatewayVirtualInterfaceGroupId()) && this.hasLocalGatewayVirtualInterfaceIds() == other.hasLocalGatewayVirtualInterfaceIds() && Objects.equals(this.localGatewayVirtualInterfaceIds(), other.localGatewayVirtualInterfaceIds()) && Objects.equals(this.localGatewayId(), other.localGatewayId()) && Objects.equals(this.ownerId(), other.ownerId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"LocalGatewayVirtualInterfaceGroup").add("LocalGatewayVirtualInterfaceGroupId", (Object)this.localGatewayVirtualInterfaceGroupId()).add("LocalGatewayVirtualInterfaceIds", this.hasLocalGatewayVirtualInterfaceIds() ? this.localGatewayVirtualInterfaceIds() : null).add("LocalGatewayId", (Object)this.localGatewayId()).add("OwnerId", (Object)this.ownerId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocalGatewayVirtualInterfaceGroupId": {
                return Optional.ofNullable(clazz.cast(this.localGatewayVirtualInterfaceGroupId()));
            }
            case "LocalGatewayVirtualInterfaceIds": {
                return Optional.ofNullable(clazz.cast(this.localGatewayVirtualInterfaceIds()));
            }
            case "LocalGatewayId": {
                return Optional.ofNullable(clazz.cast(this.localGatewayId()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LocalGatewayVirtualInterfaceGroup, T> g) {
        return obj -> g.apply((LocalGatewayVirtualInterfaceGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String localGatewayVirtualInterfaceGroupId;
        private List<String> localGatewayVirtualInterfaceIds = DefaultSdkAutoConstructList.getInstance();
        private String localGatewayId;
        private String ownerId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LocalGatewayVirtualInterfaceGroup model) {
            this.localGatewayVirtualInterfaceGroupId(model.localGatewayVirtualInterfaceGroupId);
            this.localGatewayVirtualInterfaceIds(model.localGatewayVirtualInterfaceIds);
            this.localGatewayId(model.localGatewayId);
            this.ownerId(model.ownerId);
            this.tags(model.tags);
        }

        public final String getLocalGatewayVirtualInterfaceGroupId() {
            return this.localGatewayVirtualInterfaceGroupId;
        }

        public final void setLocalGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
        }

        @Override
        public final Builder localGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
            return this;
        }

        public final Collection<String> getLocalGatewayVirtualInterfaceIds() {
            if (this.localGatewayVirtualInterfaceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.localGatewayVirtualInterfaceIds;
        }

        public final void setLocalGatewayVirtualInterfaceIds(Collection<String> localGatewayVirtualInterfaceIds) {
            this.localGatewayVirtualInterfaceIds = LocalGatewayVirtualInterfaceIdSetCopier.copy(localGatewayVirtualInterfaceIds);
        }

        @Override
        public final Builder localGatewayVirtualInterfaceIds(Collection<String> localGatewayVirtualInterfaceIds) {
            this.localGatewayVirtualInterfaceIds = LocalGatewayVirtualInterfaceIdSetCopier.copy(localGatewayVirtualInterfaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localGatewayVirtualInterfaceIds(String ... localGatewayVirtualInterfaceIds) {
            this.localGatewayVirtualInterfaceIds(Arrays.asList(localGatewayVirtualInterfaceIds));
            return this;
        }

        public final String getLocalGatewayId() {
            return this.localGatewayId;
        }

        public final void setLocalGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
        }

        @Override
        public final Builder localGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LocalGatewayVirtualInterfaceGroup build() {
            return new LocalGatewayVirtualInterfaceGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LocalGatewayVirtualInterfaceGroup> {
        public Builder localGatewayVirtualInterfaceGroupId(String var1);

        public Builder localGatewayVirtualInterfaceIds(Collection<String> var1);

        public Builder localGatewayVirtualInterfaceIds(String ... var1);

        public Builder localGatewayId(String var1);

        public Builder ownerId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

