/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InterfacePermissionType {
    INSTANCE_ATTACH("INSTANCE-ATTACH"),
    EIP_ASSOCIATE("EIP-ASSOCIATE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InterfacePermissionType> VALUE_MAP;
    private final String value;

    private InterfacePermissionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InterfacePermissionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InterfacePermissionType> knownValues() {
        EnumSet<InterfacePermissionType> knownValues = EnumSet.allOf(InterfacePermissionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InterfacePermissionType.class, InterfacePermissionType::toString);
    }
}

