/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.SSEType;
import software.amazon.awssdk.services.ec2.model.SnapshotState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreSnapshotFromRecycleBinResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, RestoreSnapshotFromRecycleBinResponse> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(RestoreSnapshotFromRecycleBinResponse.getter(RestoreSnapshotFromRecycleBinResponse::snapshotId)).setter(RestoreSnapshotFromRecycleBinResponse.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("snapshotId").build()}).build();
    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostArn").getter(RestoreSnapshotFromRecycleBinResponse.getter(RestoreSnapshotFromRecycleBinResponse::outpostArn)).setter(RestoreSnapshotFromRecycleBinResponse.setter(Builder::outpostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn").unmarshallLocationName("outpostArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(RestoreSnapshotFromRecycleBinResponse.getter(RestoreSnapshotFromRecycleBinResponse::description)).setter(RestoreSnapshotFromRecycleBinResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Encrypted").getter(RestoreSnapshotFromRecycleBinResponse.getter(RestoreSnapshotFromRecycleBinResponse::encrypted)).setter(RestoreSnapshotFromRecycleBinResponse.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").unmarshallLocationName("encrypted").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(RestoreSnapshotFromRecycleBinResponse.getter(RestoreSnapshotFromRecycleBinResponse::ownerId)).setter(RestoreSnapshotFromRecycleBinResponse.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Progress").getter(RestoreSnapshotFromRecycleBinResponse.getter(RestoreSnapshotFromRecycleBinResponse::progress)).setter(RestoreSnapshotFromRecycleBinResponse.setter(Builder::progress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress").unmarshallLocationName("progress").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(RestoreSnapshotFromRecycleBinResponse.getter(RestoreSnapshotFromRecycleBinResponse::startTime)).setter(RestoreSnapshotFromRecycleBinResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").unmarshallLocationName("startTime").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(RestoreSnapshotFromRecycleBinResponse.getter(RestoreSnapshotFromRecycleBinResponse::stateAsString)).setter(RestoreSnapshotFromRecycleBinResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeId").getter(RestoreSnapshotFromRecycleBinResponse.getter(RestoreSnapshotFromRecycleBinResponse::volumeId)).setter(RestoreSnapshotFromRecycleBinResponse.setter(Builder::volumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").unmarshallLocationName("volumeId").build()}).build();
    private static final SdkField<Integer> VOLUME_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VolumeSize").getter(RestoreSnapshotFromRecycleBinResponse.getter(RestoreSnapshotFromRecycleBinResponse::volumeSize)).setter(RestoreSnapshotFromRecycleBinResponse.setter(Builder::volumeSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSize").unmarshallLocationName("volumeSize").build()}).build();
    private static final SdkField<String> SSE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SseType").getter(RestoreSnapshotFromRecycleBinResponse.getter(RestoreSnapshotFromRecycleBinResponse::sseTypeAsString)).setter(RestoreSnapshotFromRecycleBinResponse.setter(Builder::sseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseType").unmarshallLocationName("sseType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD, OUTPOST_ARN_FIELD, DESCRIPTION_FIELD, ENCRYPTED_FIELD, OWNER_ID_FIELD, PROGRESS_FIELD, START_TIME_FIELD, STATE_FIELD, VOLUME_ID_FIELD, VOLUME_SIZE_FIELD, SSE_TYPE_FIELD));
    private final String snapshotId;
    private final String outpostArn;
    private final String description;
    private final Boolean encrypted;
    private final String ownerId;
    private final String progress;
    private final Instant startTime;
    private final String state;
    private final String volumeId;
    private final Integer volumeSize;
    private final String sseType;

    private RestoreSnapshotFromRecycleBinResponse(BuilderImpl builder) {
        super(builder);
        this.snapshotId = builder.snapshotId;
        this.outpostArn = builder.outpostArn;
        this.description = builder.description;
        this.encrypted = builder.encrypted;
        this.ownerId = builder.ownerId;
        this.progress = builder.progress;
        this.startTime = builder.startTime;
        this.state = builder.state;
        this.volumeId = builder.volumeId;
        this.volumeSize = builder.volumeSize;
        this.sseType = builder.sseType;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final String outpostArn() {
        return this.outpostArn;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean encrypted() {
        return this.encrypted;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String progress() {
        return this.progress;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final SnapshotState state() {
        return SnapshotState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String volumeId() {
        return this.volumeId;
    }

    public final Integer volumeSize() {
        return this.volumeSize;
    }

    public final SSEType sseType() {
        return SSEType.fromValue(this.sseType);
    }

    public final String sseTypeAsString() {
        return this.sseType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.progress());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreSnapshotFromRecycleBinResponse)) {
            return false;
        }
        RestoreSnapshotFromRecycleBinResponse other = (RestoreSnapshotFromRecycleBinResponse)((Object)obj);
        return Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.outpostArn(), other.outpostArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.progress(), other.progress()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.volumeId(), other.volumeId()) && Objects.equals(this.volumeSize(), other.volumeSize()) && Objects.equals(this.sseTypeAsString(), other.sseTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RestoreSnapshotFromRecycleBinResponse").add("SnapshotId", (Object)this.snapshotId()).add("OutpostArn", (Object)this.outpostArn()).add("Description", (Object)this.description()).add("Encrypted", (Object)this.encrypted()).add("OwnerId", (Object)this.ownerId()).add("Progress", (Object)this.progress()).add("StartTime", (Object)this.startTime()).add("State", (Object)this.stateAsString()).add("VolumeId", (Object)this.volumeId()).add("VolumeSize", (Object)this.volumeSize()).add("SseType", (Object)this.sseTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "OutpostArn": {
                return Optional.ofNullable(clazz.cast(this.outpostArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "Progress": {
                return Optional.ofNullable(clazz.cast(this.progress()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "VolumeId": {
                return Optional.ofNullable(clazz.cast(this.volumeId()));
            }
            case "VolumeSize": {
                return Optional.ofNullable(clazz.cast(this.volumeSize()));
            }
            case "SseType": {
                return Optional.ofNullable(clazz.cast(this.sseTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreSnapshotFromRecycleBinResponse, T> g) {
        return obj -> g.apply((RestoreSnapshotFromRecycleBinResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String snapshotId;
        private String outpostArn;
        private String description;
        private Boolean encrypted;
        private String ownerId;
        private String progress;
        private Instant startTime;
        private String state;
        private String volumeId;
        private Integer volumeSize;
        private String sseType;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreSnapshotFromRecycleBinResponse model) {
            super(model);
            this.snapshotId(model.snapshotId);
            this.outpostArn(model.outpostArn);
            this.description(model.description);
            this.encrypted(model.encrypted);
            this.ownerId(model.ownerId);
            this.progress(model.progress);
            this.startTime(model.startTime);
            this.state(model.state);
            this.volumeId(model.volumeId);
            this.volumeSize(model.volumeSize);
            this.sseType(model.sseType);
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getOutpostArn() {
            return this.outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getProgress() {
            return this.progress;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SnapshotState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final Integer getVolumeSize() {
            return this.volumeSize;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final String getSseType() {
            return this.sseType;
        }

        public final void setSseType(String sseType) {
            this.sseType = sseType;
        }

        @Override
        public final Builder sseType(String sseType) {
            this.sseType = sseType;
            return this;
        }

        @Override
        public final Builder sseType(SSEType sseType) {
            this.sseType(sseType == null ? null : sseType.toString());
            return this;
        }

        @Override
        public RestoreSnapshotFromRecycleBinResponse build() {
            return new RestoreSnapshotFromRecycleBinResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RestoreSnapshotFromRecycleBinResponse> {
        public Builder snapshotId(String var1);

        public Builder outpostArn(String var1);

        public Builder description(String var1);

        public Builder encrypted(Boolean var1);

        public Builder ownerId(String var1);

        public Builder progress(String var1);

        public Builder startTime(Instant var1);

        public Builder state(String var1);

        public Builder state(SnapshotState var1);

        public Builder volumeId(String var1);

        public Builder volumeSize(Integer var1);

        public Builder sseType(String var1);

        public Builder sseType(SSEType var1);
    }
}

