/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusResponse;
import software.amazon.awssdk.services.ec2.model.VolumeStatusItem;

public class DescribeVolumeStatusIterable
implements SdkIterable<DescribeVolumeStatusResponse> {
    private final Ec2Client client;
    private final DescribeVolumeStatusRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeVolumeStatusIterable(Ec2Client client, DescribeVolumeStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeVolumeStatusResponseFetcher();
    }

    public Iterator<DescribeVolumeStatusResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VolumeStatusItem> volumeStatuses() {
        Function<DescribeVolumeStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.volumeStatuses() != null) {
                return response.volumeStatuses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeVolumeStatusResponseFetcher
    implements SyncPageFetcher<DescribeVolumeStatusResponse> {
        private DescribeVolumeStatusResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVolumeStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeVolumeStatusResponse nextPage(DescribeVolumeStatusResponse previousPage) {
            if (previousPage == null) {
                return DescribeVolumeStatusIterable.this.client.describeVolumeStatus(DescribeVolumeStatusIterable.this.firstRequest);
            }
            return DescribeVolumeStatusIterable.this.client.describeVolumeStatus((DescribeVolumeStatusRequest)((Object)DescribeVolumeStatusIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

