/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteTrafficMirrorFilterRuleRequest extends Ec2Request implements
        ToCopyableBuilder<DeleteTrafficMirrorFilterRuleRequest.Builder, DeleteTrafficMirrorFilterRuleRequest> {
    private static final SdkField<String> TRAFFIC_MIRROR_FILTER_RULE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrafficMirrorFilterRuleId")
            .getter(getter(DeleteTrafficMirrorFilterRuleRequest::trafficMirrorFilterRuleId))
            .setter(setter(Builder::trafficMirrorFilterRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterRuleId")
                    .unmarshallLocationName("TrafficMirrorFilterRuleId").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(DeleteTrafficMirrorFilterRuleRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRAFFIC_MIRROR_FILTER_RULE_ID_FIELD, DRY_RUN_FIELD));

    private final String trafficMirrorFilterRuleId;

    private final Boolean dryRun;

    private DeleteTrafficMirrorFilterRuleRequest(BuilderImpl builder) {
        super(builder);
        this.trafficMirrorFilterRuleId = builder.trafficMirrorFilterRuleId;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The ID of the Traffic Mirror rule.
     * </p>
     * 
     * @return The ID of the Traffic Mirror rule.
     */
    public final String trafficMirrorFilterRuleId() {
        return trafficMirrorFilterRuleId;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorFilterRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTrafficMirrorFilterRuleRequest)) {
            return false;
        }
        DeleteTrafficMirrorFilterRuleRequest other = (DeleteTrafficMirrorFilterRuleRequest) obj;
        return Objects.equals(trafficMirrorFilterRuleId(), other.trafficMirrorFilterRuleId())
                && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteTrafficMirrorFilterRuleRequest")
                .add("TrafficMirrorFilterRuleId", trafficMirrorFilterRuleId()).add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficMirrorFilterRuleId":
            return Optional.ofNullable(clazz.cast(trafficMirrorFilterRuleId()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteTrafficMirrorFilterRuleRequest, T> g) {
        return obj -> g.apply((DeleteTrafficMirrorFilterRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DeleteTrafficMirrorFilterRuleRequest> {
        /**
         * <p>
         * The ID of the Traffic Mirror rule.
         * </p>
         * 
         * @param trafficMirrorFilterRuleId
         *        The ID of the Traffic Mirror rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorFilterRuleId(String trafficMirrorFilterRuleId);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String trafficMirrorFilterRuleId;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTrafficMirrorFilterRuleRequest model) {
            super(model);
            trafficMirrorFilterRuleId(model.trafficMirrorFilterRuleId);
            dryRun(model.dryRun);
        }

        public final String getTrafficMirrorFilterRuleId() {
            return trafficMirrorFilterRuleId;
        }

        public final void setTrafficMirrorFilterRuleId(String trafficMirrorFilterRuleId) {
            this.trafficMirrorFilterRuleId = trafficMirrorFilterRuleId;
        }

        @Override
        public final Builder trafficMirrorFilterRuleId(String trafficMirrorFilterRuleId) {
            this.trafficMirrorFilterRuleId = trafficMirrorFilterRuleId;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteTrafficMirrorFilterRuleRequest build() {
            return new DeleteTrafficMirrorFilterRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
