/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImageTypeValues {
    MACHINE("machine"),
    KERNEL("kernel"),
    RAMDISK("ramdisk"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImageTypeValues> VALUE_MAP;
    private final String value;

    private ImageTypeValues(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImageTypeValues fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImageTypeValues> knownValues() {
        EnumSet<ImageTypeValues> knownValues = EnumSet.allOf(ImageTypeValues.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImageTypeValues.class, ImageTypeValues::toString);
    }
}

