/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The historical record of a CIDR within an IPAM scope. For more information, see <a
 * href="https://docs.aws.amazon.com/vpc/latest/ipam/view-history-cidr-ipam.html">View the history of IP addresses</a>
 * in the <i>Amazon VPC IPAM User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpamAddressHistoryRecord implements SdkPojo, Serializable,
        ToCopyableBuilder<IpamAddressHistoryRecord.Builder, IpamAddressHistoryRecord> {
    private static final SdkField<String> RESOURCE_OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceOwnerId")
            .getter(getter(IpamAddressHistoryRecord::resourceOwnerId))
            .setter(setter(Builder::resourceOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwnerId")
                    .unmarshallLocationName("resourceOwnerId").build()).build();

    private static final SdkField<String> RESOURCE_REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceRegion")
            .getter(getter(IpamAddressHistoryRecord::resourceRegion))
            .setter(setter(Builder::resourceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRegion")
                    .unmarshallLocationName("resourceRegion").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceType")
            .getter(getter(IpamAddressHistoryRecord::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType")
                    .unmarshallLocationName("resourceType").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceId")
            .getter(getter(IpamAddressHistoryRecord::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId")
                    .unmarshallLocationName("resourceId").build()).build();

    private static final SdkField<String> RESOURCE_CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceCidr")
            .getter(getter(IpamAddressHistoryRecord::resourceCidr))
            .setter(setter(Builder::resourceCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCidr")
                    .unmarshallLocationName("resourceCidr").build()).build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceName")
            .getter(getter(IpamAddressHistoryRecord::resourceName))
            .setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName")
                    .unmarshallLocationName("resourceName").build()).build();

    private static final SdkField<String> RESOURCE_COMPLIANCE_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceComplianceStatus")
            .getter(getter(IpamAddressHistoryRecord::resourceComplianceStatusAsString))
            .setter(setter(Builder::resourceComplianceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceComplianceStatus")
                    .unmarshallLocationName("resourceComplianceStatus").build()).build();

    private static final SdkField<String> RESOURCE_OVERLAP_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceOverlapStatus")
            .getter(getter(IpamAddressHistoryRecord::resourceOverlapStatusAsString))
            .setter(setter(Builder::resourceOverlapStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOverlapStatus")
                    .unmarshallLocationName("resourceOverlapStatus").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcId")
            .getter(getter(IpamAddressHistoryRecord::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("vpcId").build()).build();

    private static final SdkField<Instant> SAMPLED_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("SampledStartTime")
            .getter(getter(IpamAddressHistoryRecord::sampledStartTime))
            .setter(setter(Builder::sampledStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampledStartTime")
                    .unmarshallLocationName("sampledStartTime").build()).build();

    private static final SdkField<Instant> SAMPLED_END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("SampledEndTime")
            .getter(getter(IpamAddressHistoryRecord::sampledEndTime))
            .setter(setter(Builder::sampledEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampledEndTime")
                    .unmarshallLocationName("sampledEndTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_OWNER_ID_FIELD,
            RESOURCE_REGION_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, RESOURCE_CIDR_FIELD, RESOURCE_NAME_FIELD,
            RESOURCE_COMPLIANCE_STATUS_FIELD, RESOURCE_OVERLAP_STATUS_FIELD, VPC_ID_FIELD, SAMPLED_START_TIME_FIELD,
            SAMPLED_END_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceOwnerId;

    private final String resourceRegion;

    private final String resourceType;

    private final String resourceId;

    private final String resourceCidr;

    private final String resourceName;

    private final String resourceComplianceStatus;

    private final String resourceOverlapStatus;

    private final String vpcId;

    private final Instant sampledStartTime;

    private final Instant sampledEndTime;

    private IpamAddressHistoryRecord(BuilderImpl builder) {
        this.resourceOwnerId = builder.resourceOwnerId;
        this.resourceRegion = builder.resourceRegion;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.resourceCidr = builder.resourceCidr;
        this.resourceName = builder.resourceName;
        this.resourceComplianceStatus = builder.resourceComplianceStatus;
        this.resourceOverlapStatus = builder.resourceOverlapStatus;
        this.vpcId = builder.vpcId;
        this.sampledStartTime = builder.sampledStartTime;
        this.sampledEndTime = builder.sampledEndTime;
    }

    /**
     * <p>
     * The ID of the resource owner.
     * </p>
     * 
     * @return The ID of the resource owner.
     */
    public final String resourceOwnerId() {
        return resourceOwnerId;
    }

    /**
     * <p>
     * The Amazon Web Services Region of the resource.
     * </p>
     * 
     * @return The Amazon Web Services Region of the resource.
     */
    public final String resourceRegion() {
        return resourceRegion;
    }

    /**
     * <p>
     * The type of the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link IpamAddressHistoryResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the resource.
     * @see IpamAddressHistoryResourceType
     */
    public final IpamAddressHistoryResourceType resourceType() {
        return IpamAddressHistoryResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link IpamAddressHistoryResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the resource.
     * @see IpamAddressHistoryResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The ID of the resource.
     * </p>
     * 
     * @return The ID of the resource.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The CIDR of the resource.
     * </p>
     * 
     * @return The CIDR of the resource.
     */
    public final String resourceCidr() {
        return resourceCidr;
    }

    /**
     * <p>
     * The name of the resource.
     * </p>
     * 
     * @return The name of the resource.
     */
    public final String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The compliance status of a resource. For more information on compliance statuses, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/ipam/monitor-cidr-compliance-ipam.html">Monitor CIDR usage by
     * resource</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resourceComplianceStatus} will return {@link IpamComplianceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #resourceComplianceStatusAsString}.
     * </p>
     * 
     * @return The compliance status of a resource. For more information on compliance statuses, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/ipam/monitor-cidr-compliance-ipam.html">Monitor CIDR usage
     *         by resource</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * @see IpamComplianceStatus
     */
    public final IpamComplianceStatus resourceComplianceStatus() {
        return IpamComplianceStatus.fromValue(resourceComplianceStatus);
    }

    /**
     * <p>
     * The compliance status of a resource. For more information on compliance statuses, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/ipam/monitor-cidr-compliance-ipam.html">Monitor CIDR usage by
     * resource</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resourceComplianceStatus} will return {@link IpamComplianceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #resourceComplianceStatusAsString}.
     * </p>
     * 
     * @return The compliance status of a resource. For more information on compliance statuses, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/ipam/monitor-cidr-compliance-ipam.html">Monitor CIDR usage
     *         by resource</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * @see IpamComplianceStatus
     */
    public final String resourceComplianceStatusAsString() {
        return resourceComplianceStatus;
    }

    /**
     * <p>
     * The overlap status of an IPAM resource. The overlap status tells you if the CIDR for a resource overlaps with
     * another CIDR in the scope. For more information on overlap statuses, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/ipam/monitor-cidr-compliance-ipam.html">Monitor CIDR usage by
     * resource</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resourceOverlapStatus} will return {@link IpamOverlapStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #resourceOverlapStatusAsString}.
     * </p>
     * 
     * @return The overlap status of an IPAM resource. The overlap status tells you if the CIDR for a resource overlaps
     *         with another CIDR in the scope. For more information on overlap statuses, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/ipam/monitor-cidr-compliance-ipam.html">Monitor CIDR usage
     *         by resource</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * @see IpamOverlapStatus
     */
    public final IpamOverlapStatus resourceOverlapStatus() {
        return IpamOverlapStatus.fromValue(resourceOverlapStatus);
    }

    /**
     * <p>
     * The overlap status of an IPAM resource. The overlap status tells you if the CIDR for a resource overlaps with
     * another CIDR in the scope. For more information on overlap statuses, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/ipam/monitor-cidr-compliance-ipam.html">Monitor CIDR usage by
     * resource</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resourceOverlapStatus} will return {@link IpamOverlapStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #resourceOverlapStatusAsString}.
     * </p>
     * 
     * @return The overlap status of an IPAM resource. The overlap status tells you if the CIDR for a resource overlaps
     *         with another CIDR in the scope. For more information on overlap statuses, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/ipam/monitor-cidr-compliance-ipam.html">Monitor CIDR usage
     *         by resource</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * @see IpamOverlapStatus
     */
    public final String resourceOverlapStatusAsString() {
        return resourceOverlapStatus;
    }

    /**
     * <p>
     * The VPC ID of the resource.
     * </p>
     * 
     * @return The VPC ID of the resource.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * Sampled start time of the resource-to-CIDR association within the IPAM scope. Changes are picked up in periodic
     * snapshots, so the start time may have occurred before this specific time.
     * </p>
     * 
     * @return Sampled start time of the resource-to-CIDR association within the IPAM scope. Changes are picked up in
     *         periodic snapshots, so the start time may have occurred before this specific time.
     */
    public final Instant sampledStartTime() {
        return sampledStartTime;
    }

    /**
     * <p>
     * Sampled end time of the resource-to-CIDR association within the IPAM scope. Changes are picked up in periodic
     * snapshots, so the end time may have occurred before this specific time.
     * </p>
     * 
     * @return Sampled end time of the resource-to-CIDR association within the IPAM scope. Changes are picked up in
     *         periodic snapshots, so the end time may have occurred before this specific time.
     */
    public final Instant sampledEndTime() {
        return sampledEndTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceCidr());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceComplianceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceOverlapStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(sampledStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(sampledEndTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamAddressHistoryRecord)) {
            return false;
        }
        IpamAddressHistoryRecord other = (IpamAddressHistoryRecord) obj;
        return Objects.equals(resourceOwnerId(), other.resourceOwnerId())
                && Objects.equals(resourceRegion(), other.resourceRegion())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(resourceCidr(), other.resourceCidr())
                && Objects.equals(resourceName(), other.resourceName())
                && Objects.equals(resourceComplianceStatusAsString(), other.resourceComplianceStatusAsString())
                && Objects.equals(resourceOverlapStatusAsString(), other.resourceOverlapStatusAsString())
                && Objects.equals(vpcId(), other.vpcId()) && Objects.equals(sampledStartTime(), other.sampledStartTime())
                && Objects.equals(sampledEndTime(), other.sampledEndTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IpamAddressHistoryRecord").add("ResourceOwnerId", resourceOwnerId())
                .add("ResourceRegion", resourceRegion()).add("ResourceType", resourceTypeAsString())
                .add("ResourceId", resourceId()).add("ResourceCidr", resourceCidr()).add("ResourceName", resourceName())
                .add("ResourceComplianceStatus", resourceComplianceStatusAsString())
                .add("ResourceOverlapStatus", resourceOverlapStatusAsString()).add("VpcId", vpcId())
                .add("SampledStartTime", sampledStartTime()).add("SampledEndTime", sampledEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceOwnerId":
            return Optional.ofNullable(clazz.cast(resourceOwnerId()));
        case "ResourceRegion":
            return Optional.ofNullable(clazz.cast(resourceRegion()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceCidr":
            return Optional.ofNullable(clazz.cast(resourceCidr()));
        case "ResourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "ResourceComplianceStatus":
            return Optional.ofNullable(clazz.cast(resourceComplianceStatusAsString()));
        case "ResourceOverlapStatus":
            return Optional.ofNullable(clazz.cast(resourceOverlapStatusAsString()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "SampledStartTime":
            return Optional.ofNullable(clazz.cast(sampledStartTime()));
        case "SampledEndTime":
            return Optional.ofNullable(clazz.cast(sampledEndTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IpamAddressHistoryRecord, T> g) {
        return obj -> g.apply((IpamAddressHistoryRecord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpamAddressHistoryRecord> {
        /**
         * <p>
         * The ID of the resource owner.
         * </p>
         * 
         * @param resourceOwnerId
         *        The ID of the resource owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceOwnerId(String resourceOwnerId);

        /**
         * <p>
         * The Amazon Web Services Region of the resource.
         * </p>
         * 
         * @param resourceRegion
         *        The Amazon Web Services Region of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRegion(String resourceRegion);

        /**
         * <p>
         * The type of the resource.
         * </p>
         * 
         * @param resourceType
         *        The type of the resource.
         * @see IpamAddressHistoryResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamAddressHistoryResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of the resource.
         * </p>
         * 
         * @param resourceType
         *        The type of the resource.
         * @see IpamAddressHistoryResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamAddressHistoryResourceType
         */
        Builder resourceType(IpamAddressHistoryResourceType resourceType);

        /**
         * <p>
         * The ID of the resource.
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The CIDR of the resource.
         * </p>
         * 
         * @param resourceCidr
         *        The CIDR of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCidr(String resourceCidr);

        /**
         * <p>
         * The name of the resource.
         * </p>
         * 
         * @param resourceName
         *        The name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The compliance status of a resource. For more information on compliance statuses, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/ipam/monitor-cidr-compliance-ipam.html">Monitor CIDR usage by
         * resource</a> in the <i>Amazon VPC IPAM User Guide</i>.
         * </p>
         * 
         * @param resourceComplianceStatus
         *        The compliance status of a resource. For more information on compliance statuses, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/ipam/monitor-cidr-compliance-ipam.html">Monitor CIDR
         *        usage by resource</a> in the <i>Amazon VPC IPAM User Guide</i>.
         * @see IpamComplianceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamComplianceStatus
         */
        Builder resourceComplianceStatus(String resourceComplianceStatus);

        /**
         * <p>
         * The compliance status of a resource. For more information on compliance statuses, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/ipam/monitor-cidr-compliance-ipam.html">Monitor CIDR usage by
         * resource</a> in the <i>Amazon VPC IPAM User Guide</i>.
         * </p>
         * 
         * @param resourceComplianceStatus
         *        The compliance status of a resource. For more information on compliance statuses, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/ipam/monitor-cidr-compliance-ipam.html">Monitor CIDR
         *        usage by resource</a> in the <i>Amazon VPC IPAM User Guide</i>.
         * @see IpamComplianceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamComplianceStatus
         */
        Builder resourceComplianceStatus(IpamComplianceStatus resourceComplianceStatus);

        /**
         * <p>
         * The overlap status of an IPAM resource. The overlap status tells you if the CIDR for a resource overlaps with
         * another CIDR in the scope. For more information on overlap statuses, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/ipam/monitor-cidr-compliance-ipam.html">Monitor CIDR usage by
         * resource</a> in the <i>Amazon VPC IPAM User Guide</i>.
         * </p>
         * 
         * @param resourceOverlapStatus
         *        The overlap status of an IPAM resource. The overlap status tells you if the CIDR for a resource
         *        overlaps with another CIDR in the scope. For more information on overlap statuses, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/ipam/monitor-cidr-compliance-ipam.html">Monitor CIDR
         *        usage by resource</a> in the <i>Amazon VPC IPAM User Guide</i>.
         * @see IpamOverlapStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamOverlapStatus
         */
        Builder resourceOverlapStatus(String resourceOverlapStatus);

        /**
         * <p>
         * The overlap status of an IPAM resource. The overlap status tells you if the CIDR for a resource overlaps with
         * another CIDR in the scope. For more information on overlap statuses, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/ipam/monitor-cidr-compliance-ipam.html">Monitor CIDR usage by
         * resource</a> in the <i>Amazon VPC IPAM User Guide</i>.
         * </p>
         * 
         * @param resourceOverlapStatus
         *        The overlap status of an IPAM resource. The overlap status tells you if the CIDR for a resource
         *        overlaps with another CIDR in the scope. For more information on overlap statuses, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/ipam/monitor-cidr-compliance-ipam.html">Monitor CIDR
         *        usage by resource</a> in the <i>Amazon VPC IPAM User Guide</i>.
         * @see IpamOverlapStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamOverlapStatus
         */
        Builder resourceOverlapStatus(IpamOverlapStatus resourceOverlapStatus);

        /**
         * <p>
         * The VPC ID of the resource.
         * </p>
         * 
         * @param vpcId
         *        The VPC ID of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * Sampled start time of the resource-to-CIDR association within the IPAM scope. Changes are picked up in
         * periodic snapshots, so the start time may have occurred before this specific time.
         * </p>
         * 
         * @param sampledStartTime
         *        Sampled start time of the resource-to-CIDR association within the IPAM scope. Changes are picked up in
         *        periodic snapshots, so the start time may have occurred before this specific time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampledStartTime(Instant sampledStartTime);

        /**
         * <p>
         * Sampled end time of the resource-to-CIDR association within the IPAM scope. Changes are picked up in periodic
         * snapshots, so the end time may have occurred before this specific time.
         * </p>
         * 
         * @param sampledEndTime
         *        Sampled end time of the resource-to-CIDR association within the IPAM scope. Changes are picked up in
         *        periodic snapshots, so the end time may have occurred before this specific time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampledEndTime(Instant sampledEndTime);
    }

    static final class BuilderImpl implements Builder {
        private String resourceOwnerId;

        private String resourceRegion;

        private String resourceType;

        private String resourceId;

        private String resourceCidr;

        private String resourceName;

        private String resourceComplianceStatus;

        private String resourceOverlapStatus;

        private String vpcId;

        private Instant sampledStartTime;

        private Instant sampledEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(IpamAddressHistoryRecord model) {
            resourceOwnerId(model.resourceOwnerId);
            resourceRegion(model.resourceRegion);
            resourceType(model.resourceType);
            resourceId(model.resourceId);
            resourceCidr(model.resourceCidr);
            resourceName(model.resourceName);
            resourceComplianceStatus(model.resourceComplianceStatus);
            resourceOverlapStatus(model.resourceOverlapStatus);
            vpcId(model.vpcId);
            sampledStartTime(model.sampledStartTime);
            sampledEndTime(model.sampledEndTime);
        }

        public final String getResourceOwnerId() {
            return resourceOwnerId;
        }

        public final void setResourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
        }

        @Override
        public final Builder resourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public final String getResourceRegion() {
            return resourceRegion;
        }

        public final void setResourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
        }

        @Override
        public final Builder resourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(IpamAddressHistoryResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceCidr() {
            return resourceCidr;
        }

        public final void setResourceCidr(String resourceCidr) {
            this.resourceCidr = resourceCidr;
        }

        @Override
        public final Builder resourceCidr(String resourceCidr) {
            this.resourceCidr = resourceCidr;
            return this;
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getResourceComplianceStatus() {
            return resourceComplianceStatus;
        }

        public final void setResourceComplianceStatus(String resourceComplianceStatus) {
            this.resourceComplianceStatus = resourceComplianceStatus;
        }

        @Override
        public final Builder resourceComplianceStatus(String resourceComplianceStatus) {
            this.resourceComplianceStatus = resourceComplianceStatus;
            return this;
        }

        @Override
        public final Builder resourceComplianceStatus(IpamComplianceStatus resourceComplianceStatus) {
            this.resourceComplianceStatus(resourceComplianceStatus == null ? null : resourceComplianceStatus.toString());
            return this;
        }

        public final String getResourceOverlapStatus() {
            return resourceOverlapStatus;
        }

        public final void setResourceOverlapStatus(String resourceOverlapStatus) {
            this.resourceOverlapStatus = resourceOverlapStatus;
        }

        @Override
        public final Builder resourceOverlapStatus(String resourceOverlapStatus) {
            this.resourceOverlapStatus = resourceOverlapStatus;
            return this;
        }

        @Override
        public final Builder resourceOverlapStatus(IpamOverlapStatus resourceOverlapStatus) {
            this.resourceOverlapStatus(resourceOverlapStatus == null ? null : resourceOverlapStatus.toString());
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Instant getSampledStartTime() {
            return sampledStartTime;
        }

        public final void setSampledStartTime(Instant sampledStartTime) {
            this.sampledStartTime = sampledStartTime;
        }

        @Override
        public final Builder sampledStartTime(Instant sampledStartTime) {
            this.sampledStartTime = sampledStartTime;
            return this;
        }

        public final Instant getSampledEndTime() {
            return sampledEndTime;
        }

        public final void setSampledEndTime(Instant sampledEndTime) {
            this.sampledEndTime = sampledEndTime;
        }

        @Override
        public final Builder sampledEndTime(Instant sampledEndTime) {
            this.sampledEndTime = sampledEndTime;
            return this;
        }

        @Override
        public IpamAddressHistoryRecord build() {
            return new IpamAddressHistoryRecord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
