/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveryAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveryAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociation;

public class DescribeIpamResourceDiscoveryAssociationsIterable
implements SdkIterable<DescribeIpamResourceDiscoveryAssociationsResponse> {
    private final Ec2Client client;
    private final DescribeIpamResourceDiscoveryAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeIpamResourceDiscoveryAssociationsIterable(Ec2Client client, DescribeIpamResourceDiscoveryAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeIpamResourceDiscoveryAssociationsResponseFetcher();
    }

    public Iterator<DescribeIpamResourceDiscoveryAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IpamResourceDiscoveryAssociation> ipamResourceDiscoveryAssociations() {
        Function<DescribeIpamResourceDiscoveryAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ipamResourceDiscoveryAssociations() != null) {
                return response.ipamResourceDiscoveryAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeIpamResourceDiscoveryAssociationsResponseFetcher
    implements SyncPageFetcher<DescribeIpamResourceDiscoveryAssociationsResponse> {
        private DescribeIpamResourceDiscoveryAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeIpamResourceDiscoveryAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeIpamResourceDiscoveryAssociationsResponse nextPage(DescribeIpamResourceDiscoveryAssociationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeIpamResourceDiscoveryAssociationsIterable.this.client.describeIpamResourceDiscoveryAssociations(DescribeIpamResourceDiscoveryAssociationsIterable.this.firstRequest);
            }
            return DescribeIpamResourceDiscoveryAssociationsIterable.this.client.describeIpamResourceDiscoveryAssociations((DescribeIpamResourceDiscoveryAssociationsRequest)((Object)DescribeIpamResourceDiscoveryAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

