/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.EnaSrdSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttachNetworkInterfaceRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, AttachNetworkInterfaceRequest> {
    private static final SdkField<Integer> DEVICE_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DeviceIndex").getter(AttachNetworkInterfaceRequest.getter(AttachNetworkInterfaceRequest::deviceIndex)).setter(AttachNetworkInterfaceRequest.setter(Builder::deviceIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceIndex").unmarshallLocationName("deviceIndex").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(AttachNetworkInterfaceRequest.getter(AttachNetworkInterfaceRequest::instanceId)).setter(AttachNetworkInterfaceRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(AttachNetworkInterfaceRequest.getter(AttachNetworkInterfaceRequest::networkInterfaceId)).setter(AttachNetworkInterfaceRequest.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<Integer> NETWORK_CARD_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NetworkCardIndex").getter(AttachNetworkInterfaceRequest.getter(AttachNetworkInterfaceRequest::networkCardIndex)).setter(AttachNetworkInterfaceRequest.setter(Builder::networkCardIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkCardIndex").unmarshallLocationName("NetworkCardIndex").build()}).build();
    private static final SdkField<EnaSrdSpecification> ENA_SRD_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnaSrdSpecification").getter(AttachNetworkInterfaceRequest.getter(AttachNetworkInterfaceRequest::enaSrdSpecification)).setter(AttachNetworkInterfaceRequest.setter(Builder::enaSrdSpecification)).constructor(EnaSrdSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSrdSpecification").unmarshallLocationName("EnaSrdSpecification").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_INDEX_FIELD, INSTANCE_ID_FIELD, NETWORK_INTERFACE_ID_FIELD, NETWORK_CARD_INDEX_FIELD, ENA_SRD_SPECIFICATION_FIELD));
    private final Integer deviceIndex;
    private final String instanceId;
    private final String networkInterfaceId;
    private final Integer networkCardIndex;
    private final EnaSrdSpecification enaSrdSpecification;

    private AttachNetworkInterfaceRequest(BuilderImpl builder) {
        super(builder);
        this.deviceIndex = builder.deviceIndex;
        this.instanceId = builder.instanceId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.networkCardIndex = builder.networkCardIndex;
        this.enaSrdSpecification = builder.enaSrdSpecification;
    }

    public final Integer deviceIndex() {
        return this.deviceIndex;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final Integer networkCardIndex() {
        return this.networkCardIndex;
    }

    public final EnaSrdSpecification enaSrdSpecification() {
        return this.enaSrdSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkCardIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.enaSrdSpecification());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachNetworkInterfaceRequest)) {
            return false;
        }
        AttachNetworkInterfaceRequest other = (AttachNetworkInterfaceRequest)((Object)obj);
        return Objects.equals(this.deviceIndex(), other.deviceIndex()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.networkCardIndex(), other.networkCardIndex()) && Objects.equals(this.enaSrdSpecification(), other.enaSrdSpecification());
    }

    public final String toString() {
        return ToString.builder((String)"AttachNetworkInterfaceRequest").add("DeviceIndex", (Object)this.deviceIndex()).add("InstanceId", (Object)this.instanceId()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("NetworkCardIndex", (Object)this.networkCardIndex()).add("EnaSrdSpecification", (Object)this.enaSrdSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceIndex": {
                return Optional.ofNullable(clazz.cast(this.deviceIndex()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "NetworkCardIndex": {
                return Optional.ofNullable(clazz.cast(this.networkCardIndex()));
            }
            case "EnaSrdSpecification": {
                return Optional.ofNullable(clazz.cast(this.enaSrdSpecification()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttachNetworkInterfaceRequest, T> g) {
        return obj -> g.apply((AttachNetworkInterfaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Integer deviceIndex;
        private String instanceId;
        private String networkInterfaceId;
        private Integer networkCardIndex;
        private EnaSrdSpecification enaSrdSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachNetworkInterfaceRequest model) {
            super(model);
            this.deviceIndex(model.deviceIndex);
            this.instanceId(model.instanceId);
            this.networkInterfaceId(model.networkInterfaceId);
            this.networkCardIndex(model.networkCardIndex);
            this.enaSrdSpecification(model.enaSrdSpecification);
        }

        public final Integer getDeviceIndex() {
            return this.deviceIndex;
        }

        public final void setDeviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
        }

        @Override
        public final Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final Integer getNetworkCardIndex() {
            return this.networkCardIndex;
        }

        public final void setNetworkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
        }

        @Override
        public final Builder networkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
            return this;
        }

        public final EnaSrdSpecification.Builder getEnaSrdSpecification() {
            return this.enaSrdSpecification != null ? this.enaSrdSpecification.toBuilder() : null;
        }

        public final void setEnaSrdSpecification(EnaSrdSpecification.BuilderImpl enaSrdSpecification) {
            this.enaSrdSpecification = enaSrdSpecification != null ? enaSrdSpecification.build() : null;
        }

        @Override
        public final Builder enaSrdSpecification(EnaSrdSpecification enaSrdSpecification) {
            this.enaSrdSpecification = enaSrdSpecification;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AttachNetworkInterfaceRequest build() {
            return new AttachNetworkInterfaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AttachNetworkInterfaceRequest> {
        public Builder deviceIndex(Integer var1);

        public Builder instanceId(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder networkCardIndex(Integer var1);

        public Builder enaSrdSpecification(EnaSrdSpecification var1);

        default public Builder enaSrdSpecification(Consumer<EnaSrdSpecification.Builder> enaSrdSpecification) {
            return this.enaSrdSpecification((EnaSrdSpecification)((EnaSrdSpecification.Builder)EnaSrdSpecification.builder().applyMutation(enaSrdSpecification)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

