/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.IpamResourceType;
import software.amazon.awssdk.services.ec2.model.RequestIpamResourceTag;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIpamResourceCidrsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, GetIpamResourceCidrsRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(GetIpamResourceCidrsRequest.getter(GetIpamResourceCidrsRequest::filters)).setter(GetIpamResourceCidrsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetIpamResourceCidrsRequest.getter(GetIpamResourceCidrsRequest::maxResults)).setter(GetIpamResourceCidrsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetIpamResourceCidrsRequest.getter(GetIpamResourceCidrsRequest::nextToken)).setter(GetIpamResourceCidrsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final SdkField<String> IPAM_SCOPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamScopeId").getter(GetIpamResourceCidrsRequest.getter(GetIpamResourceCidrsRequest::ipamScopeId)).setter(GetIpamResourceCidrsRequest.setter(Builder::ipamScopeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamScopeId").unmarshallLocationName("IpamScopeId").build()}).build();
    private static final SdkField<String> IPAM_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPoolId").getter(GetIpamResourceCidrsRequest.getter(GetIpamResourceCidrsRequest::ipamPoolId)).setter(GetIpamResourceCidrsRequest.setter(Builder::ipamPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolId").unmarshallLocationName("IpamPoolId").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(GetIpamResourceCidrsRequest.getter(GetIpamResourceCidrsRequest::resourceId)).setter(GetIpamResourceCidrsRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").unmarshallLocationName("ResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(GetIpamResourceCidrsRequest.getter(GetIpamResourceCidrsRequest::resourceTypeAsString)).setter(GetIpamResourceCidrsRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").unmarshallLocationName("ResourceType").build()}).build();
    private static final SdkField<RequestIpamResourceTag> RESOURCE_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceTag").getter(GetIpamResourceCidrsRequest.getter(GetIpamResourceCidrsRequest::resourceTag)).setter(GetIpamResourceCidrsRequest.setter(Builder::resourceTag)).constructor(RequestIpamResourceTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTag").unmarshallLocationName("ResourceTag").build()}).build();
    private static final SdkField<String> RESOURCE_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceOwner").getter(GetIpamResourceCidrsRequest.getter(GetIpamResourceCidrsRequest::resourceOwner)).setter(GetIpamResourceCidrsRequest.setter(Builder::resourceOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwner").unmarshallLocationName("ResourceOwner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, IPAM_SCOPE_ID_FIELD, IPAM_POOL_ID_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_TAG_FIELD, RESOURCE_OWNER_FIELD));
    private final List<Filter> filters;
    private final Integer maxResults;
    private final String nextToken;
    private final String ipamScopeId;
    private final String ipamPoolId;
    private final String resourceId;
    private final String resourceType;
    private final RequestIpamResourceTag resourceTag;
    private final String resourceOwner;

    private GetIpamResourceCidrsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.ipamScopeId = builder.ipamScopeId;
        this.ipamPoolId = builder.ipamPoolId;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.resourceTag = builder.resourceTag;
        this.resourceOwner = builder.resourceOwner;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String ipamScopeId() {
        return this.ipamScopeId;
    }

    public final String ipamPoolId() {
        return this.ipamPoolId;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final IpamResourceType resourceType() {
        return IpamResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final RequestIpamResourceTag resourceTag() {
        return this.resourceTag;
    }

    public final String resourceOwner() {
        return this.resourceOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamScopeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwner());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIpamResourceCidrsRequest)) {
            return false;
        }
        GetIpamResourceCidrsRequest other = (GetIpamResourceCidrsRequest)((Object)obj);
        return this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.ipamScopeId(), other.ipamScopeId()) && Objects.equals(this.ipamPoolId(), other.ipamPoolId()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceTag(), other.resourceTag()) && Objects.equals(this.resourceOwner(), other.resourceOwner());
    }

    public final String toString() {
        return ToString.builder((String)"GetIpamResourceCidrsRequest").add("Filters", this.hasFilters() ? this.filters() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("IpamScopeId", (Object)this.ipamScopeId()).add("IpamPoolId", (Object)this.ipamPoolId()).add("ResourceId", (Object)this.resourceId()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceTag", (Object)this.resourceTag()).add("ResourceOwner", (Object)this.resourceOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "IpamScopeId": {
                return Optional.ofNullable(clazz.cast(this.ipamScopeId()));
            }
            case "IpamPoolId": {
                return Optional.ofNullable(clazz.cast(this.ipamPoolId()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ResourceTag": {
                return Optional.ofNullable(clazz.cast(this.resourceTag()));
            }
            case "ResourceOwner": {
                return Optional.ofNullable(clazz.cast(this.resourceOwner()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIpamResourceCidrsRequest, T> g) {
        return obj -> g.apply((GetIpamResourceCidrsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;
        private String ipamScopeId;
        private String ipamPoolId;
        private String resourceId;
        private String resourceType;
        private RequestIpamResourceTag resourceTag;
        private String resourceOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIpamResourceCidrsRequest model) {
            super(model);
            this.filters(model.filters);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.ipamScopeId(model.ipamScopeId);
            this.ipamPoolId(model.ipamPoolId);
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
            this.resourceTag(model.resourceTag);
            this.resourceOwner(model.resourceOwner);
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getIpamScopeId() {
            return this.ipamScopeId;
        }

        public final void setIpamScopeId(String ipamScopeId) {
            this.ipamScopeId = ipamScopeId;
        }

        @Override
        public final Builder ipamScopeId(String ipamScopeId) {
            this.ipamScopeId = ipamScopeId;
            return this;
        }

        public final String getIpamPoolId() {
            return this.ipamPoolId;
        }

        public final void setIpamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
        }

        @Override
        public final Builder ipamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(IpamResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final RequestIpamResourceTag.Builder getResourceTag() {
            return this.resourceTag != null ? this.resourceTag.toBuilder() : null;
        }

        public final void setResourceTag(RequestIpamResourceTag.BuilderImpl resourceTag) {
            this.resourceTag = resourceTag != null ? resourceTag.build() : null;
        }

        @Override
        public final Builder resourceTag(RequestIpamResourceTag resourceTag) {
            this.resourceTag = resourceTag;
            return this;
        }

        public final String getResourceOwner() {
            return this.resourceOwner;
        }

        public final void setResourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
        }

        @Override
        public final Builder resourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetIpamResourceCidrsRequest build() {
            return new GetIpamResourceCidrsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIpamResourceCidrsRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder ipamScopeId(String var1);

        public Builder ipamPoolId(String var1);

        public Builder resourceId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(IpamResourceType var1);

        public Builder resourceTag(RequestIpamResourceTag var1);

        default public Builder resourceTag(Consumer<RequestIpamResourceTag.Builder> resourceTag) {
            return this.resourceTag((RequestIpamResourceTag)((RequestIpamResourceTag.Builder)RequestIpamResourceTag.builder().applyMutation(resourceTag)).build());
        }

        public Builder resourceOwner(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

