/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.IpamResourceDiscovery;
import software.amazon.awssdk.services.ec2.model.IpamResourceDiscoverySetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIpamResourceDiscoveriesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeIpamResourceDiscoveriesResponse> {
    private static final SdkField<List<IpamResourceDiscovery>> IPAM_RESOURCE_DISCOVERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpamResourceDiscoveries").getter(DescribeIpamResourceDiscoveriesResponse.getter(DescribeIpamResourceDiscoveriesResponse::ipamResourceDiscoveries)).setter(DescribeIpamResourceDiscoveriesResponse.setter(Builder::ipamResourceDiscoveries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamResourceDiscoverySet").unmarshallLocationName("ipamResourceDiscoverySet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamResourceDiscovery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeIpamResourceDiscoveriesResponse.getter(DescribeIpamResourceDiscoveriesResponse::nextToken)).setter(DescribeIpamResourceDiscoveriesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_RESOURCE_DISCOVERIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<IpamResourceDiscovery> ipamResourceDiscoveries;
    private final String nextToken;

    private DescribeIpamResourceDiscoveriesResponse(BuilderImpl builder) {
        super(builder);
        this.ipamResourceDiscoveries = builder.ipamResourceDiscoveries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIpamResourceDiscoveries() {
        return this.ipamResourceDiscoveries != null && !(this.ipamResourceDiscoveries instanceof SdkAutoConstructList);
    }

    public final List<IpamResourceDiscovery> ipamResourceDiscoveries() {
        return this.ipamResourceDiscoveries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpamResourceDiscoveries() ? this.ipamResourceDiscoveries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIpamResourceDiscoveriesResponse)) {
            return false;
        }
        DescribeIpamResourceDiscoveriesResponse other = (DescribeIpamResourceDiscoveriesResponse)((Object)obj);
        return this.hasIpamResourceDiscoveries() == other.hasIpamResourceDiscoveries() && Objects.equals(this.ipamResourceDiscoveries(), other.ipamResourceDiscoveries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeIpamResourceDiscoveriesResponse").add("IpamResourceDiscoveries", this.hasIpamResourceDiscoveries() ? this.ipamResourceDiscoveries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpamResourceDiscoveries": {
                return Optional.ofNullable(clazz.cast(this.ipamResourceDiscoveries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIpamResourceDiscoveriesResponse, T> g) {
        return obj -> g.apply((DescribeIpamResourceDiscoveriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<IpamResourceDiscovery> ipamResourceDiscoveries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIpamResourceDiscoveriesResponse model) {
            super(model);
            this.ipamResourceDiscoveries(model.ipamResourceDiscoveries);
            this.nextToken(model.nextToken);
        }

        public final List<IpamResourceDiscovery.Builder> getIpamResourceDiscoveries() {
            List<IpamResourceDiscovery.Builder> result = IpamResourceDiscoverySetCopier.copyToBuilder(this.ipamResourceDiscoveries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpamResourceDiscoveries(Collection<IpamResourceDiscovery.BuilderImpl> ipamResourceDiscoveries) {
            this.ipamResourceDiscoveries = IpamResourceDiscoverySetCopier.copyFromBuilder(ipamResourceDiscoveries);
        }

        @Override
        public final Builder ipamResourceDiscoveries(Collection<IpamResourceDiscovery> ipamResourceDiscoveries) {
            this.ipamResourceDiscoveries = IpamResourceDiscoverySetCopier.copy(ipamResourceDiscoveries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamResourceDiscoveries(IpamResourceDiscovery ... ipamResourceDiscoveries) {
            this.ipamResourceDiscoveries(Arrays.asList(ipamResourceDiscoveries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamResourceDiscoveries(Consumer<IpamResourceDiscovery.Builder> ... ipamResourceDiscoveries) {
            this.ipamResourceDiscoveries(Stream.of(ipamResourceDiscoveries).map(c -> (IpamResourceDiscovery)((IpamResourceDiscovery.Builder)IpamResourceDiscovery.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeIpamResourceDiscoveriesResponse build() {
            return new DescribeIpamResourceDiscoveriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeIpamResourceDiscoveriesResponse> {
        public Builder ipamResourceDiscoveries(Collection<IpamResourceDiscovery> var1);

        public Builder ipamResourceDiscoveries(IpamResourceDiscovery ... var1);

        public Builder ipamResourceDiscoveries(Consumer<IpamResourceDiscovery.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

