/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesOffering;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesOfferingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReservedInstancesOfferingsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeReservedInstancesOfferingsResponse> {
    private static final SdkField<List<ReservedInstancesOffering>> RESERVED_INSTANCES_OFFERINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeReservedInstancesOfferingsResponse.getter(DescribeReservedInstancesOfferingsResponse::reservedInstancesOfferings)).setter(DescribeReservedInstancesOfferingsResponse.setter(Builder::reservedInstancesOfferings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesOfferingsSet").unmarshallLocationName("reservedInstancesOfferingsSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservedInstancesOffering::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReservedInstancesOfferingsResponse.getter(DescribeReservedInstancesOfferingsResponse::nextToken)).setter(DescribeReservedInstancesOfferingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_INSTANCES_OFFERINGS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ReservedInstancesOffering> reservedInstancesOfferings;
    private final String nextToken;

    private DescribeReservedInstancesOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.reservedInstancesOfferings = builder.reservedInstancesOfferings;
        this.nextToken = builder.nextToken;
    }

    public List<ReservedInstancesOffering> reservedInstancesOfferings() {
        return this.reservedInstancesOfferings;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesOfferings());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesOfferingsResponse)) {
            return false;
        }
        DescribeReservedInstancesOfferingsResponse other = (DescribeReservedInstancesOfferingsResponse)((Object)obj);
        return Objects.equals(this.reservedInstancesOfferings(), other.reservedInstancesOfferings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReservedInstancesOfferingsResponse").add("ReservedInstancesOfferings", this.reservedInstancesOfferings()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedInstancesOfferings": {
                return Optional.ofNullable(clazz.cast(this.reservedInstancesOfferings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedInstancesOfferingsResponse, T> g) {
        return obj -> g.apply((DescribeReservedInstancesOfferingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<ReservedInstancesOffering> reservedInstancesOfferings = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesOfferingsResponse model) {
            super(model);
            this.reservedInstancesOfferings(model.reservedInstancesOfferings);
            this.nextToken(model.nextToken);
        }

        public final Collection<ReservedInstancesOffering.Builder> getReservedInstancesOfferings() {
            return this.reservedInstancesOfferings != null ? (Collection)this.reservedInstancesOfferings.stream().map(ReservedInstancesOffering::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedInstancesOfferings(Collection<ReservedInstancesOffering> reservedInstancesOfferings) {
            this.reservedInstancesOfferings = ReservedInstancesOfferingListCopier.copy(reservedInstancesOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesOfferings(ReservedInstancesOffering ... reservedInstancesOfferings) {
            this.reservedInstancesOfferings(Arrays.asList(reservedInstancesOfferings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesOfferings(Consumer<ReservedInstancesOffering.Builder> ... reservedInstancesOfferings) {
            this.reservedInstancesOfferings(Stream.of(reservedInstancesOfferings).map(c -> (ReservedInstancesOffering)((ReservedInstancesOffering.Builder)ReservedInstancesOffering.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReservedInstancesOfferings(Collection<ReservedInstancesOffering.BuilderImpl> reservedInstancesOfferings) {
            this.reservedInstancesOfferings = ReservedInstancesOfferingListCopier.copyFromBuilder(reservedInstancesOfferings);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeReservedInstancesOfferingsResponse build() {
            return new DescribeReservedInstancesOfferingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReservedInstancesOfferingsResponse> {
        public Builder reservedInstancesOfferings(Collection<ReservedInstancesOffering> var1);

        public Builder reservedInstancesOfferings(ReservedInstancesOffering ... var1);

        public Builder reservedInstancesOfferings(Consumer<ReservedInstancesOffering.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

