/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainAssociation;
import software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainAssociationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTransitGatewayMulticastDomainAssociationsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetTransitGatewayMulticastDomainAssociationsResponse> {
    private static final SdkField<List<TransitGatewayMulticastDomainAssociation>> MULTICAST_DOMAIN_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MulticastDomainAssociations").getter(GetTransitGatewayMulticastDomainAssociationsResponse.getter(GetTransitGatewayMulticastDomainAssociationsResponse::multicastDomainAssociations)).setter(GetTransitGatewayMulticastDomainAssociationsResponse.setter(Builder::multicastDomainAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MulticastDomainAssociations").unmarshallLocationName("multicastDomainAssociations").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransitGatewayMulticastDomainAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetTransitGatewayMulticastDomainAssociationsResponse.getter(GetTransitGatewayMulticastDomainAssociationsResponse::nextToken)).setter(GetTransitGatewayMulticastDomainAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTICAST_DOMAIN_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<TransitGatewayMulticastDomainAssociation> multicastDomainAssociations;
    private final String nextToken;

    private GetTransitGatewayMulticastDomainAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.multicastDomainAssociations = builder.multicastDomainAssociations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMulticastDomainAssociations() {
        return this.multicastDomainAssociations != null && !(this.multicastDomainAssociations instanceof SdkAutoConstructList);
    }

    public final List<TransitGatewayMulticastDomainAssociation> multicastDomainAssociations() {
        return this.multicastDomainAssociations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMulticastDomainAssociations() ? this.multicastDomainAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTransitGatewayMulticastDomainAssociationsResponse)) {
            return false;
        }
        GetTransitGatewayMulticastDomainAssociationsResponse other = (GetTransitGatewayMulticastDomainAssociationsResponse)((Object)obj);
        return this.hasMulticastDomainAssociations() == other.hasMulticastDomainAssociations() && Objects.equals(this.multicastDomainAssociations(), other.multicastDomainAssociations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetTransitGatewayMulticastDomainAssociationsResponse").add("MulticastDomainAssociations", this.hasMulticastDomainAssociations() ? this.multicastDomainAssociations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MulticastDomainAssociations": {
                return Optional.ofNullable(clazz.cast(this.multicastDomainAssociations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTransitGatewayMulticastDomainAssociationsResponse, T> g) {
        return obj -> g.apply((GetTransitGatewayMulticastDomainAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<TransitGatewayMulticastDomainAssociation> multicastDomainAssociations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTransitGatewayMulticastDomainAssociationsResponse model) {
            super(model);
            this.multicastDomainAssociations(model.multicastDomainAssociations);
            this.nextToken(model.nextToken);
        }

        public final List<TransitGatewayMulticastDomainAssociation.Builder> getMulticastDomainAssociations() {
            List<TransitGatewayMulticastDomainAssociation.Builder> result = TransitGatewayMulticastDomainAssociationListCopier.copyToBuilder(this.multicastDomainAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMulticastDomainAssociations(Collection<TransitGatewayMulticastDomainAssociation.BuilderImpl> multicastDomainAssociations) {
            this.multicastDomainAssociations = TransitGatewayMulticastDomainAssociationListCopier.copyFromBuilder(multicastDomainAssociations);
        }

        @Override
        @Transient
        public final Builder multicastDomainAssociations(Collection<TransitGatewayMulticastDomainAssociation> multicastDomainAssociations) {
            this.multicastDomainAssociations = TransitGatewayMulticastDomainAssociationListCopier.copy(multicastDomainAssociations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder multicastDomainAssociations(TransitGatewayMulticastDomainAssociation ... multicastDomainAssociations) {
            this.multicastDomainAssociations(Arrays.asList(multicastDomainAssociations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder multicastDomainAssociations(Consumer<TransitGatewayMulticastDomainAssociation.Builder> ... multicastDomainAssociations) {
            this.multicastDomainAssociations(Stream.of(multicastDomainAssociations).map(c -> (TransitGatewayMulticastDomainAssociation)((TransitGatewayMulticastDomainAssociation.Builder)TransitGatewayMulticastDomainAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetTransitGatewayMulticastDomainAssociationsResponse build() {
            return new GetTransitGatewayMulticastDomainAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTransitGatewayMulticastDomainAssociationsResponse> {
        public Builder multicastDomainAssociations(Collection<TransitGatewayMulticastDomainAssociation> var1);

        public Builder multicastDomainAssociations(TransitGatewayMulticastDomainAssociation ... var1);

        public Builder multicastDomainAssociations(Consumer<TransitGatewayMulticastDomainAssociation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

