/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksResponse;
import software.amazon.awssdk.services.ec2.model.TargetNetwork;

public class DescribeClientVpnTargetNetworksIterable
implements SdkIterable<DescribeClientVpnTargetNetworksResponse> {
    private final Ec2Client client;
    private final DescribeClientVpnTargetNetworksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeClientVpnTargetNetworksIterable(Ec2Client client, DescribeClientVpnTargetNetworksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeClientVpnTargetNetworksResponseFetcher();
    }

    public Iterator<DescribeClientVpnTargetNetworksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TargetNetwork> clientVpnTargetNetworks() {
        Function<DescribeClientVpnTargetNetworksResponse, Iterator> getIterator = response -> {
            if (response != null && response.clientVpnTargetNetworks() != null) {
                return response.clientVpnTargetNetworks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeClientVpnTargetNetworksResponseFetcher
    implements SyncPageFetcher<DescribeClientVpnTargetNetworksResponse> {
        private DescribeClientVpnTargetNetworksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClientVpnTargetNetworksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeClientVpnTargetNetworksResponse nextPage(DescribeClientVpnTargetNetworksResponse previousPage) {
            if (previousPage == null) {
                return DescribeClientVpnTargetNetworksIterable.this.client.describeClientVpnTargetNetworks(DescribeClientVpnTargetNetworksIterable.this.firstRequest);
            }
            return DescribeClientVpnTargetNetworksIterable.this.client.describeClientVpnTargetNetworks((DescribeClientVpnTargetNetworksRequest)((Object)DescribeClientVpnTargetNetworksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

