/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorTargetType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrafficMirrorTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrafficMirrorTarget> {
    private static final SdkField<String> TRAFFIC_MIRROR_TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficMirrorTargetId").getter(TrafficMirrorTarget.getter(TrafficMirrorTarget::trafficMirrorTargetId)).setter(TrafficMirrorTarget.setter(Builder::trafficMirrorTargetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorTargetId").unmarshallLocationName("trafficMirrorTargetId").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(TrafficMirrorTarget.getter(TrafficMirrorTarget::networkInterfaceId)).setter(TrafficMirrorTarget.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<String> NETWORK_LOAD_BALANCER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkLoadBalancerArn").getter(TrafficMirrorTarget.getter(TrafficMirrorTarget::networkLoadBalancerArn)).setter(TrafficMirrorTarget.setter(Builder::networkLoadBalancerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkLoadBalancerArn").unmarshallLocationName("networkLoadBalancerArn").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(TrafficMirrorTarget.getter(TrafficMirrorTarget::typeAsString)).setter(TrafficMirrorTarget.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("type").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(TrafficMirrorTarget.getter(TrafficMirrorTarget::description)).setter(TrafficMirrorTarget.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(TrafficMirrorTarget.getter(TrafficMirrorTarget::ownerId)).setter(TrafficMirrorTarget.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(TrafficMirrorTarget.getter(TrafficMirrorTarget::tags)).setter(TrafficMirrorTarget.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_MIRROR_TARGET_ID_FIELD, NETWORK_INTERFACE_ID_FIELD, NETWORK_LOAD_BALANCER_ARN_FIELD, TYPE_FIELD, DESCRIPTION_FIELD, OWNER_ID_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String trafficMirrorTargetId;
    private final String networkInterfaceId;
    private final String networkLoadBalancerArn;
    private final String type;
    private final String description;
    private final String ownerId;
    private final List<Tag> tags;

    private TrafficMirrorTarget(BuilderImpl builder) {
        this.trafficMirrorTargetId = builder.trafficMirrorTargetId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.networkLoadBalancerArn = builder.networkLoadBalancerArn;
        this.type = builder.type;
        this.description = builder.description;
        this.ownerId = builder.ownerId;
        this.tags = builder.tags;
    }

    public final String trafficMirrorTargetId() {
        return this.trafficMirrorTargetId;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final String networkLoadBalancerArn() {
        return this.networkLoadBalancerArn;
    }

    public final TrafficMirrorTargetType type() {
        return TrafficMirrorTargetType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String description() {
        return this.description;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficMirrorTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkLoadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficMirrorTarget)) {
            return false;
        }
        TrafficMirrorTarget other = (TrafficMirrorTarget)obj;
        return Objects.equals(this.trafficMirrorTargetId(), other.trafficMirrorTargetId()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.networkLoadBalancerArn(), other.networkLoadBalancerArn()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.ownerId(), other.ownerId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"TrafficMirrorTarget").add("TrafficMirrorTargetId", (Object)this.trafficMirrorTargetId()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("NetworkLoadBalancerArn", (Object)this.networkLoadBalancerArn()).add("Type", (Object)this.typeAsString()).add("Description", (Object)this.description()).add("OwnerId", (Object)this.ownerId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficMirrorTargetId": {
                return Optional.ofNullable(clazz.cast(this.trafficMirrorTargetId()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "NetworkLoadBalancerArn": {
                return Optional.ofNullable(clazz.cast(this.networkLoadBalancerArn()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrafficMirrorTarget, T> g) {
        return obj -> g.apply((TrafficMirrorTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trafficMirrorTargetId;
        private String networkInterfaceId;
        private String networkLoadBalancerArn;
        private String type;
        private String description;
        private String ownerId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficMirrorTarget model) {
            this.trafficMirrorTargetId(model.trafficMirrorTargetId);
            this.networkInterfaceId(model.networkInterfaceId);
            this.networkLoadBalancerArn(model.networkLoadBalancerArn);
            this.type(model.type);
            this.description(model.description);
            this.ownerId(model.ownerId);
            this.tags(model.tags);
        }

        public final String getTrafficMirrorTargetId() {
            return this.trafficMirrorTargetId;
        }

        public final void setTrafficMirrorTargetId(String trafficMirrorTargetId) {
            this.trafficMirrorTargetId = trafficMirrorTargetId;
        }

        @Override
        @Transient
        public final Builder trafficMirrorTargetId(String trafficMirrorTargetId) {
            this.trafficMirrorTargetId = trafficMirrorTargetId;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        @Transient
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getNetworkLoadBalancerArn() {
            return this.networkLoadBalancerArn;
        }

        public final void setNetworkLoadBalancerArn(String networkLoadBalancerArn) {
            this.networkLoadBalancerArn = networkLoadBalancerArn;
        }

        @Override
        @Transient
        public final Builder networkLoadBalancerArn(String networkLoadBalancerArn) {
            this.networkLoadBalancerArn = networkLoadBalancerArn;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(TrafficMirrorTargetType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        @Transient
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TrafficMirrorTarget build() {
            return new TrafficMirrorTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrafficMirrorTarget> {
        public Builder trafficMirrorTargetId(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder networkLoadBalancerArn(String var1);

        public Builder type(String var1);

        public Builder type(TrafficMirrorTargetType var1);

        public Builder description(String var1);

        public Builder ownerId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

