/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CapacityReservationState;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.InstanceUsage;
import software.amazon.awssdk.services.ec2.model.InstanceUsageSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCapacityReservationUsageResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetCapacityReservationUsageResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetCapacityReservationUsageResponse.getter(GetCapacityReservationUsageResponse::nextToken)).setter(GetCapacityReservationUsageResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<String> CAPACITY_RESERVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityReservationId").getter(GetCapacityReservationUsageResponse.getter(GetCapacityReservationUsageResponse::capacityReservationId)).setter(GetCapacityReservationUsageResponse.setter(Builder::capacityReservationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationId").unmarshallLocationName("capacityReservationId").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(GetCapacityReservationUsageResponse.getter(GetCapacityReservationUsageResponse::instanceType)).setter(GetCapacityReservationUsageResponse.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<Integer> TOTAL_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalInstanceCount").getter(GetCapacityReservationUsageResponse.getter(GetCapacityReservationUsageResponse::totalInstanceCount)).setter(GetCapacityReservationUsageResponse.setter(Builder::totalInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalInstanceCount").unmarshallLocationName("totalInstanceCount").build()}).build();
    private static final SdkField<Integer> AVAILABLE_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AvailableInstanceCount").getter(GetCapacityReservationUsageResponse.getter(GetCapacityReservationUsageResponse::availableInstanceCount)).setter(GetCapacityReservationUsageResponse.setter(Builder::availableInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableInstanceCount").unmarshallLocationName("availableInstanceCount").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(GetCapacityReservationUsageResponse.getter(GetCapacityReservationUsageResponse::stateAsString)).setter(GetCapacityReservationUsageResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<List<InstanceUsage>> INSTANCE_USAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceUsages").getter(GetCapacityReservationUsageResponse.getter(GetCapacityReservationUsageResponse::instanceUsages)).setter(GetCapacityReservationUsageResponse.setter(Builder::instanceUsages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceUsageSet").unmarshallLocationName("instanceUsageSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceUsage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CAPACITY_RESERVATION_ID_FIELD, INSTANCE_TYPE_FIELD, TOTAL_INSTANCE_COUNT_FIELD, AVAILABLE_INSTANCE_COUNT_FIELD, STATE_FIELD, INSTANCE_USAGES_FIELD));
    private final String nextToken;
    private final String capacityReservationId;
    private final String instanceType;
    private final Integer totalInstanceCount;
    private final Integer availableInstanceCount;
    private final String state;
    private final List<InstanceUsage> instanceUsages;

    private GetCapacityReservationUsageResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.capacityReservationId = builder.capacityReservationId;
        this.instanceType = builder.instanceType;
        this.totalInstanceCount = builder.totalInstanceCount;
        this.availableInstanceCount = builder.availableInstanceCount;
        this.state = builder.state;
        this.instanceUsages = builder.instanceUsages;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String capacityReservationId() {
        return this.capacityReservationId;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final Integer totalInstanceCount() {
        return this.totalInstanceCount;
    }

    public final Integer availableInstanceCount() {
        return this.availableInstanceCount;
    }

    public final CapacityReservationState state() {
        return CapacityReservationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasInstanceUsages() {
        return this.instanceUsages != null && !(this.instanceUsages instanceof SdkAutoConstructList);
    }

    public final List<InstanceUsage> instanceUsages() {
        return this.instanceUsages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceUsages() ? this.instanceUsages() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCapacityReservationUsageResponse)) {
            return false;
        }
        GetCapacityReservationUsageResponse other = (GetCapacityReservationUsageResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.capacityReservationId(), other.capacityReservationId()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.totalInstanceCount(), other.totalInstanceCount()) && Objects.equals(this.availableInstanceCount(), other.availableInstanceCount()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasInstanceUsages() == other.hasInstanceUsages() && Objects.equals(this.instanceUsages(), other.instanceUsages());
    }

    public final String toString() {
        return ToString.builder((String)"GetCapacityReservationUsageResponse").add("NextToken", (Object)this.nextToken()).add("CapacityReservationId", (Object)this.capacityReservationId()).add("InstanceType", (Object)this.instanceType()).add("TotalInstanceCount", (Object)this.totalInstanceCount()).add("AvailableInstanceCount", (Object)this.availableInstanceCount()).add("State", (Object)this.stateAsString()).add("InstanceUsages", this.hasInstanceUsages() ? this.instanceUsages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "CapacityReservationId": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationId()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "TotalInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.totalInstanceCount()));
            }
            case "AvailableInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.availableInstanceCount()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "InstanceUsages": {
                return Optional.ofNullable(clazz.cast(this.instanceUsages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCapacityReservationUsageResponse, T> g) {
        return obj -> g.apply((GetCapacityReservationUsageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private String capacityReservationId;
        private String instanceType;
        private Integer totalInstanceCount;
        private Integer availableInstanceCount;
        private String state;
        private List<InstanceUsage> instanceUsages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCapacityReservationUsageResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.capacityReservationId(model.capacityReservationId);
            this.instanceType(model.instanceType);
            this.totalInstanceCount(model.totalInstanceCount);
            this.availableInstanceCount(model.availableInstanceCount);
            this.state(model.state);
            this.instanceUsages(model.instanceUsages);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getCapacityReservationId() {
            return this.capacityReservationId;
        }

        @Override
        public final Builder capacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
            return this;
        }

        public final void setCapacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getTotalInstanceCount() {
            return this.totalInstanceCount;
        }

        @Override
        public final Builder totalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
            return this;
        }

        public final void setTotalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
        }

        public final Integer getAvailableInstanceCount() {
            return this.availableInstanceCount;
        }

        @Override
        public final Builder availableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
            return this;
        }

        public final void setAvailableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CapacityReservationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final List<InstanceUsage.Builder> getInstanceUsages() {
            List<InstanceUsage.Builder> result = InstanceUsageSetCopier.copyToBuilder(this.instanceUsages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder instanceUsages(Collection<InstanceUsage> instanceUsages) {
            this.instanceUsages = InstanceUsageSetCopier.copy(instanceUsages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceUsages(InstanceUsage ... instanceUsages) {
            this.instanceUsages(Arrays.asList(instanceUsages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceUsages(Consumer<InstanceUsage.Builder> ... instanceUsages) {
            this.instanceUsages(Stream.of(instanceUsages).map(c -> (InstanceUsage)((InstanceUsage.Builder)InstanceUsage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceUsages(Collection<InstanceUsage.BuilderImpl> instanceUsages) {
            this.instanceUsages = InstanceUsageSetCopier.copyFromBuilder(instanceUsages);
        }

        @Override
        public GetCapacityReservationUsageResponse build() {
            return new GetCapacityReservationUsageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCapacityReservationUsageResponse> {
        public Builder nextToken(String var1);

        public Builder capacityReservationId(String var1);

        public Builder instanceType(String var1);

        public Builder totalInstanceCount(Integer var1);

        public Builder availableInstanceCount(Integer var1);

        public Builder state(String var1);

        public Builder state(CapacityReservationState var1);

        public Builder instanceUsages(Collection<InstanceUsage> var1);

        public Builder instanceUsages(InstanceUsage ... var1);

        public Builder instanceUsages(Consumer<InstanceUsage.Builder> ... var1);
    }
}

