/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.AttributeBooleanValue;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyVpcAttributeRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyVpcAttributeRequest> {
    private static final SdkField<AttributeBooleanValue> ENABLE_DNS_HOSTNAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnableDnsHostnames").getter(ModifyVpcAttributeRequest.getter(ModifyVpcAttributeRequest::enableDnsHostnames)).setter(ModifyVpcAttributeRequest.setter(Builder::enableDnsHostnames)).constructor(AttributeBooleanValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDnsHostnames").unmarshallLocationName("EnableDnsHostnames").build()}).build();
    private static final SdkField<AttributeBooleanValue> ENABLE_DNS_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnableDnsSupport").getter(ModifyVpcAttributeRequest.getter(ModifyVpcAttributeRequest::enableDnsSupport)).setter(ModifyVpcAttributeRequest.setter(Builder::enableDnsSupport)).constructor(AttributeBooleanValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDnsSupport").unmarshallLocationName("EnableDnsSupport").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(ModifyVpcAttributeRequest.getter(ModifyVpcAttributeRequest::vpcId)).setter(ModifyVpcAttributeRequest.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("vpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_DNS_HOSTNAMES_FIELD, ENABLE_DNS_SUPPORT_FIELD, VPC_ID_FIELD));
    private final AttributeBooleanValue enableDnsHostnames;
    private final AttributeBooleanValue enableDnsSupport;
    private final String vpcId;

    private ModifyVpcAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.enableDnsHostnames = builder.enableDnsHostnames;
        this.enableDnsSupport = builder.enableDnsSupport;
        this.vpcId = builder.vpcId;
    }

    public final AttributeBooleanValue enableDnsHostnames() {
        return this.enableDnsHostnames;
    }

    public final AttributeBooleanValue enableDnsSupport() {
        return this.enableDnsSupport;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.enableDnsHostnames());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableDnsSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcAttributeRequest)) {
            return false;
        }
        ModifyVpcAttributeRequest other = (ModifyVpcAttributeRequest)((Object)obj);
        return Objects.equals(this.enableDnsHostnames(), other.enableDnsHostnames()) && Objects.equals(this.enableDnsSupport(), other.enableDnsSupport()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyVpcAttributeRequest").add("EnableDnsHostnames", (Object)this.enableDnsHostnames()).add("EnableDnsSupport", (Object)this.enableDnsSupport()).add("VpcId", (Object)this.vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnableDnsHostnames": {
                return Optional.ofNullable(clazz.cast(this.enableDnsHostnames()));
            }
            case "EnableDnsSupport": {
                return Optional.ofNullable(clazz.cast(this.enableDnsSupport()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpcAttributeRequest, T> g) {
        return obj -> g.apply((ModifyVpcAttributeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private AttributeBooleanValue enableDnsHostnames;
        private AttributeBooleanValue enableDnsSupport;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcAttributeRequest model) {
            super(model);
            this.enableDnsHostnames(model.enableDnsHostnames);
            this.enableDnsSupport(model.enableDnsSupport);
            this.vpcId(model.vpcId);
        }

        public final AttributeBooleanValue.Builder getEnableDnsHostnames() {
            return this.enableDnsHostnames != null ? this.enableDnsHostnames.toBuilder() : null;
        }

        public final void setEnableDnsHostnames(AttributeBooleanValue.BuilderImpl enableDnsHostnames) {
            this.enableDnsHostnames = enableDnsHostnames != null ? enableDnsHostnames.build() : null;
        }

        @Override
        public final Builder enableDnsHostnames(AttributeBooleanValue enableDnsHostnames) {
            this.enableDnsHostnames = enableDnsHostnames;
            return this;
        }

        public final AttributeBooleanValue.Builder getEnableDnsSupport() {
            return this.enableDnsSupport != null ? this.enableDnsSupport.toBuilder() : null;
        }

        public final void setEnableDnsSupport(AttributeBooleanValue.BuilderImpl enableDnsSupport) {
            this.enableDnsSupport = enableDnsSupport != null ? enableDnsSupport.build() : null;
        }

        @Override
        public final Builder enableDnsSupport(AttributeBooleanValue enableDnsSupport) {
            this.enableDnsSupport = enableDnsSupport;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcAttributeRequest build() {
            return new ModifyVpcAttributeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyVpcAttributeRequest> {
        public Builder enableDnsHostnames(AttributeBooleanValue var1);

        default public Builder enableDnsHostnames(Consumer<AttributeBooleanValue.Builder> enableDnsHostnames) {
            return this.enableDnsHostnames((AttributeBooleanValue)((AttributeBooleanValue.Builder)AttributeBooleanValue.builder().applyMutation(enableDnsHostnames)).build());
        }

        public Builder enableDnsSupport(AttributeBooleanValue var1);

        default public Builder enableDnsSupport(Consumer<AttributeBooleanValue.Builder> enableDnsSupport) {
            return this.enableDnsSupport((AttributeBooleanValue)((AttributeBooleanValue.Builder)AttributeBooleanValue.builder().applyMutation(enableDnsSupport)).build());
        }

        public Builder vpcId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

