/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesResponse;
import software.amazon.awssdk.services.ec2.model.InstanceTypeInfo;

public class DescribeInstanceTypesIterable
implements SdkIterable<DescribeInstanceTypesResponse> {
    private final Ec2Client client;
    private final DescribeInstanceTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeInstanceTypesIterable(Ec2Client client, DescribeInstanceTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeInstanceTypesResponseFetcher();
    }

    public Iterator<DescribeInstanceTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InstanceTypeInfo> instanceTypes() {
        Function<DescribeInstanceTypesResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceTypes() != null) {
                return response.instanceTypes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeInstanceTypesResponseFetcher
    implements SyncPageFetcher<DescribeInstanceTypesResponse> {
        private DescribeInstanceTypesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeInstanceTypesResponse nextPage(DescribeInstanceTypesResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceTypesIterable.this.client.describeInstanceTypes(DescribeInstanceTypesIterable.this.firstRequest);
            }
            return DescribeInstanceTypesIterable.this.client.describeInstanceTypes((DescribeInstanceTypesRequest)((Object)DescribeInstanceTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

