/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.KeyNameStringListCopier;
import software.amazon.awssdk.services.ec2.model.KeyPairIdStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeKeyPairsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeKeyPairsRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeKeyPairsRequest.getter(DescribeKeyPairsRequest::filters)).setter(DescribeKeyPairsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<List<String>> KEY_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KeyNames").getter(DescribeKeyPairsRequest.getter(DescribeKeyPairsRequest::keyNames)).setter(DescribeKeyPairsRequest.setter(Builder::keyNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").unmarshallLocationName("KeyName").build(), ListTrait.builder().memberLocationName("KeyName").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").unmarshallLocationName("KeyName").build()}).build()).build()}).build();
    private static final SdkField<List<String>> KEY_PAIR_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KeyPairIds").getter(DescribeKeyPairsRequest.getter(DescribeKeyPairsRequest::keyPairIds)).setter(DescribeKeyPairsRequest.setter(Builder::keyPairIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPairId").unmarshallLocationName("KeyPairId").build(), ListTrait.builder().memberLocationName("KeyPairId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPairId").unmarshallLocationName("KeyPairId").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, KEY_NAMES_FIELD, KEY_PAIR_IDS_FIELD));
    private final List<Filter> filters;
    private final List<String> keyNames;
    private final List<String> keyPairIds;

    private DescribeKeyPairsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.keyNames = builder.keyNames;
        this.keyPairIds = builder.keyPairIds;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    public final boolean hasKeyNames() {
        return this.keyNames != null && !(this.keyNames instanceof SdkAutoConstructList);
    }

    public final List<String> keyNames() {
        return this.keyNames;
    }

    public final boolean hasKeyPairIds() {
        return this.keyPairIds != null && !(this.keyPairIds instanceof SdkAutoConstructList);
    }

    public final List<String> keyPairIds() {
        return this.keyPairIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeyNames() ? this.keyNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeyPairIds() ? this.keyPairIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeKeyPairsRequest)) {
            return false;
        }
        DescribeKeyPairsRequest other = (DescribeKeyPairsRequest)((Object)obj);
        return this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && this.hasKeyNames() == other.hasKeyNames() && Objects.equals(this.keyNames(), other.keyNames()) && this.hasKeyPairIds() == other.hasKeyPairIds() && Objects.equals(this.keyPairIds(), other.keyPairIds());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeKeyPairsRequest").add("Filters", this.hasFilters() ? this.filters() : null).add("KeyNames", this.hasKeyNames() ? this.keyNames() : null).add("KeyPairIds", this.hasKeyPairIds() ? this.keyPairIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "KeyNames": {
                return Optional.ofNullable(clazz.cast(this.keyNames()));
            }
            case "KeyPairIds": {
                return Optional.ofNullable(clazz.cast(this.keyPairIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeKeyPairsRequest, T> g) {
        return obj -> g.apply((DescribeKeyPairsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private List<String> keyNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> keyPairIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeKeyPairsRequest model) {
            super(model);
            this.filters(model.filters);
            this.keyNames(model.keyNames);
            this.keyPairIds(model.keyPairIds);
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        @Transient
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getKeyNames() {
            if (this.keyNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.keyNames;
        }

        public final void setKeyNames(Collection<String> keyNames) {
            this.keyNames = KeyNameStringListCopier.copy(keyNames);
        }

        @Override
        @Transient
        public final Builder keyNames(Collection<String> keyNames) {
            this.keyNames = KeyNameStringListCopier.copy(keyNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder keyNames(String ... keyNames) {
            this.keyNames(Arrays.asList(keyNames));
            return this;
        }

        public final Collection<String> getKeyPairIds() {
            if (this.keyPairIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.keyPairIds;
        }

        public final void setKeyPairIds(Collection<String> keyPairIds) {
            this.keyPairIds = KeyPairIdStringListCopier.copy(keyPairIds);
        }

        @Override
        @Transient
        public final Builder keyPairIds(Collection<String> keyPairIds) {
            this.keyPairIds = KeyPairIdStringListCopier.copy(keyPairIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder keyPairIds(String ... keyPairIds) {
            this.keyPairIds(Arrays.asList(keyPairIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeKeyPairsRequest build() {
            return new DescribeKeyPairsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeKeyPairsRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder keyNames(Collection<String> var1);

        public Builder keyNames(String ... var1);

        public Builder keyPairIds(Collection<String> var1);

        public Builder keyPairIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

