/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.AuthorizationRule;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnAuthorizationRulesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnAuthorizationRulesResponse;

public class DescribeClientVpnAuthorizationRulesPublisher
implements SdkPublisher<DescribeClientVpnAuthorizationRulesResponse> {
    private final Ec2AsyncClient client;
    private final DescribeClientVpnAuthorizationRulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeClientVpnAuthorizationRulesPublisher(Ec2AsyncClient client, DescribeClientVpnAuthorizationRulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeClientVpnAuthorizationRulesPublisher(Ec2AsyncClient client, DescribeClientVpnAuthorizationRulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeClientVpnAuthorizationRulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeClientVpnAuthorizationRulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AuthorizationRule> authorizationRules() {
        Function<DescribeClientVpnAuthorizationRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.authorizationRules() != null) {
                return response.authorizationRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeClientVpnAuthorizationRulesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeClientVpnAuthorizationRulesResponseFetcher
    implements AsyncPageFetcher<DescribeClientVpnAuthorizationRulesResponse> {
        private DescribeClientVpnAuthorizationRulesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClientVpnAuthorizationRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeClientVpnAuthorizationRulesResponse> nextPage(DescribeClientVpnAuthorizationRulesResponse previousPage) {
            if (previousPage == null) {
                return DescribeClientVpnAuthorizationRulesPublisher.this.client.describeClientVpnAuthorizationRules(DescribeClientVpnAuthorizationRulesPublisher.this.firstRequest);
            }
            return DescribeClientVpnAuthorizationRulesPublisher.this.client.describeClientVpnAuthorizationRules((DescribeClientVpnAuthorizationRulesRequest)((Object)DescribeClientVpnAuthorizationRulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

