/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ElasticGpuSetCopier;
import software.amazon.awssdk.services.ec2.model.ElasticGpus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeElasticGpusResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeElasticGpusResponse> {
    private static final SdkField<List<ElasticGpus>> ELASTIC_GPU_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ElasticGpuSet").getter(DescribeElasticGpusResponse.getter(DescribeElasticGpusResponse::elasticGpuSet)).setter(DescribeElasticGpusResponse.setter(Builder::elasticGpuSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuSet").unmarshallLocationName("elasticGpuSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ElasticGpus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeElasticGpusResponse.getter(DescribeElasticGpusResponse::maxResults)).setter(DescribeElasticGpusResponse.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeElasticGpusResponse.getter(DescribeElasticGpusResponse::nextToken)).setter(DescribeElasticGpusResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELASTIC_GPU_SET_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ElasticGpus> elasticGpuSet;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeElasticGpusResponse(BuilderImpl builder) {
        super(builder);
        this.elasticGpuSet = builder.elasticGpuSet;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasElasticGpuSet() {
        return this.elasticGpuSet != null && !(this.elasticGpuSet instanceof SdkAutoConstructList);
    }

    public final List<ElasticGpus> elasticGpuSet() {
        return this.elasticGpuSet;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasElasticGpuSet() ? this.elasticGpuSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticGpusResponse)) {
            return false;
        }
        DescribeElasticGpusResponse other = (DescribeElasticGpusResponse)((Object)obj);
        return this.hasElasticGpuSet() == other.hasElasticGpuSet() && Objects.equals(this.elasticGpuSet(), other.elasticGpuSet()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeElasticGpusResponse").add("ElasticGpuSet", this.hasElasticGpuSet() ? this.elasticGpuSet() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ElasticGpuSet": {
                return Optional.ofNullable(clazz.cast(this.elasticGpuSet()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeElasticGpusResponse, T> g) {
        return obj -> g.apply((DescribeElasticGpusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<ElasticGpus> elasticGpuSet = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticGpusResponse model) {
            super(model);
            this.elasticGpuSet(model.elasticGpuSet);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final List<ElasticGpus.Builder> getElasticGpuSet() {
            List<ElasticGpus.Builder> result = ElasticGpuSetCopier.copyToBuilder(this.elasticGpuSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setElasticGpuSet(Collection<ElasticGpus.BuilderImpl> elasticGpuSet) {
            this.elasticGpuSet = ElasticGpuSetCopier.copyFromBuilder(elasticGpuSet);
        }

        @Override
        @Transient
        public final Builder elasticGpuSet(Collection<ElasticGpus> elasticGpuSet) {
            this.elasticGpuSet = ElasticGpuSetCopier.copy(elasticGpuSet);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder elasticGpuSet(ElasticGpus ... elasticGpuSet) {
            this.elasticGpuSet(Arrays.asList(elasticGpuSet));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder elasticGpuSet(Consumer<ElasticGpus.Builder> ... elasticGpuSet) {
            this.elasticGpuSet(Stream.of(elasticGpuSet).map(c -> (ElasticGpus)((ElasticGpus.Builder)ElasticGpus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeElasticGpusResponse build() {
            return new DescribeElasticGpusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeElasticGpusResponse> {
        public Builder elasticGpuSet(Collection<ElasticGpus> var1);

        public Builder elasticGpuSet(ElasticGpus ... var1);

        public Builder elasticGpuSet(Consumer<ElasticGpus.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);
    }
}

