/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AttributeBooleanValue;
import software.amazon.awssdk.services.ec2.model.AttributeValue;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.EnclaveOptions;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifierListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMappingListCopier;
import software.amazon.awssdk.services.ec2.model.ProductCode;
import software.amazon.awssdk.services.ec2.model.ProductCodeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInstanceAttributeResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeInstanceAttributeResponse> {
    private static final SdkField<List<GroupIdentifier>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Groups").getter(DescribeInstanceAttributeResponse.getter(DescribeInstanceAttributeResponse::groups)).setter(DescribeInstanceAttributeResponse.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupSet").unmarshallLocationName("groupSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<InstanceBlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BlockDeviceMappings").getter(DescribeInstanceAttributeResponse.getter(DescribeInstanceAttributeResponse::blockDeviceMappings)).setter(DescribeInstanceAttributeResponse.setter(Builder::blockDeviceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping").unmarshallLocationName("blockDeviceMapping").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceBlockDeviceMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<AttributeBooleanValue> DISABLE_API_TERMINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DisableApiTermination").getter(DescribeInstanceAttributeResponse.getter(DescribeInstanceAttributeResponse::disableApiTermination)).setter(DescribeInstanceAttributeResponse.setter(Builder::disableApiTermination)).constructor(AttributeBooleanValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableApiTermination").unmarshallLocationName("disableApiTermination").build()}).build();
    private static final SdkField<AttributeBooleanValue> ENA_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnaSupport").getter(DescribeInstanceAttributeResponse.getter(DescribeInstanceAttributeResponse::enaSupport)).setter(DescribeInstanceAttributeResponse.setter(Builder::enaSupport)).constructor(AttributeBooleanValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSupport").unmarshallLocationName("enaSupport").build()}).build();
    private static final SdkField<EnclaveOptions> ENCLAVE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnclaveOptions").getter(DescribeInstanceAttributeResponse.getter(DescribeInstanceAttributeResponse::enclaveOptions)).setter(DescribeInstanceAttributeResponse.setter(Builder::enclaveOptions)).constructor(EnclaveOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnclaveOptions").unmarshallLocationName("enclaveOptions").build()}).build();
    private static final SdkField<AttributeBooleanValue> EBS_OPTIMIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EbsOptimized").getter(DescribeInstanceAttributeResponse.getter(DescribeInstanceAttributeResponse::ebsOptimized)).setter(DescribeInstanceAttributeResponse.setter(Builder::ebsOptimized)).constructor(AttributeBooleanValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").unmarshallLocationName("ebsOptimized").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(DescribeInstanceAttributeResponse.getter(DescribeInstanceAttributeResponse::instanceId)).setter(DescribeInstanceAttributeResponse.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<AttributeValue> INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceInitiatedShutdownBehavior").getter(DescribeInstanceAttributeResponse.getter(DescribeInstanceAttributeResponse::instanceInitiatedShutdownBehavior)).setter(DescribeInstanceAttributeResponse.setter(Builder::instanceInitiatedShutdownBehavior)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInitiatedShutdownBehavior").unmarshallLocationName("instanceInitiatedShutdownBehavior").build()}).build();
    private static final SdkField<AttributeValue> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceType").getter(DescribeInstanceAttributeResponse.getter(DescribeInstanceAttributeResponse::instanceType)).setter(DescribeInstanceAttributeResponse.setter(Builder::instanceType)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<AttributeValue> KERNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KernelId").getter(DescribeInstanceAttributeResponse.getter(DescribeInstanceAttributeResponse::kernelId)).setter(DescribeInstanceAttributeResponse.setter(Builder::kernelId)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Kernel").unmarshallLocationName("kernel").build()}).build();
    private static final SdkField<List<ProductCode>> PRODUCT_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProductCodes").getter(DescribeInstanceAttributeResponse.getter(DescribeInstanceAttributeResponse::productCodes)).setter(DescribeInstanceAttributeResponse.setter(Builder::productCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCodes").unmarshallLocationName("productCodes").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProductCode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<AttributeValue> RAMDISK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RamdiskId").getter(DescribeInstanceAttributeResponse.getter(DescribeInstanceAttributeResponse::ramdiskId)).setter(DescribeInstanceAttributeResponse.setter(Builder::ramdiskId)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ramdisk").unmarshallLocationName("ramdisk").build()}).build();
    private static final SdkField<AttributeValue> ROOT_DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RootDeviceName").getter(DescribeInstanceAttributeResponse.getter(DescribeInstanceAttributeResponse::rootDeviceName)).setter(DescribeInstanceAttributeResponse.setter(Builder::rootDeviceName)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootDeviceName").unmarshallLocationName("rootDeviceName").build()}).build();
    private static final SdkField<AttributeBooleanValue> SOURCE_DEST_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceDestCheck").getter(DescribeInstanceAttributeResponse.getter(DescribeInstanceAttributeResponse::sourceDestCheck)).setter(DescribeInstanceAttributeResponse.setter(Builder::sourceDestCheck)).constructor(AttributeBooleanValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDestCheck").unmarshallLocationName("sourceDestCheck").build()}).build();
    private static final SdkField<AttributeValue> SRIOV_NET_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SriovNetSupport").getter(DescribeInstanceAttributeResponse.getter(DescribeInstanceAttributeResponse::sriovNetSupport)).setter(DescribeInstanceAttributeResponse.setter(Builder::sriovNetSupport)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SriovNetSupport").unmarshallLocationName("sriovNetSupport").build()}).build();
    private static final SdkField<AttributeValue> USER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserData").getter(DescribeInstanceAttributeResponse.getter(DescribeInstanceAttributeResponse::userData)).setter(DescribeInstanceAttributeResponse.setter(Builder::userData)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserData").unmarshallLocationName("userData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUPS_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, DISABLE_API_TERMINATION_FIELD, ENA_SUPPORT_FIELD, ENCLAVE_OPTIONS_FIELD, EBS_OPTIMIZED_FIELD, INSTANCE_ID_FIELD, INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD, INSTANCE_TYPE_FIELD, KERNEL_ID_FIELD, PRODUCT_CODES_FIELD, RAMDISK_ID_FIELD, ROOT_DEVICE_NAME_FIELD, SOURCE_DEST_CHECK_FIELD, SRIOV_NET_SUPPORT_FIELD, USER_DATA_FIELD));
    private final List<GroupIdentifier> groups;
    private final List<InstanceBlockDeviceMapping> blockDeviceMappings;
    private final AttributeBooleanValue disableApiTermination;
    private final AttributeBooleanValue enaSupport;
    private final EnclaveOptions enclaveOptions;
    private final AttributeBooleanValue ebsOptimized;
    private final String instanceId;
    private final AttributeValue instanceInitiatedShutdownBehavior;
    private final AttributeValue instanceType;
    private final AttributeValue kernelId;
    private final List<ProductCode> productCodes;
    private final AttributeValue ramdiskId;
    private final AttributeValue rootDeviceName;
    private final AttributeBooleanValue sourceDestCheck;
    private final AttributeValue sriovNetSupport;
    private final AttributeValue userData;

    private DescribeInstanceAttributeResponse(BuilderImpl builder) {
        super(builder);
        this.groups = builder.groups;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.disableApiTermination = builder.disableApiTermination;
        this.enaSupport = builder.enaSupport;
        this.enclaveOptions = builder.enclaveOptions;
        this.ebsOptimized = builder.ebsOptimized;
        this.instanceId = builder.instanceId;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.productCodes = builder.productCodes;
        this.ramdiskId = builder.ramdiskId;
        this.rootDeviceName = builder.rootDeviceName;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.userData = builder.userData;
    }

    public final boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public final List<GroupIdentifier> groups() {
        return this.groups;
    }

    public final boolean hasBlockDeviceMappings() {
        return this.blockDeviceMappings != null && !(this.blockDeviceMappings instanceof SdkAutoConstructList);
    }

    public final List<InstanceBlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public final AttributeBooleanValue disableApiTermination() {
        return this.disableApiTermination;
    }

    public final AttributeBooleanValue enaSupport() {
        return this.enaSupport;
    }

    public final EnclaveOptions enclaveOptions() {
        return this.enclaveOptions;
    }

    public final AttributeBooleanValue ebsOptimized() {
        return this.ebsOptimized;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final AttributeValue instanceInitiatedShutdownBehavior() {
        return this.instanceInitiatedShutdownBehavior;
    }

    public final AttributeValue instanceType() {
        return this.instanceType;
    }

    public final AttributeValue kernelId() {
        return this.kernelId;
    }

    public final boolean hasProductCodes() {
        return this.productCodes != null && !(this.productCodes instanceof SdkAutoConstructList);
    }

    public final List<ProductCode> productCodes() {
        return this.productCodes;
    }

    public final AttributeValue ramdiskId() {
        return this.ramdiskId;
    }

    public final AttributeValue rootDeviceName() {
        return this.rootDeviceName;
    }

    public final AttributeBooleanValue sourceDestCheck() {
        return this.sourceDestCheck;
    }

    public final AttributeValue sriovNetSupport() {
        return this.sriovNetSupport;
    }

    public final AttributeValue userData() {
        return this.userData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroups() ? this.groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.disableApiTermination());
        hashCode = 31 * hashCode + Objects.hashCode(this.enaSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.enclaveOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceInitiatedShutdownBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProductCodes() ? this.productCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootDeviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDestCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.sriovNetSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.userData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceAttributeResponse)) {
            return false;
        }
        DescribeInstanceAttributeResponse other = (DescribeInstanceAttributeResponse)((Object)obj);
        return this.hasGroups() == other.hasGroups() && Objects.equals(this.groups(), other.groups()) && this.hasBlockDeviceMappings() == other.hasBlockDeviceMappings() && Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(this.disableApiTermination(), other.disableApiTermination()) && Objects.equals(this.enaSupport(), other.enaSupport()) && Objects.equals(this.enclaveOptions(), other.enclaveOptions()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.instanceInitiatedShutdownBehavior(), other.instanceInitiatedShutdownBehavior()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.kernelId(), other.kernelId()) && this.hasProductCodes() == other.hasProductCodes() && Objects.equals(this.productCodes(), other.productCodes()) && Objects.equals(this.ramdiskId(), other.ramdiskId()) && Objects.equals(this.rootDeviceName(), other.rootDeviceName()) && Objects.equals(this.sourceDestCheck(), other.sourceDestCheck()) && Objects.equals(this.sriovNetSupport(), other.sriovNetSupport()) && Objects.equals(this.userData(), other.userData());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeInstanceAttributeResponse").add("Groups", this.hasGroups() ? this.groups() : null).add("BlockDeviceMappings", this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null).add("DisableApiTermination", (Object)this.disableApiTermination()).add("EnaSupport", (Object)this.enaSupport()).add("EnclaveOptions", (Object)this.enclaveOptions()).add("EbsOptimized", (Object)this.ebsOptimized()).add("InstanceId", (Object)this.instanceId()).add("InstanceInitiatedShutdownBehavior", (Object)this.instanceInitiatedShutdownBehavior()).add("InstanceType", (Object)this.instanceType()).add("KernelId", (Object)this.kernelId()).add("ProductCodes", this.hasProductCodes() ? this.productCodes() : null).add("RamdiskId", (Object)this.ramdiskId()).add("RootDeviceName", (Object)this.rootDeviceName()).add("SourceDestCheck", (Object)this.sourceDestCheck()).add("SriovNetSupport", (Object)this.sriovNetSupport()).add("UserData", (Object)this.userData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "BlockDeviceMappings": {
                return Optional.ofNullable(clazz.cast(this.blockDeviceMappings()));
            }
            case "DisableApiTermination": {
                return Optional.ofNullable(clazz.cast(this.disableApiTermination()));
            }
            case "EnaSupport": {
                return Optional.ofNullable(clazz.cast(this.enaSupport()));
            }
            case "EnclaveOptions": {
                return Optional.ofNullable(clazz.cast(this.enclaveOptions()));
            }
            case "EbsOptimized": {
                return Optional.ofNullable(clazz.cast(this.ebsOptimized()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "InstanceInitiatedShutdownBehavior": {
                return Optional.ofNullable(clazz.cast(this.instanceInitiatedShutdownBehavior()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "KernelId": {
                return Optional.ofNullable(clazz.cast(this.kernelId()));
            }
            case "ProductCodes": {
                return Optional.ofNullable(clazz.cast(this.productCodes()));
            }
            case "RamdiskId": {
                return Optional.ofNullable(clazz.cast(this.ramdiskId()));
            }
            case "RootDeviceName": {
                return Optional.ofNullable(clazz.cast(this.rootDeviceName()));
            }
            case "SourceDestCheck": {
                return Optional.ofNullable(clazz.cast(this.sourceDestCheck()));
            }
            case "SriovNetSupport": {
                return Optional.ofNullable(clazz.cast(this.sriovNetSupport()));
            }
            case "UserData": {
                return Optional.ofNullable(clazz.cast(this.userData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceAttributeResponse, T> g) {
        return obj -> g.apply((DescribeInstanceAttributeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<GroupIdentifier> groups = DefaultSdkAutoConstructList.getInstance();
        private List<InstanceBlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();
        private AttributeBooleanValue disableApiTermination;
        private AttributeBooleanValue enaSupport;
        private EnclaveOptions enclaveOptions;
        private AttributeBooleanValue ebsOptimized;
        private String instanceId;
        private AttributeValue instanceInitiatedShutdownBehavior;
        private AttributeValue instanceType;
        private AttributeValue kernelId;
        private List<ProductCode> productCodes = DefaultSdkAutoConstructList.getInstance();
        private AttributeValue ramdiskId;
        private AttributeValue rootDeviceName;
        private AttributeBooleanValue sourceDestCheck;
        private AttributeValue sriovNetSupport;
        private AttributeValue userData;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceAttributeResponse model) {
            super(model);
            this.groups(model.groups);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.disableApiTermination(model.disableApiTermination);
            this.enaSupport(model.enaSupport);
            this.enclaveOptions(model.enclaveOptions);
            this.ebsOptimized(model.ebsOptimized);
            this.instanceId(model.instanceId);
            this.instanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            this.instanceType(model.instanceType);
            this.kernelId(model.kernelId);
            this.productCodes(model.productCodes);
            this.ramdiskId(model.ramdiskId);
            this.rootDeviceName(model.rootDeviceName);
            this.sourceDestCheck(model.sourceDestCheck);
            this.sriovNetSupport(model.sriovNetSupport);
            this.userData(model.userData);
        }

        public final List<GroupIdentifier.Builder> getGroups() {
            List<GroupIdentifier.Builder> result = GroupIdentifierListCopier.copyToBuilder(this.groups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder groups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupIdentifier ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<GroupIdentifier.Builder> ... groups) {
            this.groups(Stream.of(groups).map(c -> (GroupIdentifier)((GroupIdentifier.Builder)GroupIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroups(Collection<GroupIdentifier.BuilderImpl> groups) {
            this.groups = GroupIdentifierListCopier.copyFromBuilder(groups);
        }

        public final List<InstanceBlockDeviceMapping.Builder> getBlockDeviceMappings() {
            List<InstanceBlockDeviceMapping.Builder> result = InstanceBlockDeviceMappingListCopier.copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(InstanceBlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMapping.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (InstanceBlockDeviceMapping)((InstanceBlockDeviceMapping.Builder)InstanceBlockDeviceMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<InstanceBlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final AttributeBooleanValue.Builder getDisableApiTermination() {
            return this.disableApiTermination != null ? this.disableApiTermination.toBuilder() : null;
        }

        @Override
        public final Builder disableApiTermination(AttributeBooleanValue disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        public final void setDisableApiTermination(AttributeBooleanValue.BuilderImpl disableApiTermination) {
            this.disableApiTermination = disableApiTermination != null ? disableApiTermination.build() : null;
        }

        public final AttributeBooleanValue.Builder getEnaSupport() {
            return this.enaSupport != null ? this.enaSupport.toBuilder() : null;
        }

        @Override
        public final Builder enaSupport(AttributeBooleanValue enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        public final void setEnaSupport(AttributeBooleanValue.BuilderImpl enaSupport) {
            this.enaSupport = enaSupport != null ? enaSupport.build() : null;
        }

        public final EnclaveOptions.Builder getEnclaveOptions() {
            return this.enclaveOptions != null ? this.enclaveOptions.toBuilder() : null;
        }

        @Override
        public final Builder enclaveOptions(EnclaveOptions enclaveOptions) {
            this.enclaveOptions = enclaveOptions;
            return this;
        }

        public final void setEnclaveOptions(EnclaveOptions.BuilderImpl enclaveOptions) {
            this.enclaveOptions = enclaveOptions != null ? enclaveOptions.build() : null;
        }

        public final AttributeBooleanValue.Builder getEbsOptimized() {
            return this.ebsOptimized != null ? this.ebsOptimized.toBuilder() : null;
        }

        @Override
        public final Builder ebsOptimized(AttributeBooleanValue ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(AttributeBooleanValue.BuilderImpl ebsOptimized) {
            this.ebsOptimized = ebsOptimized != null ? ebsOptimized.build() : null;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final AttributeValue.Builder getInstanceInitiatedShutdownBehavior() {
            return this.instanceInitiatedShutdownBehavior != null ? this.instanceInitiatedShutdownBehavior.toBuilder() : null;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(AttributeValue instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        public final void setInstanceInitiatedShutdownBehavior(AttributeValue.BuilderImpl instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior != null ? instanceInitiatedShutdownBehavior.build() : null;
        }

        public final AttributeValue.Builder getInstanceType() {
            return this.instanceType != null ? this.instanceType.toBuilder() : null;
        }

        @Override
        public final Builder instanceType(AttributeValue instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(AttributeValue.BuilderImpl instanceType) {
            this.instanceType = instanceType != null ? instanceType.build() : null;
        }

        public final AttributeValue.Builder getKernelId() {
            return this.kernelId != null ? this.kernelId.toBuilder() : null;
        }

        @Override
        public final Builder kernelId(AttributeValue kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(AttributeValue.BuilderImpl kernelId) {
            this.kernelId = kernelId != null ? kernelId.build() : null;
        }

        public final List<ProductCode.Builder> getProductCodes() {
            List<ProductCode.Builder> result = ProductCodeListCopier.copyToBuilder(this.productCodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode ... productCodes) {
            this.productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCode.Builder> ... productCodes) {
            this.productCodes(Stream.of(productCodes).map(c -> (ProductCode)((ProductCode.Builder)ProductCode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        public final AttributeValue.Builder getRamdiskId() {
            return this.ramdiskId != null ? this.ramdiskId.toBuilder() : null;
        }

        @Override
        public final Builder ramdiskId(AttributeValue ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(AttributeValue.BuilderImpl ramdiskId) {
            this.ramdiskId = ramdiskId != null ? ramdiskId.build() : null;
        }

        public final AttributeValue.Builder getRootDeviceName() {
            return this.rootDeviceName != null ? this.rootDeviceName.toBuilder() : null;
        }

        @Override
        public final Builder rootDeviceName(AttributeValue rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
            return this;
        }

        public final void setRootDeviceName(AttributeValue.BuilderImpl rootDeviceName) {
            this.rootDeviceName = rootDeviceName != null ? rootDeviceName.build() : null;
        }

        public final AttributeBooleanValue.Builder getSourceDestCheck() {
            return this.sourceDestCheck != null ? this.sourceDestCheck.toBuilder() : null;
        }

        @Override
        public final Builder sourceDestCheck(AttributeBooleanValue sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(AttributeBooleanValue.BuilderImpl sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck != null ? sourceDestCheck.build() : null;
        }

        public final AttributeValue.Builder getSriovNetSupport() {
            return this.sriovNetSupport != null ? this.sriovNetSupport.toBuilder() : null;
        }

        @Override
        public final Builder sriovNetSupport(AttributeValue sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final void setSriovNetSupport(AttributeValue.BuilderImpl sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport != null ? sriovNetSupport.build() : null;
        }

        public final AttributeValue.Builder getUserData() {
            return this.userData != null ? this.userData.toBuilder() : null;
        }

        @Override
        public final Builder userData(AttributeValue userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(AttributeValue.BuilderImpl userData) {
            this.userData = userData != null ? userData.build() : null;
        }

        @Override
        public DescribeInstanceAttributeResponse build() {
            return new DescribeInstanceAttributeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInstanceAttributeResponse> {
        public Builder groups(Collection<GroupIdentifier> var1);

        public Builder groups(GroupIdentifier ... var1);

        public Builder groups(Consumer<GroupIdentifier.Builder> ... var1);

        public Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> var1);

        public Builder blockDeviceMappings(InstanceBlockDeviceMapping ... var1);

        public Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMapping.Builder> ... var1);

        public Builder disableApiTermination(AttributeBooleanValue var1);

        default public Builder disableApiTermination(Consumer<AttributeBooleanValue.Builder> disableApiTermination) {
            return this.disableApiTermination((AttributeBooleanValue)((AttributeBooleanValue.Builder)AttributeBooleanValue.builder().applyMutation(disableApiTermination)).build());
        }

        public Builder enaSupport(AttributeBooleanValue var1);

        default public Builder enaSupport(Consumer<AttributeBooleanValue.Builder> enaSupport) {
            return this.enaSupport((AttributeBooleanValue)((AttributeBooleanValue.Builder)AttributeBooleanValue.builder().applyMutation(enaSupport)).build());
        }

        public Builder enclaveOptions(EnclaveOptions var1);

        default public Builder enclaveOptions(Consumer<EnclaveOptions.Builder> enclaveOptions) {
            return this.enclaveOptions((EnclaveOptions)((EnclaveOptions.Builder)EnclaveOptions.builder().applyMutation(enclaveOptions)).build());
        }

        public Builder ebsOptimized(AttributeBooleanValue var1);

        default public Builder ebsOptimized(Consumer<AttributeBooleanValue.Builder> ebsOptimized) {
            return this.ebsOptimized((AttributeBooleanValue)((AttributeBooleanValue.Builder)AttributeBooleanValue.builder().applyMutation(ebsOptimized)).build());
        }

        public Builder instanceId(String var1);

        public Builder instanceInitiatedShutdownBehavior(AttributeValue var1);

        default public Builder instanceInitiatedShutdownBehavior(Consumer<AttributeValue.Builder> instanceInitiatedShutdownBehavior) {
            return this.instanceInitiatedShutdownBehavior((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(instanceInitiatedShutdownBehavior)).build());
        }

        public Builder instanceType(AttributeValue var1);

        default public Builder instanceType(Consumer<AttributeValue.Builder> instanceType) {
            return this.instanceType((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(instanceType)).build());
        }

        public Builder kernelId(AttributeValue var1);

        default public Builder kernelId(Consumer<AttributeValue.Builder> kernelId) {
            return this.kernelId((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(kernelId)).build());
        }

        public Builder productCodes(Collection<ProductCode> var1);

        public Builder productCodes(ProductCode ... var1);

        public Builder productCodes(Consumer<ProductCode.Builder> ... var1);

        public Builder ramdiskId(AttributeValue var1);

        default public Builder ramdiskId(Consumer<AttributeValue.Builder> ramdiskId) {
            return this.ramdiskId((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(ramdiskId)).build());
        }

        public Builder rootDeviceName(AttributeValue var1);

        default public Builder rootDeviceName(Consumer<AttributeValue.Builder> rootDeviceName) {
            return this.rootDeviceName((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(rootDeviceName)).build());
        }

        public Builder sourceDestCheck(AttributeBooleanValue var1);

        default public Builder sourceDestCheck(Consumer<AttributeBooleanValue.Builder> sourceDestCheck) {
            return this.sourceDestCheck((AttributeBooleanValue)((AttributeBooleanValue.Builder)AttributeBooleanValue.builder().applyMutation(sourceDestCheck)).build());
        }

        public Builder sriovNetSupport(AttributeValue var1);

        default public Builder sriovNetSupport(Consumer<AttributeValue.Builder> sriovNetSupport) {
            return this.sriovNetSupport((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(sriovNetSupport)).build());
        }

        public Builder userData(AttributeValue var1);

        default public Builder userData(Consumer<AttributeValue.Builder> userData) {
            return this.userData((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(userData)).build());
        }
    }
}

