/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAnalysesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAnalysesResponse;
import software.amazon.awssdk.services.ec2.model.NetworkInsightsAnalysis;

public class DescribeNetworkInsightsAnalysesIterable
implements SdkIterable<DescribeNetworkInsightsAnalysesResponse> {
    private final Ec2Client client;
    private final DescribeNetworkInsightsAnalysesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeNetworkInsightsAnalysesIterable(Ec2Client client, DescribeNetworkInsightsAnalysesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeNetworkInsightsAnalysesResponseFetcher();
    }

    public Iterator<DescribeNetworkInsightsAnalysesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<NetworkInsightsAnalysis> networkInsightsAnalyses() {
        Function<DescribeNetworkInsightsAnalysesResponse, Iterator> getIterator = response -> {
            if (response != null && response.networkInsightsAnalyses() != null) {
                return response.networkInsightsAnalyses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeNetworkInsightsAnalysesResponseFetcher
    implements SyncPageFetcher<DescribeNetworkInsightsAnalysesResponse> {
        private DescribeNetworkInsightsAnalysesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeNetworkInsightsAnalysesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeNetworkInsightsAnalysesResponse nextPage(DescribeNetworkInsightsAnalysesResponse previousPage) {
            if (previousPage == null) {
                return DescribeNetworkInsightsAnalysesIterable.this.client.describeNetworkInsightsAnalyses(DescribeNetworkInsightsAnalysesIterable.this.firstRequest);
            }
            return DescribeNetworkInsightsAnalysesIterable.this.client.describeNetworkInsightsAnalyses((DescribeNetworkInsightsAnalysesRequest)((Object)DescribeNetworkInsightsAnalysesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

