/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentAssociation;
import software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType;
import software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayAttachment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayAttachment> {
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayAttachmentId").getter(TransitGatewayAttachment.getter(TransitGatewayAttachment::transitGatewayAttachmentId)).setter(TransitGatewayAttachment.setter(Builder::transitGatewayAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId").unmarshallLocationName("transitGatewayAttachmentId").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayId").getter(TransitGatewayAttachment.getter(TransitGatewayAttachment::transitGatewayId)).setter(TransitGatewayAttachment.setter(Builder::transitGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId").unmarshallLocationName("transitGatewayId").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayOwnerId").getter(TransitGatewayAttachment.getter(TransitGatewayAttachment::transitGatewayOwnerId)).setter(TransitGatewayAttachment.setter(Builder::transitGatewayOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayOwnerId").unmarshallLocationName("transitGatewayOwnerId").build()}).build();
    private static final SdkField<String> RESOURCE_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceOwnerId").getter(TransitGatewayAttachment.getter(TransitGatewayAttachment::resourceOwnerId)).setter(TransitGatewayAttachment.setter(Builder::resourceOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwnerId").unmarshallLocationName("resourceOwnerId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(TransitGatewayAttachment.getter(TransitGatewayAttachment::resourceTypeAsString)).setter(TransitGatewayAttachment.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").unmarshallLocationName("resourceType").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(TransitGatewayAttachment.getter(TransitGatewayAttachment::resourceId)).setter(TransitGatewayAttachment.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").unmarshallLocationName("resourceId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(TransitGatewayAttachment.getter(TransitGatewayAttachment::stateAsString)).setter(TransitGatewayAttachment.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<TransitGatewayAttachmentAssociation> ASSOCIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Association").getter(TransitGatewayAttachment.getter(TransitGatewayAttachment::association)).setter(TransitGatewayAttachment.setter(Builder::association)).constructor(TransitGatewayAttachmentAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Association").unmarshallLocationName("association").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(TransitGatewayAttachment.getter(TransitGatewayAttachment::creationTime)).setter(TransitGatewayAttachment.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").unmarshallLocationName("creationTime").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(TransitGatewayAttachment.getter(TransitGatewayAttachment::tags)).setter(TransitGatewayAttachment.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, TRANSIT_GATEWAY_ID_FIELD, TRANSIT_GATEWAY_OWNER_ID_FIELD, RESOURCE_OWNER_ID_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, STATE_FIELD, ASSOCIATION_FIELD, CREATION_TIME_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String transitGatewayAttachmentId;
    private final String transitGatewayId;
    private final String transitGatewayOwnerId;
    private final String resourceOwnerId;
    private final String resourceType;
    private final String resourceId;
    private final String state;
    private final TransitGatewayAttachmentAssociation association;
    private final Instant creationTime;
    private final List<Tag> tags;

    private TransitGatewayAttachment(BuilderImpl builder) {
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.transitGatewayId = builder.transitGatewayId;
        this.transitGatewayOwnerId = builder.transitGatewayOwnerId;
        this.resourceOwnerId = builder.resourceOwnerId;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.state = builder.state;
        this.association = builder.association;
        this.creationTime = builder.creationTime;
        this.tags = builder.tags;
    }

    public final String transitGatewayAttachmentId() {
        return this.transitGatewayAttachmentId;
    }

    public final String transitGatewayId() {
        return this.transitGatewayId;
    }

    public final String transitGatewayOwnerId() {
        return this.transitGatewayOwnerId;
    }

    public final String resourceOwnerId() {
        return this.resourceOwnerId;
    }

    public final TransitGatewayAttachmentResourceType resourceType() {
        return TransitGatewayAttachmentResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final TransitGatewayAttachmentState state() {
        return TransitGatewayAttachmentState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final TransitGatewayAttachmentAssociation association() {
        return this.association;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.association());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayAttachment)) {
            return false;
        }
        TransitGatewayAttachment other = (TransitGatewayAttachment)obj;
        return Objects.equals(this.transitGatewayAttachmentId(), other.transitGatewayAttachmentId()) && Objects.equals(this.transitGatewayId(), other.transitGatewayId()) && Objects.equals(this.transitGatewayOwnerId(), other.transitGatewayOwnerId()) && Objects.equals(this.resourceOwnerId(), other.resourceOwnerId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.association(), other.association()) && Objects.equals(this.creationTime(), other.creationTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"TransitGatewayAttachment").add("TransitGatewayAttachmentId", (Object)this.transitGatewayAttachmentId()).add("TransitGatewayId", (Object)this.transitGatewayId()).add("TransitGatewayOwnerId", (Object)this.transitGatewayOwnerId()).add("ResourceOwnerId", (Object)this.resourceOwnerId()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceId", (Object)this.resourceId()).add("State", (Object)this.stateAsString()).add("Association", (Object)this.association()).add("CreationTime", (Object)this.creationTime()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayAttachmentId()));
            }
            case "TransitGatewayId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayId()));
            }
            case "TransitGatewayOwnerId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayOwnerId()));
            }
            case "ResourceOwnerId": {
                return Optional.ofNullable(clazz.cast(this.resourceOwnerId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Association": {
                return Optional.ofNullable(clazz.cast(this.association()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayAttachment, T> g) {
        return obj -> g.apply((TransitGatewayAttachment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transitGatewayAttachmentId;
        private String transitGatewayId;
        private String transitGatewayOwnerId;
        private String resourceOwnerId;
        private String resourceType;
        private String resourceId;
        private String state;
        private TransitGatewayAttachmentAssociation association;
        private Instant creationTime;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayAttachment model) {
            this.transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            this.transitGatewayId(model.transitGatewayId);
            this.transitGatewayOwnerId(model.transitGatewayOwnerId);
            this.resourceOwnerId(model.resourceOwnerId);
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
            this.state(model.state);
            this.association(model.association);
            this.creationTime(model.creationTime);
            this.tags(model.tags);
        }

        public final String getTransitGatewayAttachmentId() {
            return this.transitGatewayAttachmentId;
        }

        @Override
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        public final String getTransitGatewayId() {
            return this.transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        public final String getTransitGatewayOwnerId() {
            return this.transitGatewayOwnerId;
        }

        @Override
        public final Builder transitGatewayOwnerId(String transitGatewayOwnerId) {
            this.transitGatewayOwnerId = transitGatewayOwnerId;
            return this;
        }

        public final void setTransitGatewayOwnerId(String transitGatewayOwnerId) {
            this.transitGatewayOwnerId = transitGatewayOwnerId;
        }

        public final String getResourceOwnerId() {
            return this.resourceOwnerId;
        }

        @Override
        public final Builder resourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public final void setResourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TransitGatewayAttachmentResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TransitGatewayAttachmentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final TransitGatewayAttachmentAssociation.Builder getAssociation() {
            return this.association != null ? this.association.toBuilder() : null;
        }

        @Override
        public final Builder association(TransitGatewayAttachmentAssociation association) {
            this.association = association;
            return this;
        }

        public final void setAssociation(TransitGatewayAttachmentAssociation.BuilderImpl association) {
            this.association = association != null ? association.build() : null;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public TransitGatewayAttachment build() {
            return new TransitGatewayAttachment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayAttachment> {
        public Builder transitGatewayAttachmentId(String var1);

        public Builder transitGatewayId(String var1);

        public Builder transitGatewayOwnerId(String var1);

        public Builder resourceOwnerId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(TransitGatewayAttachmentResourceType var1);

        public Builder resourceId(String var1);

        public Builder state(String var1);

        public Builder state(TransitGatewayAttachmentState var1);

        public Builder association(TransitGatewayAttachmentAssociation var1);

        default public Builder association(Consumer<TransitGatewayAttachmentAssociation.Builder> association) {
            return this.association((TransitGatewayAttachmentAssociation)((TransitGatewayAttachmentAssociation.Builder)TransitGatewayAttachmentAssociation.builder().applyMutation(association)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

