/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVpcEndpointServiceConfigurationRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateVpcEndpointServiceConfigurationRequest> {
    private static final SdkField<Boolean> ACCEPTANCE_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AcceptanceRequired").getter(CreateVpcEndpointServiceConfigurationRequest.getter(CreateVpcEndpointServiceConfigurationRequest::acceptanceRequired)).setter(CreateVpcEndpointServiceConfigurationRequest.setter(Builder::acceptanceRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptanceRequired").unmarshallLocationName("AcceptanceRequired").build()}).build();
    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateDnsName").getter(CreateVpcEndpointServiceConfigurationRequest.getter(CreateVpcEndpointServiceConfigurationRequest::privateDnsName)).setter(CreateVpcEndpointServiceConfigurationRequest.setter(Builder::privateDnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsName").unmarshallLocationName("PrivateDnsName").build()}).build();
    private static final SdkField<List<String>> NETWORK_LOAD_BALANCER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkLoadBalancerArns").getter(CreateVpcEndpointServiceConfigurationRequest.getter(CreateVpcEndpointServiceConfigurationRequest::networkLoadBalancerArns)).setter(CreateVpcEndpointServiceConfigurationRequest.setter(Builder::networkLoadBalancerArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkLoadBalancerArn").unmarshallLocationName("NetworkLoadBalancerArn").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> GATEWAY_LOAD_BALANCER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GatewayLoadBalancerArns").getter(CreateVpcEndpointServiceConfigurationRequest.getter(CreateVpcEndpointServiceConfigurationRequest::gatewayLoadBalancerArns)).setter(CreateVpcEndpointServiceConfigurationRequest.setter(Builder::gatewayLoadBalancerArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayLoadBalancerArn").unmarshallLocationName("GatewayLoadBalancerArn").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateVpcEndpointServiceConfigurationRequest.getter(CreateVpcEndpointServiceConfigurationRequest::clientToken)).setter(CreateVpcEndpointServiceConfigurationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateVpcEndpointServiceConfigurationRequest.getter(CreateVpcEndpointServiceConfigurationRequest::tagSpecifications)).setter(CreateVpcEndpointServiceConfigurationRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPTANCE_REQUIRED_FIELD, PRIVATE_DNS_NAME_FIELD, NETWORK_LOAD_BALANCER_ARNS_FIELD, GATEWAY_LOAD_BALANCER_ARNS_FIELD, CLIENT_TOKEN_FIELD, TAG_SPECIFICATIONS_FIELD));
    private final Boolean acceptanceRequired;
    private final String privateDnsName;
    private final List<String> networkLoadBalancerArns;
    private final List<String> gatewayLoadBalancerArns;
    private final String clientToken;
    private final List<TagSpecification> tagSpecifications;

    private CreateVpcEndpointServiceConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.acceptanceRequired = builder.acceptanceRequired;
        this.privateDnsName = builder.privateDnsName;
        this.networkLoadBalancerArns = builder.networkLoadBalancerArns;
        this.gatewayLoadBalancerArns = builder.gatewayLoadBalancerArns;
        this.clientToken = builder.clientToken;
        this.tagSpecifications = builder.tagSpecifications;
    }

    public final Boolean acceptanceRequired() {
        return this.acceptanceRequired;
    }

    public final String privateDnsName() {
        return this.privateDnsName;
    }

    public final boolean hasNetworkLoadBalancerArns() {
        return this.networkLoadBalancerArns != null && !(this.networkLoadBalancerArns instanceof SdkAutoConstructList);
    }

    public final List<String> networkLoadBalancerArns() {
        return this.networkLoadBalancerArns;
    }

    public final boolean hasGatewayLoadBalancerArns() {
        return this.gatewayLoadBalancerArns != null && !(this.gatewayLoadBalancerArns instanceof SdkAutoConstructList);
    }

    public final List<String> gatewayLoadBalancerArns() {
        return this.gatewayLoadBalancerArns;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptanceRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkLoadBalancerArns() ? this.networkLoadBalancerArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGatewayLoadBalancerArns() ? this.gatewayLoadBalancerArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcEndpointServiceConfigurationRequest)) {
            return false;
        }
        CreateVpcEndpointServiceConfigurationRequest other = (CreateVpcEndpointServiceConfigurationRequest)((Object)obj);
        return Objects.equals(this.acceptanceRequired(), other.acceptanceRequired()) && Objects.equals(this.privateDnsName(), other.privateDnsName()) && this.hasNetworkLoadBalancerArns() == other.hasNetworkLoadBalancerArns() && Objects.equals(this.networkLoadBalancerArns(), other.networkLoadBalancerArns()) && this.hasGatewayLoadBalancerArns() == other.hasGatewayLoadBalancerArns() && Objects.equals(this.gatewayLoadBalancerArns(), other.gatewayLoadBalancerArns()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVpcEndpointServiceConfigurationRequest").add("AcceptanceRequired", (Object)this.acceptanceRequired()).add("PrivateDnsName", (Object)this.privateDnsName()).add("NetworkLoadBalancerArns", this.hasNetworkLoadBalancerArns() ? this.networkLoadBalancerArns() : null).add("GatewayLoadBalancerArns", this.hasGatewayLoadBalancerArns() ? this.gatewayLoadBalancerArns() : null).add("ClientToken", (Object)this.clientToken()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptanceRequired": {
                return Optional.ofNullable(clazz.cast(this.acceptanceRequired()));
            }
            case "PrivateDnsName": {
                return Optional.ofNullable(clazz.cast(this.privateDnsName()));
            }
            case "NetworkLoadBalancerArns": {
                return Optional.ofNullable(clazz.cast(this.networkLoadBalancerArns()));
            }
            case "GatewayLoadBalancerArns": {
                return Optional.ofNullable(clazz.cast(this.gatewayLoadBalancerArns()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcEndpointServiceConfigurationRequest, T> g) {
        return obj -> g.apply((CreateVpcEndpointServiceConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean acceptanceRequired;
        private String privateDnsName;
        private List<String> networkLoadBalancerArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> gatewayLoadBalancerArns = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcEndpointServiceConfigurationRequest model) {
            super(model);
            this.acceptanceRequired(model.acceptanceRequired);
            this.privateDnsName(model.privateDnsName);
            this.networkLoadBalancerArns(model.networkLoadBalancerArns);
            this.gatewayLoadBalancerArns(model.gatewayLoadBalancerArns);
            this.clientToken(model.clientToken);
            this.tagSpecifications(model.tagSpecifications);
        }

        public final Boolean getAcceptanceRequired() {
            return this.acceptanceRequired;
        }

        @Override
        public final Builder acceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
            return this;
        }

        public final void setAcceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
        }

        public final String getPrivateDnsName() {
            return this.privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final Collection<String> getNetworkLoadBalancerArns() {
            if (this.networkLoadBalancerArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.networkLoadBalancerArns;
        }

        @Override
        public final Builder networkLoadBalancerArns(Collection<String> networkLoadBalancerArns) {
            this.networkLoadBalancerArns = ValueStringListCopier.copy(networkLoadBalancerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkLoadBalancerArns(String ... networkLoadBalancerArns) {
            this.networkLoadBalancerArns(Arrays.asList(networkLoadBalancerArns));
            return this;
        }

        public final void setNetworkLoadBalancerArns(Collection<String> networkLoadBalancerArns) {
            this.networkLoadBalancerArns = ValueStringListCopier.copy(networkLoadBalancerArns);
        }

        public final Collection<String> getGatewayLoadBalancerArns() {
            if (this.gatewayLoadBalancerArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.gatewayLoadBalancerArns;
        }

        @Override
        public final Builder gatewayLoadBalancerArns(Collection<String> gatewayLoadBalancerArns) {
            this.gatewayLoadBalancerArns = ValueStringListCopier.copy(gatewayLoadBalancerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayLoadBalancerArns(String ... gatewayLoadBalancerArns) {
            this.gatewayLoadBalancerArns(Arrays.asList(gatewayLoadBalancerArns));
            return this;
        }

        public final void setGatewayLoadBalancerArns(Collection<String> gatewayLoadBalancerArns) {
            this.gatewayLoadBalancerArns = ValueStringListCopier.copy(gatewayLoadBalancerArns);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcEndpointServiceConfigurationRequest build() {
            return new CreateVpcEndpointServiceConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVpcEndpointServiceConfigurationRequest> {
        public Builder acceptanceRequired(Boolean var1);

        public Builder privateDnsName(String var1);

        public Builder networkLoadBalancerArns(Collection<String> var1);

        public Builder networkLoadBalancerArns(String ... var1);

        public Builder gatewayLoadBalancerArns(Collection<String> var1);

        public Builder gatewayLoadBalancerArns(String ... var1);

        public Builder clientToken(String var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

