/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesResponse;
import software.amazon.awssdk.services.ec2.model.FpgaImage;

public class DescribeFpgaImagesPublisher
implements SdkPublisher<DescribeFpgaImagesResponse> {
    private final Ec2AsyncClient client;
    private final DescribeFpgaImagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeFpgaImagesPublisher(Ec2AsyncClient client, DescribeFpgaImagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeFpgaImagesPublisher(Ec2AsyncClient client, DescribeFpgaImagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeFpgaImagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeFpgaImagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FpgaImage> fpgaImages() {
        Function<DescribeFpgaImagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.fpgaImages() != null) {
                return response.fpgaImages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeFpgaImagesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeFpgaImagesResponseFetcher
    implements AsyncPageFetcher<DescribeFpgaImagesResponse> {
        private DescribeFpgaImagesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFpgaImagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeFpgaImagesResponse> nextPage(DescribeFpgaImagesResponse previousPage) {
            if (previousPage == null) {
                return DescribeFpgaImagesPublisher.this.client.describeFpgaImages(DescribeFpgaImagesPublisher.this.firstRequest);
            }
            return DescribeFpgaImagesPublisher.this.client.describeFpgaImages((DescribeFpgaImagesRequest)((Object)DescribeFpgaImagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

