/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The error codes and error messages that are returned for the parameters or parameter combinations that are not valid
 * when a new launch template or new version of a launch template is created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidationWarning implements SdkPojo, Serializable,
        ToCopyableBuilder<ValidationWarning.Builder, ValidationWarning> {
    private static final SdkField<List<ValidationError>> ERRORS_FIELD = SdkField
            .<List<ValidationError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(ValidationWarning::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorSet")
                    .unmarshallLocationName("errorSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ValidationError> builder(MarshallingType.SDK_POJO)
                                            .constructor(ValidationError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ValidationError> errors;

    private ValidationWarning(BuilderImpl builder) {
        this.errors = builder.errors;
    }

    /**
     * Returns true if the Errors property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The error codes and error messages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The error codes and error messages.
     */
    public final List<ValidationError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationWarning)) {
            return false;
        }
        ValidationWarning other = (ValidationWarning) obj;
        return hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidationWarning").add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidationWarning, T> g) {
        return obj -> g.apply((ValidationWarning) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidationWarning> {
        /**
         * <p>
         * The error codes and error messages.
         * </p>
         * 
         * @param errors
         *        The error codes and error messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<ValidationError> errors);

        /**
         * <p>
         * The error codes and error messages.
         * </p>
         * 
         * @param errors
         *        The error codes and error messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(ValidationError... errors);

        /**
         * <p>
         * The error codes and error messages.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ValidationError>.Builder} avoiding the need
         * to create one manually via {@link List<ValidationError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ValidationError>.Builder#build()} is called immediately and
         * its result is passed to {@link #errors(List<ValidationError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on {@link List<ValidationError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(List<ValidationError>)
         */
        Builder errors(Consumer<ValidationError.Builder>... errors);
    }

    static final class BuilderImpl implements Builder {
        private List<ValidationError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationWarning model) {
            errors(model.errors);
        }

        public final Collection<ValidationError.Builder> getErrors() {
            if (errors instanceof SdkAutoConstructList) {
                return null;
            }
            return errors != null ? errors.stream().map(ValidationError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<ValidationError> errors) {
            this.errors = ErrorSetCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(ValidationError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<ValidationError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> ValidationError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<ValidationError.BuilderImpl> errors) {
            this.errors = ErrorSetCopier.copyFromBuilder(errors);
        }

        @Override
        public ValidationWarning build() {
            return new ValidationWarning(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
