/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLocalGatewayVirtualInterfacesResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeLocalGatewayVirtualInterfacesResponse.Builder, DescribeLocalGatewayVirtualInterfacesResponse> {
    private static final SdkField<List<LocalGatewayVirtualInterface>> LOCAL_GATEWAY_VIRTUAL_INTERFACES_FIELD = SdkField
            .<List<LocalGatewayVirtualInterface>> builder(MarshallingType.LIST)
            .memberName("LocalGatewayVirtualInterfaces")
            .getter(getter(DescribeLocalGatewayVirtualInterfacesResponse::localGatewayVirtualInterfaces))
            .setter(setter(Builder::localGatewayVirtualInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayVirtualInterfaceSet")
                    .unmarshallLocationName("localGatewayVirtualInterfaceSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<LocalGatewayVirtualInterface> builder(MarshallingType.SDK_POJO)
                                            .constructor(LocalGatewayVirtualInterface::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeLocalGatewayVirtualInterfacesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LOCAL_GATEWAY_VIRTUAL_INTERFACES_FIELD, NEXT_TOKEN_FIELD));

    private final List<LocalGatewayVirtualInterface> localGatewayVirtualInterfaces;

    private final String nextToken;

    private DescribeLocalGatewayVirtualInterfacesResponse(BuilderImpl builder) {
        super(builder);
        this.localGatewayVirtualInterfaces = builder.localGatewayVirtualInterfaces;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the LocalGatewayVirtualInterfaces property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasLocalGatewayVirtualInterfaces() {
        return localGatewayVirtualInterfaces != null && !(localGatewayVirtualInterfaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the virtual interfaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLocalGatewayVirtualInterfaces()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the virtual interfaces.
     */
    public final List<LocalGatewayVirtualInterface> localGatewayVirtualInterfaces() {
        return localGatewayVirtualInterfaces;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLocalGatewayVirtualInterfaces() ? localGatewayVirtualInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocalGatewayVirtualInterfacesResponse)) {
            return false;
        }
        DescribeLocalGatewayVirtualInterfacesResponse other = (DescribeLocalGatewayVirtualInterfacesResponse) obj;
        return hasLocalGatewayVirtualInterfaces() == other.hasLocalGatewayVirtualInterfaces()
                && Objects.equals(localGatewayVirtualInterfaces(), other.localGatewayVirtualInterfaces())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeLocalGatewayVirtualInterfacesResponse")
                .add("LocalGatewayVirtualInterfaces", hasLocalGatewayVirtualInterfaces() ? localGatewayVirtualInterfaces() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocalGatewayVirtualInterfaces":
            return Optional.ofNullable(clazz.cast(localGatewayVirtualInterfaces()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLocalGatewayVirtualInterfacesResponse, T> g) {
        return obj -> g.apply((DescribeLocalGatewayVirtualInterfacesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeLocalGatewayVirtualInterfacesResponse> {
        /**
         * <p>
         * Information about the virtual interfaces.
         * </p>
         * 
         * @param localGatewayVirtualInterfaces
         *        Information about the virtual interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayVirtualInterfaces(Collection<LocalGatewayVirtualInterface> localGatewayVirtualInterfaces);

        /**
         * <p>
         * Information about the virtual interfaces.
         * </p>
         * 
         * @param localGatewayVirtualInterfaces
         *        Information about the virtual interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayVirtualInterfaces(LocalGatewayVirtualInterface... localGatewayVirtualInterfaces);

        /**
         * <p>
         * Information about the virtual interfaces.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LocalGatewayVirtualInterface>.Builder}
         * avoiding the need to create one manually via {@link List<LocalGatewayVirtualInterface>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LocalGatewayVirtualInterface>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #localGatewayVirtualInterfaces(List<LocalGatewayVirtualInterface>)}.
         * 
         * @param localGatewayVirtualInterfaces
         *        a consumer that will call methods on {@link List<LocalGatewayVirtualInterface>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localGatewayVirtualInterfaces(List<LocalGatewayVirtualInterface>)
         */
        Builder localGatewayVirtualInterfaces(Consumer<LocalGatewayVirtualInterface.Builder>... localGatewayVirtualInterfaces);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<LocalGatewayVirtualInterface> localGatewayVirtualInterfaces = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocalGatewayVirtualInterfacesResponse model) {
            super(model);
            localGatewayVirtualInterfaces(model.localGatewayVirtualInterfaces);
            nextToken(model.nextToken);
        }

        public final Collection<LocalGatewayVirtualInterface.Builder> getLocalGatewayVirtualInterfaces() {
            if (localGatewayVirtualInterfaces instanceof SdkAutoConstructList) {
                return null;
            }
            return localGatewayVirtualInterfaces != null ? localGatewayVirtualInterfaces.stream()
                    .map(LocalGatewayVirtualInterface::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder localGatewayVirtualInterfaces(Collection<LocalGatewayVirtualInterface> localGatewayVirtualInterfaces) {
            this.localGatewayVirtualInterfaces = LocalGatewayVirtualInterfaceSetCopier.copy(localGatewayVirtualInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localGatewayVirtualInterfaces(LocalGatewayVirtualInterface... localGatewayVirtualInterfaces) {
            localGatewayVirtualInterfaces(Arrays.asList(localGatewayVirtualInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localGatewayVirtualInterfaces(
                Consumer<LocalGatewayVirtualInterface.Builder>... localGatewayVirtualInterfaces) {
            localGatewayVirtualInterfaces(Stream.of(localGatewayVirtualInterfaces)
                    .map(c -> LocalGatewayVirtualInterface.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLocalGatewayVirtualInterfaces(
                Collection<LocalGatewayVirtualInterface.BuilderImpl> localGatewayVirtualInterfaces) {
            this.localGatewayVirtualInterfaces = LocalGatewayVirtualInterfaceSetCopier
                    .copyFromBuilder(localGatewayVirtualInterfaces);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeLocalGatewayVirtualInterfacesResponse build() {
            return new DescribeLocalGatewayVirtualInterfacesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
