/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstanceTypeOfferingsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeInstanceTypeOfferingsResponse.Builder, DescribeInstanceTypeOfferingsResponse> {
    private static final SdkField<List<InstanceTypeOffering>> INSTANCE_TYPE_OFFERINGS_FIELD = SdkField
            .<List<InstanceTypeOffering>> builder(MarshallingType.LIST)
            .memberName("InstanceTypeOfferings")
            .getter(getter(DescribeInstanceTypeOfferingsResponse::instanceTypeOfferings))
            .setter(setter(Builder::instanceTypeOfferings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTypeOfferingSet")
                    .unmarshallLocationName("instanceTypeOfferingSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceTypeOffering> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceTypeOffering::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeInstanceTypeOfferingsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_OFFERINGS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<InstanceTypeOffering> instanceTypeOfferings;

    private final String nextToken;

    private DescribeInstanceTypeOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.instanceTypeOfferings = builder.instanceTypeOfferings;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the InstanceTypeOfferings property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasInstanceTypeOfferings() {
        return instanceTypeOfferings != null && !(instanceTypeOfferings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The instance types offered.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstanceTypeOfferings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The instance types offered.
     */
    public final List<InstanceTypeOffering> instanceTypeOfferings() {
        return instanceTypeOfferings;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceTypeOfferings() ? instanceTypeOfferings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceTypeOfferingsResponse)) {
            return false;
        }
        DescribeInstanceTypeOfferingsResponse other = (DescribeInstanceTypeOfferingsResponse) obj;
        return hasInstanceTypeOfferings() == other.hasInstanceTypeOfferings()
                && Objects.equals(instanceTypeOfferings(), other.instanceTypeOfferings())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInstanceTypeOfferingsResponse")
                .add("InstanceTypeOfferings", hasInstanceTypeOfferings() ? instanceTypeOfferings() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceTypeOfferings":
            return Optional.ofNullable(clazz.cast(instanceTypeOfferings()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceTypeOfferingsResponse, T> g) {
        return obj -> g.apply((DescribeInstanceTypeOfferingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeInstanceTypeOfferingsResponse> {
        /**
         * <p>
         * The instance types offered.
         * </p>
         * 
         * @param instanceTypeOfferings
         *        The instance types offered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypeOfferings(Collection<InstanceTypeOffering> instanceTypeOfferings);

        /**
         * <p>
         * The instance types offered.
         * </p>
         * 
         * @param instanceTypeOfferings
         *        The instance types offered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypeOfferings(InstanceTypeOffering... instanceTypeOfferings);

        /**
         * <p>
         * The instance types offered.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceTypeOffering>.Builder} avoiding the
         * need to create one manually via {@link List<InstanceTypeOffering>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceTypeOffering>.Builder#build()} is called immediately
         * and its result is passed to {@link #instanceTypeOfferings(List<InstanceTypeOffering>)}.
         * 
         * @param instanceTypeOfferings
         *        a consumer that will call methods on {@link List<InstanceTypeOffering>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceTypeOfferings(List<InstanceTypeOffering>)
         */
        Builder instanceTypeOfferings(Consumer<InstanceTypeOffering.Builder>... instanceTypeOfferings);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<InstanceTypeOffering> instanceTypeOfferings = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceTypeOfferingsResponse model) {
            super(model);
            instanceTypeOfferings(model.instanceTypeOfferings);
            nextToken(model.nextToken);
        }

        public final Collection<InstanceTypeOffering.Builder> getInstanceTypeOfferings() {
            if (instanceTypeOfferings instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceTypeOfferings != null ? instanceTypeOfferings.stream().map(InstanceTypeOffering::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceTypeOfferings(Collection<InstanceTypeOffering> instanceTypeOfferings) {
            this.instanceTypeOfferings = InstanceTypeOfferingsListCopier.copy(instanceTypeOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeOfferings(InstanceTypeOffering... instanceTypeOfferings) {
            instanceTypeOfferings(Arrays.asList(instanceTypeOfferings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeOfferings(Consumer<InstanceTypeOffering.Builder>... instanceTypeOfferings) {
            instanceTypeOfferings(Stream.of(instanceTypeOfferings)
                    .map(c -> InstanceTypeOffering.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceTypeOfferings(Collection<InstanceTypeOffering.BuilderImpl> instanceTypeOfferings) {
            this.instanceTypeOfferings = InstanceTypeOfferingsListCopier.copyFromBuilder(instanceTypeOfferings);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInstanceTypeOfferingsResponse build() {
            return new DescribeInstanceTypeOfferingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
