/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CancelReservedInstancesListing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelReservedInstancesListingResponse extends Ec2Response implements
        ToCopyableBuilder<CancelReservedInstancesListingResponse.Builder, CancelReservedInstancesListingResponse> {
    private static final SdkField<List<ReservedInstancesListing>> RESERVED_INSTANCES_LISTINGS_FIELD = SdkField
            .<List<ReservedInstancesListing>> builder(MarshallingType.LIST)
            .memberName("ReservedInstancesListings")
            .getter(getter(CancelReservedInstancesListingResponse::reservedInstancesListings))
            .setter(setter(Builder::reservedInstancesListings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesListingsSet")
                    .unmarshallLocationName("reservedInstancesListingsSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ReservedInstancesListing> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReservedInstancesListing::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RESERVED_INSTANCES_LISTINGS_FIELD));

    private final List<ReservedInstancesListing> reservedInstancesListings;

    private CancelReservedInstancesListingResponse(BuilderImpl builder) {
        super(builder);
        this.reservedInstancesListings = builder.reservedInstancesListings;
    }

    /**
     * Returns true if the ReservedInstancesListings property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasReservedInstancesListings() {
        return reservedInstancesListings != null && !(reservedInstancesListings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Reserved Instance listing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReservedInstancesListings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Reserved Instance listing.
     */
    public final List<ReservedInstancesListing> reservedInstancesListings() {
        return reservedInstancesListings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasReservedInstancesListings() ? reservedInstancesListings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelReservedInstancesListingResponse)) {
            return false;
        }
        CancelReservedInstancesListingResponse other = (CancelReservedInstancesListingResponse) obj;
        return hasReservedInstancesListings() == other.hasReservedInstancesListings()
                && Objects.equals(reservedInstancesListings(), other.reservedInstancesListings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelReservedInstancesListingResponse")
                .add("ReservedInstancesListings", hasReservedInstancesListings() ? reservedInstancesListings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedInstancesListings":
            return Optional.ofNullable(clazz.cast(reservedInstancesListings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelReservedInstancesListingResponse, T> g) {
        return obj -> g.apply((CancelReservedInstancesListingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CancelReservedInstancesListingResponse> {
        /**
         * <p>
         * The Reserved Instance listing.
         * </p>
         * 
         * @param reservedInstancesListings
         *        The Reserved Instance listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesListings(Collection<ReservedInstancesListing> reservedInstancesListings);

        /**
         * <p>
         * The Reserved Instance listing.
         * </p>
         * 
         * @param reservedInstancesListings
         *        The Reserved Instance listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesListings(ReservedInstancesListing... reservedInstancesListings);

        /**
         * <p>
         * The Reserved Instance listing.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReservedInstancesListing>.Builder} avoiding
         * the need to create one manually via {@link List<ReservedInstancesListing>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReservedInstancesListing>.Builder#build()} is called
         * immediately and its result is passed to {@link #reservedInstancesListings(List<ReservedInstancesListing>)}.
         * 
         * @param reservedInstancesListings
         *        a consumer that will call methods on {@link List<ReservedInstancesListing>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservedInstancesListings(List<ReservedInstancesListing>)
         */
        Builder reservedInstancesListings(Consumer<ReservedInstancesListing.Builder>... reservedInstancesListings);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<ReservedInstancesListing> reservedInstancesListings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CancelReservedInstancesListingResponse model) {
            super(model);
            reservedInstancesListings(model.reservedInstancesListings);
        }

        public final Collection<ReservedInstancesListing.Builder> getReservedInstancesListings() {
            if (reservedInstancesListings instanceof SdkAutoConstructList) {
                return null;
            }
            return reservedInstancesListings != null ? reservedInstancesListings.stream()
                    .map(ReservedInstancesListing::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedInstancesListings(Collection<ReservedInstancesListing> reservedInstancesListings) {
            this.reservedInstancesListings = ReservedInstancesListingListCopier.copy(reservedInstancesListings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesListings(ReservedInstancesListing... reservedInstancesListings) {
            reservedInstancesListings(Arrays.asList(reservedInstancesListings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesListings(Consumer<ReservedInstancesListing.Builder>... reservedInstancesListings) {
            reservedInstancesListings(Stream.of(reservedInstancesListings)
                    .map(c -> ReservedInstancesListing.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReservedInstancesListings(Collection<ReservedInstancesListing.BuilderImpl> reservedInstancesListings) {
            this.reservedInstancesListings = ReservedInstancesListingListCopier.copyFromBuilder(reservedInstancesListings);
        }

        @Override
        public CancelReservedInstancesListingResponse build() {
            return new CancelReservedInstancesListingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
