/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TransitGatewayRoute;
import software.amazon.awssdk.services.ec2.model.TransitGatewayRouteListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchTransitGatewayRoutesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, SearchTransitGatewayRoutesResponse> {
    private static final SdkField<List<TransitGatewayRoute>> ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Routes").getter(SearchTransitGatewayRoutesResponse.getter(SearchTransitGatewayRoutesResponse::routes)).setter(SearchTransitGatewayRoutesResponse.setter(Builder::routes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteSet").unmarshallLocationName("routeSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransitGatewayRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ADDITIONAL_ROUTES_AVAILABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AdditionalRoutesAvailable").getter(SearchTransitGatewayRoutesResponse.getter(SearchTransitGatewayRoutesResponse::additionalRoutesAvailable)).setter(SearchTransitGatewayRoutesResponse.setter(Builder::additionalRoutesAvailable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalRoutesAvailable").unmarshallLocationName("additionalRoutesAvailable").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTES_FIELD, ADDITIONAL_ROUTES_AVAILABLE_FIELD));
    private final List<TransitGatewayRoute> routes;
    private final Boolean additionalRoutesAvailable;

    private SearchTransitGatewayRoutesResponse(BuilderImpl builder) {
        super(builder);
        this.routes = builder.routes;
        this.additionalRoutesAvailable = builder.additionalRoutesAvailable;
    }

    public boolean hasRoutes() {
        return this.routes != null && !(this.routes instanceof SdkAutoConstructList);
    }

    public List<TransitGatewayRoute> routes() {
        return this.routes;
    }

    public Boolean additionalRoutesAvailable() {
        return this.additionalRoutesAvailable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.routes());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalRoutesAvailable());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTransitGatewayRoutesResponse)) {
            return false;
        }
        SearchTransitGatewayRoutesResponse other = (SearchTransitGatewayRoutesResponse)((Object)obj);
        return Objects.equals(this.routes(), other.routes()) && Objects.equals(this.additionalRoutesAvailable(), other.additionalRoutesAvailable());
    }

    public String toString() {
        return ToString.builder((String)"SearchTransitGatewayRoutesResponse").add("Routes", this.routes()).add("AdditionalRoutesAvailable", (Object)this.additionalRoutesAvailable()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Routes": {
                return Optional.ofNullable(clazz.cast(this.routes()));
            }
            case "AdditionalRoutesAvailable": {
                return Optional.ofNullable(clazz.cast(this.additionalRoutesAvailable()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchTransitGatewayRoutesResponse, T> g) {
        return obj -> g.apply((SearchTransitGatewayRoutesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<TransitGatewayRoute> routes = DefaultSdkAutoConstructList.getInstance();
        private Boolean additionalRoutesAvailable;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchTransitGatewayRoutesResponse model) {
            super(model);
            this.routes(model.routes);
            this.additionalRoutesAvailable(model.additionalRoutesAvailable);
        }

        public final Collection<TransitGatewayRoute.Builder> getRoutes() {
            return this.routes != null ? (Collection)this.routes.stream().map(TransitGatewayRoute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder routes(Collection<TransitGatewayRoute> routes) {
            this.routes = TransitGatewayRouteListCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(TransitGatewayRoute ... routes) {
            this.routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<TransitGatewayRoute.Builder> ... routes) {
            this.routes(Stream.of(routes).map(c -> (TransitGatewayRoute)((TransitGatewayRoute.Builder)TransitGatewayRoute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRoutes(Collection<TransitGatewayRoute.BuilderImpl> routes) {
            this.routes = TransitGatewayRouteListCopier.copyFromBuilder(routes);
        }

        public final Boolean getAdditionalRoutesAvailable() {
            return this.additionalRoutesAvailable;
        }

        @Override
        public final Builder additionalRoutesAvailable(Boolean additionalRoutesAvailable) {
            this.additionalRoutesAvailable = additionalRoutesAvailable;
            return this;
        }

        public final void setAdditionalRoutesAvailable(Boolean additionalRoutesAvailable) {
            this.additionalRoutesAvailable = additionalRoutesAvailable;
        }

        @Override
        public SearchTransitGatewayRoutesResponse build() {
            return new SearchTransitGatewayRoutesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchTransitGatewayRoutesResponse> {
        public Builder routes(Collection<TransitGatewayRoute> var1);

        public Builder routes(TransitGatewayRoute ... var1);

        public Builder routes(Consumer<TransitGatewayRoute.Builder> ... var1);

        public Builder additionalRoutesAvailable(Boolean var1);
    }
}

