/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateVersion;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateVersionSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLaunchTemplateVersionsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeLaunchTemplateVersionsResponse> {
    private static final SdkField<List<LaunchTemplateVersion>> LAUNCH_TEMPLATE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LaunchTemplateVersions").getter(DescribeLaunchTemplateVersionsResponse.getter(DescribeLaunchTemplateVersionsResponse::launchTemplateVersions)).setter(DescribeLaunchTemplateVersionsResponse.setter(Builder::launchTemplateVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateVersionSet").unmarshallLocationName("launchTemplateVersionSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchTemplateVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeLaunchTemplateVersionsResponse.getter(DescribeLaunchTemplateVersionsResponse::nextToken)).setter(DescribeLaunchTemplateVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_VERSIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<LaunchTemplateVersion> launchTemplateVersions;
    private final String nextToken;

    private DescribeLaunchTemplateVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.launchTemplateVersions = builder.launchTemplateVersions;
        this.nextToken = builder.nextToken;
    }

    public boolean hasLaunchTemplateVersions() {
        return this.launchTemplateVersions != null && !(this.launchTemplateVersions instanceof SdkAutoConstructList);
    }

    public List<LaunchTemplateVersion> launchTemplateVersions() {
        return this.launchTemplateVersions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateVersions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLaunchTemplateVersionsResponse)) {
            return false;
        }
        DescribeLaunchTemplateVersionsResponse other = (DescribeLaunchTemplateVersionsResponse)((Object)obj);
        return Objects.equals(this.launchTemplateVersions(), other.launchTemplateVersions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLaunchTemplateVersionsResponse").add("LaunchTemplateVersions", this.launchTemplateVersions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchTemplateVersions": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateVersions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLaunchTemplateVersionsResponse, T> g) {
        return obj -> g.apply((DescribeLaunchTemplateVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<LaunchTemplateVersion> launchTemplateVersions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLaunchTemplateVersionsResponse model) {
            super(model);
            this.launchTemplateVersions(model.launchTemplateVersions);
            this.nextToken(model.nextToken);
        }

        public final Collection<LaunchTemplateVersion.Builder> getLaunchTemplateVersions() {
            return this.launchTemplateVersions != null ? (Collection)this.launchTemplateVersions.stream().map(LaunchTemplateVersion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder launchTemplateVersions(Collection<LaunchTemplateVersion> launchTemplateVersions) {
            this.launchTemplateVersions = LaunchTemplateVersionSetCopier.copy(launchTemplateVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateVersions(LaunchTemplateVersion ... launchTemplateVersions) {
            this.launchTemplateVersions(Arrays.asList(launchTemplateVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateVersions(Consumer<LaunchTemplateVersion.Builder> ... launchTemplateVersions) {
            this.launchTemplateVersions(Stream.of(launchTemplateVersions).map(c -> (LaunchTemplateVersion)((LaunchTemplateVersion.Builder)LaunchTemplateVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLaunchTemplateVersions(Collection<LaunchTemplateVersion.BuilderImpl> launchTemplateVersions) {
            this.launchTemplateVersions = LaunchTemplateVersionSetCopier.copyFromBuilder(launchTemplateVersions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeLaunchTemplateVersionsResponse build() {
            return new DescribeLaunchTemplateVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLaunchTemplateVersionsResponse> {
        public Builder launchTemplateVersions(Collection<LaunchTemplateVersion> var1);

        public Builder launchTemplateVersions(LaunchTemplateVersion ... var1);

        public Builder launchTemplateVersions(Consumer<LaunchTemplateVersion.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

