/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesLaunchSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RunScheduledInstancesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, RunScheduledInstancesRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(RunScheduledInstancesRequest.getter(RunScheduledInstancesRequest::clientToken)).setter(RunScheduledInstancesRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(RunScheduledInstancesRequest.getter(RunScheduledInstancesRequest::instanceCount)).setter(RunScheduledInstancesRequest.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").unmarshallLocationName("InstanceCount").build()}).build();
    private static final SdkField<ScheduledInstancesLaunchSpecification> LAUNCH_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LaunchSpecification").getter(RunScheduledInstancesRequest.getter(RunScheduledInstancesRequest::launchSpecification)).setter(RunScheduledInstancesRequest.setter(Builder::launchSpecification)).constructor(ScheduledInstancesLaunchSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchSpecification").unmarshallLocationName("LaunchSpecification").build()}).build();
    private static final SdkField<String> SCHEDULED_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduledInstanceId").getter(RunScheduledInstancesRequest.getter(RunScheduledInstancesRequest::scheduledInstanceId)).setter(RunScheduledInstancesRequest.setter(Builder::scheduledInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledInstanceId").unmarshallLocationName("ScheduledInstanceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, INSTANCE_COUNT_FIELD, LAUNCH_SPECIFICATION_FIELD, SCHEDULED_INSTANCE_ID_FIELD));
    private final String clientToken;
    private final Integer instanceCount;
    private final ScheduledInstancesLaunchSpecification launchSpecification;
    private final String scheduledInstanceId;

    private RunScheduledInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.instanceCount = builder.instanceCount;
        this.launchSpecification = builder.launchSpecification;
        this.scheduledInstanceId = builder.scheduledInstanceId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public final ScheduledInstancesLaunchSpecification launchSpecification() {
        return this.launchSpecification;
    }

    public final String scheduledInstanceId() {
        return this.scheduledInstanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledInstanceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunScheduledInstancesRequest)) {
            return false;
        }
        RunScheduledInstancesRequest other = (RunScheduledInstancesRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.launchSpecification(), other.launchSpecification()) && Objects.equals(this.scheduledInstanceId(), other.scheduledInstanceId());
    }

    public final String toString() {
        return ToString.builder((String)"RunScheduledInstancesRequest").add("ClientToken", (Object)this.clientToken()).add("InstanceCount", (Object)this.instanceCount()).add("LaunchSpecification", (Object)this.launchSpecification()).add("ScheduledInstanceId", (Object)this.scheduledInstanceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "LaunchSpecification": {
                return Optional.ofNullable(clazz.cast(this.launchSpecification()));
            }
            case "ScheduledInstanceId": {
                return Optional.ofNullable(clazz.cast(this.scheduledInstanceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RunScheduledInstancesRequest, T> g) {
        return obj -> g.apply((RunScheduledInstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String clientToken;
        private Integer instanceCount;
        private ScheduledInstancesLaunchSpecification launchSpecification;
        private String scheduledInstanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(RunScheduledInstancesRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.instanceCount(model.instanceCount);
            this.launchSpecification(model.launchSpecification);
            this.scheduledInstanceId(model.scheduledInstanceId);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final ScheduledInstancesLaunchSpecification.Builder getLaunchSpecification() {
            return this.launchSpecification != null ? this.launchSpecification.toBuilder() : null;
        }

        @Override
        public final Builder launchSpecification(ScheduledInstancesLaunchSpecification launchSpecification) {
            this.launchSpecification = launchSpecification;
            return this;
        }

        public final void setLaunchSpecification(ScheduledInstancesLaunchSpecification.BuilderImpl launchSpecification) {
            this.launchSpecification = launchSpecification != null ? launchSpecification.build() : null;
        }

        public final String getScheduledInstanceId() {
            return this.scheduledInstanceId;
        }

        @Override
        public final Builder scheduledInstanceId(String scheduledInstanceId) {
            this.scheduledInstanceId = scheduledInstanceId;
            return this;
        }

        public final void setScheduledInstanceId(String scheduledInstanceId) {
            this.scheduledInstanceId = scheduledInstanceId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RunScheduledInstancesRequest build() {
            return new RunScheduledInstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RunScheduledInstancesRequest> {
        public Builder clientToken(String var1);

        public Builder instanceCount(Integer var1);

        public Builder launchSpecification(ScheduledInstancesLaunchSpecification var1);

        default public Builder launchSpecification(Consumer<ScheduledInstancesLaunchSpecification.Builder> launchSpecification) {
            return this.launchSpecification((ScheduledInstancesLaunchSpecification)((ScheduledInstancesLaunchSpecification.Builder)ScheduledInstancesLaunchSpecification.builder().applyMutation(launchSpecification)).build());
        }

        public Builder scheduledInstanceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

