/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.DnsNameState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PrivateDnsNameConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PrivateDnsNameConfiguration> {
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(PrivateDnsNameConfiguration.getter(PrivateDnsNameConfiguration::stateAsString)).setter(PrivateDnsNameConfiguration.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(PrivateDnsNameConfiguration.getter(PrivateDnsNameConfiguration::type)).setter(PrivateDnsNameConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("type").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(PrivateDnsNameConfiguration.getter(PrivateDnsNameConfiguration::value)).setter(PrivateDnsNameConfiguration.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").unmarshallLocationName("value").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(PrivateDnsNameConfiguration.getter(PrivateDnsNameConfiguration::name)).setter(PrivateDnsNameConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, TYPE_FIELD, VALUE_FIELD, NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String state;
    private final String type;
    private final String value;
    private final String name;

    private PrivateDnsNameConfiguration(BuilderImpl builder) {
        this.state = builder.state;
        this.type = builder.type;
        this.value = builder.value;
        this.name = builder.name;
    }

    public final DnsNameState state() {
        return DnsNameState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String type() {
        return this.type;
    }

    public final String value() {
        return this.value;
    }

    public final String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivateDnsNameConfiguration)) {
            return false;
        }
        PrivateDnsNameConfiguration other = (PrivateDnsNameConfiguration)obj;
        return Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"PrivateDnsNameConfiguration").add("State", (Object)this.stateAsString()).add("Type", (Object)this.type()).add("Value", (Object)this.value()).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PrivateDnsNameConfiguration, T> g) {
        return obj -> g.apply((PrivateDnsNameConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private String type;
        private String value;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(PrivateDnsNameConfiguration model) {
            this.state(model.state);
            this.type(model.type);
            this.value(model.value);
            this.name(model.name);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DnsNameState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public PrivateDnsNameConfiguration build() {
            return new PrivateDnsNameConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PrivateDnsNameConfiguration> {
        public Builder state(String var1);

        public Builder state(DnsNameState var1);

        public Builder type(String var1);

        public Builder value(String var1);

        public Builder name(String var1);
    }
}

